/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.CustomParserUtils;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards.CustomTxtParserWizard;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards.CustomXmlParserWizard;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;

public class ManageCustomParsersDialog
extends Dialog {
    private static final String SEP = " : ";
    private static final int SEP_LEN = " : ".length();
    private static final Image image = Activator.getDefault().getImageFromPath("/icons/etool16/customparser_wizard.gif");
    Button txtButton;
    Button xmlButton;
    List parserList;
    Button newButton;
    Button editButton;
    Button deleteButton;
    Button importButton;
    Button exportButton;

    public ManageCustomParsersDialog(Shell parent) {
        super(parent);
        this.setShellStyle(0x410 | this.getShellStyle());
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ManageCustomParsersDialog_DialogHeader);
        this.getShell().setImage(image);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite listContainer = new Composite(composite, 0);
        listContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout lcgl = new GridLayout();
        lcgl.marginHeight = 0;
        lcgl.marginWidth = 0;
        listContainer.setLayout((Layout)lcgl);
        Composite radioContainer = new Composite(listContainer, 0);
        GridLayout rcgl = new GridLayout(2, true);
        rcgl.marginHeight = 0;
        rcgl.marginWidth = 0;
        radioContainer.setLayout((Layout)rcgl);
        this.txtButton = new Button(radioContainer, 16);
        this.txtButton.setText(Messages.ManageCustomParsersDialog_TextButtonLabel);
        this.txtButton.setSelection(true);
        this.txtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ManageCustomParsersDialog.this.fillParserList();
            }
        });
        this.xmlButton = new Button(radioContainer, 16);
        this.xmlButton.setText("XML");
        this.xmlButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ManageCustomParsersDialog.this.fillParserList();
            }
        });
        this.parserList = new List(listContainer, 2820);
        this.parserList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.parserList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ManageCustomParsersDialog.this.parserList.getSelectionCount() == 0) {
                    ManageCustomParsersDialog.this.editButton.setEnabled(false);
                    ManageCustomParsersDialog.this.deleteButton.setEnabled(false);
                    ManageCustomParsersDialog.this.exportButton.setEnabled(false);
                } else {
                    ManageCustomParsersDialog.this.editButton.setEnabled(true);
                    ManageCustomParsersDialog.this.deleteButton.setEnabled(true);
                    ManageCustomParsersDialog.this.exportButton.setEnabled(true);
                }
            }
        });
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.newButton = new Button(buttonContainer, 8);
        this.newButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.newButton.setText(Messages.ManageCustomParsersDialog_NewButtonLabel);
        this.newButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WizardDialog dialog = null;
                if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                    dialog = new WizardDialog(ManageCustomParsersDialog.this.getShell(), (IWizard)new CustomTxtParserWizard());
                } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                    dialog = new WizardDialog(ManageCustomParsersDialog.this.getShell(), (IWizard)new CustomXmlParserWizard());
                }
                if (dialog != null) {
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        ManageCustomParsersDialog.this.fillParserList();
                    }
                }
            }
        });
        this.editButton = new Button(buttonContainer, 8);
        this.editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.editButton.setText(Messages.ManageCustomParsersDialog_EditButtonLabel);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WizardDialog dialog = null;
                String selection = ManageCustomParsersDialog.this.parserList.getSelection()[0];
                String category = selection.substring(0, selection.indexOf(ManageCustomParsersDialog.SEP));
                String name = selection.substring(selection.indexOf(ManageCustomParsersDialog.SEP) + SEP_LEN);
                if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                    dialog = new WizardDialog(ManageCustomParsersDialog.this.getShell(), (IWizard)new CustomTxtParserWizard(CustomTxtTraceDefinition.load((String)category, (String)name)));
                } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                    dialog = new WizardDialog(ManageCustomParsersDialog.this.getShell(), (IWizard)new CustomXmlParserWizard(CustomXmlTraceDefinition.load((String)category, (String)name)));
                }
                if (dialog != null) {
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        ManageCustomParsersDialog.this.fillParserList();
                    }
                }
            }
        });
        this.deleteButton = new Button(buttonContainer, 8);
        this.deleteButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.deleteButton.setText(Messages.ManageCustomParsersDialog_DeleteButtonLabel);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean confirm = MessageDialog.openQuestion((Shell)ManageCustomParsersDialog.this.getShell(), (String)Messages.ManageCustomParsersDialog_DeleteParserDialogHeader, (String)NLS.bind((String)Messages.ManageCustomParsersDialog_DeleteConfirmation, (Object)ManageCustomParsersDialog.this.parserList.getSelection()[0]));
                if (confirm) {
                    String selection = ManageCustomParsersDialog.this.parserList.getSelection()[0];
                    String category = selection.substring(0, selection.indexOf(ManageCustomParsersDialog.SEP));
                    String name = selection.substring(selection.indexOf(ManageCustomParsersDialog.SEP) + SEP_LEN);
                    if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                        CustomTxtTraceDefinition.delete((String)category, (String)name);
                        CustomParserUtils.cleanup(CustomTxtTrace.buildTraceTypeId((String)category, (String)name));
                    } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                        CustomXmlTraceDefinition.delete((String)category, (String)name);
                        CustomParserUtils.cleanup(CustomXmlTrace.buildTraceTypeId((String)category, (String)name));
                    }
                    ManageCustomParsersDialog.this.fillParserList();
                }
            }
        });
        new Label(buttonContainer, 0);
        this.importButton = new Button(buttonContainer, 8);
        this.importButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.importButton.setText(Messages.ManageCustomParsersDialog_ImportButtonLabel);
        this.importButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = TmfFileDialogFactory.create(Display.getCurrent().getActiveShell(), 4096);
                dialog.setText(Messages.ManageCustomParsersDialog_ImportParserSelection);
                dialog.setFilterExtensions(new String[]{"*.xml", "*"});
                String path = dialog.open();
                if (path != null) {
                    CustomTxtTraceDefinition[] defs = null;
                    if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                        defs = CustomTxtTraceDefinition.loadAll((String)path);
                    } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                        defs = CustomXmlTraceDefinition.loadAll((String)path);
                    }
                    if (defs != null && defs.length > 0) {
                        CustomTxtTraceDefinition[] customTxtTraceDefinitionArray = defs;
                        int n = defs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n2];
                            boolean ok = ManageCustomParsersDialog.this.checkNameConflict((CustomTraceDefinition)def);
                            if (ok) {
                                def.save();
                                CustomParserUtils.cleanup(CustomTxtTrace.buildTraceTypeId((String)def.categoryName, (String)def.definitionName));
                            }
                            ++n2;
                        }
                        ManageCustomParsersDialog.this.fillParserList();
                    } else {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ManageCustomParsersDialog_ImportFailureTitle, (String)Messages.ManageCustomParsersDialog_ImportFailureMessage);
                    }
                }
            }
        });
        this.exportButton = new Button(buttonContainer, 8);
        this.exportButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.exportButton.setText(Messages.ManageCustomParsersDialog_ExportButtonLabel);
        this.exportButton.setEnabled(false);
        this.exportButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = TmfFileDialogFactory.create(Display.getCurrent().getActiveShell(), 8192);
                dialog.setText(NLS.bind((String)Messages.ManageCustomParsersDialog_ExportParserSelection, (Object)ManageCustomParsersDialog.this.parserList.getSelection()[0]));
                dialog.setFilterExtensions(new String[]{"*.xml", "*"});
                String path = dialog.open();
                if (path != null) {
                    String selection = ManageCustomParsersDialog.this.parserList.getSelection()[0];
                    String category = selection.substring(0, selection.indexOf(ManageCustomParsersDialog.SEP));
                    String name = selection.substring(selection.indexOf(ManageCustomParsersDialog.SEP) + SEP_LEN);
                    CustomTxtTraceDefinition def = null;
                    if (ManageCustomParsersDialog.this.txtButton.getSelection()) {
                        def = CustomTxtTraceDefinition.load((String)category, (String)name);
                    } else if (ManageCustomParsersDialog.this.xmlButton.getSelection()) {
                        def = CustomXmlTraceDefinition.load((String)category, (String)name);
                    }
                    if (def != null) {
                        def.save(path);
                    }
                }
            }
        });
        this.fillParserList();
        this.getShell().setMinimumSize(300, 275);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, false);
    }

    private void fillParserList() {
        this.parserList.removeAll();
        if (this.txtButton.getSelection()) {
            CustomTxtTraceDefinition[] customTxtTraceDefinitionArray = CustomTxtTraceDefinition.loadAll((boolean)false);
            int n = customTxtTraceDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n2];
                this.parserList.add(def.categoryName + SEP + def.definitionName);
                ++n2;
            }
        } else if (this.xmlButton.getSelection()) {
            CustomXmlTraceDefinition[] customXmlTraceDefinitionArray = CustomXmlTraceDefinition.loadAll((boolean)false);
            int n = customXmlTraceDefinitionArray.length;
            int n3 = 0;
            while (n3 < n) {
                CustomXmlTraceDefinition def = customXmlTraceDefinitionArray[n3];
                this.parserList.add(def.categoryName + SEP + def.definitionName);
                ++n3;
            }
        }
        this.editButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.exportButton.setEnabled(false);
    }

    private boolean checkNameConflict(CustomTraceDefinition def) {
        for (TraceTypeHelper helper : TmfTraceType.getTraceTypeHelpers()) {
            if (!def.categoryName.equals(helper.getCategoryName()) || !def.definitionName.equals(helper.getName())) continue;
            String newName = ManageCustomParsersDialog.findAvailableName(def);
            MessageDialog dialog = new MessageDialog(this.getShell(), null, null, NLS.bind((String)Messages.ManageCustomParsersDialog_ConflictMessage, (Object[])new Object[]{def.categoryName, def.definitionName, newName}), 3, new String[]{Messages.ManageCustomParsersDialog_ConflictRenameButtonLabel, Messages.ManageCustomParsersDialog_ConflictSkipButtonLabel}, 0);
            int result = dialog.open();
            if (result == 0) {
                def.definitionName = newName;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String findAvailableName(CustomTraceDefinition def) {
        String newName;
        boolean available;
        int i = 2;
        Iterable helpers = TmfTraceType.getTraceTypeHelpers();
        block0: do {
            newName = def.definitionName + "(" + Integer.toString(i++) + ")";
            available = true;
            for (TraceTypeHelper helper : helpers) {
                if (!def.categoryName.equals(helper.getCategoryName()) || !newName.equals(helper.getName())) continue;
                available = false;
                continue block0;
            }
        } while (!available);
        return newName;
    }
}

