/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.streams;

import org.eclipse.core.runtime.Assert;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalControl;
import org.eclipse.terminal.connector.NullSettingsStore;
import org.eclipse.terminal.connector.TerminalState;
import org.eclipse.terminal.view.ui.streams.AbstractStreamsConnector;
import org.eclipse.terminal.view.ui.streams.StreamsSettings;
import org.eclipse.ui.services.IDisposable;

public class StreamsConnector
extends AbstractStreamsConnector
implements IDisposable {
    private final StreamsSettings settings;

    public StreamsConnector() {
        this(new StreamsSettings());
    }

    public StreamsConnector(StreamsSettings settings) {
        Assert.isNotNull((Object)settings);
        this.settings = settings;
    }

    public void connect(ITerminalControl control) {
        Assert.isNotNull((Object)control);
        super.connect(control);
        this.setStdoutListeners(this.settings.getStdOutListeners());
        this.setStderrListeners(this.settings.getStdErrListeners());
        this.connectStreams(control, this.settings.getStdinStream(), this.settings.getStdoutStream(), this.settings.getStderrStream(), this.settings.isLocalEcho(), this.settings.getLineSeparator());
        control.setState(TerminalState.CONNECTED);
    }

    public boolean isLocalEcho() {
        return this.settings.isLocalEcho();
    }

    public void dispose() {
        this.disconnect();
    }

    @Override
    public void doDisconnect() {
        super.doDisconnect();
        this.fControl.setState(TerminalState.CLOSED);
    }

    public String getSettingsSummary() {
        return "";
    }

    public void setDefaultSettings() {
        this.settings.load((ISettingsStore)new NullSettingsStore());
    }

    public void load(ISettingsStore store) {
        this.settings.load(store);
    }

    public void save(ISettingsStore store) {
        this.settings.save(store);
    }
}

