"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-mcp_lib_browser_mcp-frontend-module_js"],{

/***/ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-command-contribution.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-mcp/lib/browser/mcp-command-contribution.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MCPCommandContribution = exports.StopMCPServer = exports.StartMCPServer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const ai_command_handler_factory_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/ai-command-handler-factory */ "../../node_modules/@theia/ai-core/lib/browser/ai-command-handler-factory.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const mcp_server_manager_1 = __webpack_require__(/*! ../common/mcp-server-manager */ "../../node_modules/@theia/ai-mcp/lib/common/mcp-server-manager.js");
exports.StartMCPServer = {
    id: 'mcp.startserver',
    label: core_1.nls.localize('theia/ai/mcp/start/label', 'MCP: Start MCP Server'),
};
exports.StopMCPServer = {
    id: 'mcp.stopserver',
    label: core_1.nls.localize('theia/ai/mcp/stop/label', 'MCP: Stop MCP Server'),
};
let MCPCommandContribution = class MCPCommandContribution {
    async getMCPServerSelection(serverNames) {
        if (!serverNames || serverNames.length === 0) {
            return undefined;
        }
        const options = serverNames.map(mcpServerName => ({ label: mcpServerName }));
        const result = await this.quickInputService.showQuickPick(options);
        return result === null || result === void 0 ? void 0 : result.label;
    }
    registerCommands(commandRegistry) {
        commandRegistry.registerCommand(exports.StopMCPServer, this.commandHandlerFactory({
            execute: async () => {
                try {
                    const startedServers = await this.mcpFrontendService.getStartedServers();
                    if (!startedServers || startedServers.length === 0) {
                        this.messageService.error(core_1.nls.localize('theia/ai/mcp/error/noRunningServers', 'No MCP servers running.'));
                        return;
                    }
                    const selection = await this.getMCPServerSelection(startedServers);
                    if (!selection) {
                        return;
                    }
                    await this.mcpFrontendService.stopServer(selection);
                }
                catch (error) {
                    console.error('Error while stopping MCP server:', error);
                }
            }
        }));
        commandRegistry.registerCommand(exports.StartMCPServer, this.commandHandlerFactory({
            execute: async () => {
                try {
                    const servers = await this.mcpFrontendService.getServerNames();
                    const startedServers = await this.mcpFrontendService.getStartedServers();
                    const startableServers = servers.filter(server => !startedServers.includes(server));
                    if (!startableServers || startableServers.length === 0) {
                        if (startedServers && startedServers.length > 0) {
                            this.messageService.error(core_1.nls.localize('theia/ai/mcp/error/allServersRunning', 'All MCP servers are already running.'));
                        }
                        else {
                            this.messageService.error(core_1.nls.localize('theia/ai/mcp/error/noServersConfigured', 'No MCP servers configured.'));
                        }
                        return;
                    }
                    const selection = await this.getMCPServerSelection(startableServers);
                    if (!selection) {
                        return;
                    }
                    await this.mcpFrontendService.startServer(selection);
                    const serverDescription = await this.mcpFrontendService.getServerDescription(selection);
                    if (serverDescription && serverDescription.status) {
                        if (serverDescription.status === mcp_server_manager_1.MCPServerStatus.Running) {
                            let toolNames = undefined;
                            if (serverDescription.tools) {
                                toolNames = serverDescription.tools.map(tool => tool.name).join(',');
                            }
                            this.messageService.info(core_1.nls.localize('theia/ai/mcp/info/serverStarted', 'MCP server "{0}" successfully started. Registered tools: {1}', selection, toolNames ||
                                core_1.nls.localize('theia/ai/mcp/tool/noTools', 'No tools available.')));
                            return;
                        }
                        if (serverDescription.error) {
                            console.error('Error while starting MCP server:', serverDescription.error);
                        }
                    }
                    this.messageService.error(core_1.nls.localize('theia/ai/mcp/error/startFailed', 'An error occurred while starting the MCP server.'));
                }
                catch (error) {
                    this.messageService.error(core_1.nls.localize('theia/ai/mcp/error/startFailed', 'An error occurred while starting the MCP server.'));
                    console.error('Error while starting MCP server:', error);
                }
            }
        }));
    }
};
exports.MCPCommandContribution = MCPCommandContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_command_handler_factory_1.AICommandHandlerFactory),
    tslib_1.__metadata("design:type", Function)
], MCPCommandContribution.prototype, "commandHandlerFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], MCPCommandContribution.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    tslib_1.__metadata("design:type", core_1.MessageService)
], MCPCommandContribution.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(mcp_server_manager_1.MCPFrontendService),
    tslib_1.__metadata("design:type", Object)
], MCPCommandContribution.prototype, "mcpFrontendService", void 0);
exports.MCPCommandContribution = MCPCommandContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], MCPCommandContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-application-contribution.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-application-contribution.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.McpFrontendApplicationContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-mcp/lib/common/index.js");
const mcp_preferences_1 = __webpack_require__(/*! ./mcp-preferences */ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-preferences.js");
const mcp_server_manager_1 = __webpack_require__(/*! ../common/mcp-server-manager */ "../../node_modules/@theia/ai-mcp/lib/common/mcp-server-manager.js");
;
;
var MCPServersPreference;
(function (MCPServersPreference) {
    function isValue(obj) {
        return !!obj && typeof obj === 'object' &&
            'command' in obj && typeof obj.command === 'string' &&
            (!('args' in obj) || Array.isArray(obj.args) && obj.args.every(arg => typeof arg === 'string')) &&
            (!('env' in obj) || !!obj.env && typeof obj.env === 'object' && Object.values(obj.env).every(value => typeof value === 'string')) &&
            (!('autostart' in obj) || typeof obj.autostart === 'boolean');
    }
    MCPServersPreference.isValue = isValue;
})(MCPServersPreference || (MCPServersPreference = {}));
function filterValidValues(servers) {
    const result = {};
    if (!servers || typeof servers !== 'object') {
        return result;
    }
    for (const [name, value] of Object.entries(servers)) {
        if (typeof name === 'string' && MCPServersPreference.isValue(value)) {
            result[name] = value;
        }
    }
    return result;
}
let McpFrontendApplicationContribution = class McpFrontendApplicationContribution {
    constructor() {
        this.prevServers = new Map();
    }
    onStart() {
        this.preferenceService.ready.then(() => {
            const servers = filterValidValues(this.preferenceService.get(mcp_preferences_1.MCP_SERVERS_PREF, {}));
            this.prevServers = this.convertToMap(servers);
            this.syncServers(this.prevServers);
            this.autoStartServers(this.prevServers);
            this.preferenceService.onPreferenceChanged(event => {
                if (event.preferenceName === mcp_preferences_1.MCP_SERVERS_PREF) {
                    this.handleServerChanges(filterValidValues(event.newValue));
                }
            });
        });
        this.frontendMCPService.registerToolsForAllStartedServers();
    }
    async autoStartServers(servers) {
        const startedServers = await this.frontendMCPService.getStartedServers();
        for (const [name, serverDesc] of servers) {
            if (serverDesc && serverDesc.autostart) {
                if (!startedServers.includes(name)) {
                    await this.frontendMCPService.startServer(name);
                }
            }
        }
    }
    handleServerChanges(newServers) {
        const oldServers = this.prevServers;
        const updatedServers = this.convertToMap(newServers);
        for (const [name] of oldServers) {
            if (!updatedServers.has(name)) {
                this.manager.removeServer(name);
            }
        }
        for (const [name, description] of updatedServers) {
            const oldDescription = oldServers.get(name);
            let diff = false;
            try {
                // We know that that the descriptions are actual JSONObjects as we construct them ourselves
                if (!oldDescription || !browser_1.PreferenceProvider.deepEqual(oldDescription, description)) {
                    diff = true;
                }
            }
            catch (e) {
                // In some cases the deepEqual function throws an error, so we fall back to assuming that there is a difference
                // This seems to happen in cases where the objects are structured differently, e.g. whole sub-objects are missing
                console.debug('Failed to compare MCP server descriptions, assuming a difference', e);
                diff = true;
            }
            if (diff) {
                this.manager.addOrUpdateServer(description);
            }
        }
        this.prevServers = updatedServers;
    }
    syncServers(servers) {
        for (const [, description] of servers) {
            this.manager.addOrUpdateServer(description);
        }
        for (const [name] of this.prevServers) {
            if (!servers.has(name)) {
                this.manager.removeServer(name);
            }
        }
    }
    convertToMap(servers) {
        const map = new Map();
        Object.entries(servers).forEach(([name, description]) => {
            map.set(name, {
                name,
                ...description,
                autostart: 'autostart' in description ? description.autostart : true,
                env: description.env || undefined
            });
        });
        return map;
    }
};
exports.McpFrontendApplicationContribution = McpFrontendApplicationContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], McpFrontendApplicationContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.MCPServerManager),
    tslib_1.__metadata("design:type", Object)
], McpFrontendApplicationContribution.prototype, "manager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(mcp_server_manager_1.MCPFrontendService),
    tslib_1.__metadata("design:type", Object)
], McpFrontendApplicationContribution.prototype, "frontendMCPService", void 0);
exports.McpFrontendApplicationContribution = McpFrontendApplicationContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], McpFrontendApplicationContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-module.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-module.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const mcp_command_contribution_1 = __webpack_require__(/*! ./mcp-command-contribution */ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-command-contribution.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const mcp_server_manager_1 = __webpack_require__(/*! ../common/mcp-server-manager */ "../../node_modules/@theia/ai-mcp/lib/common/mcp-server-manager.js");
const mcp_preferences_1 = __webpack_require__(/*! ./mcp-preferences */ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-preferences.js");
const mcp_frontend_application_contribution_1 = __webpack_require__(/*! ./mcp-frontend-application-contribution */ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-application-contribution.js");
const mcp_frontend_service_1 = __webpack_require__(/*! ./mcp-frontend-service */ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-service.js");
const mcp_frontend_notification_service_1 = __webpack_require__(/*! ./mcp-frontend-notification-service */ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-notification-service.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: mcp_preferences_1.McpServersPreferenceSchema });
    bind(browser_1.FrontendApplicationContribution).to(mcp_frontend_application_contribution_1.McpFrontendApplicationContribution).inSingletonScope();
    bind(core_1.CommandContribution).to(mcp_command_contribution_1.MCPCommandContribution);
    bind(mcp_server_manager_1.MCPFrontendService).to(mcp_frontend_service_1.MCPFrontendServiceImpl).inSingletonScope();
    bind(mcp_server_manager_1.MCPFrontendNotificationService).to(mcp_frontend_notification_service_1.MCPFrontendNotificationServiceImpl).inSingletonScope();
    bind(mcp_server_manager_1.MCPServerManager).toDynamicValue(ctx => {
        const connection = ctx.container.get(browser_1.RemoteConnectionProvider);
        const client = ctx.container.get(mcp_server_manager_1.MCPFrontendNotificationService);
        return connection.createProxy(mcp_server_manager_1.MCPServerManagerPath, client);
    }).inSingletonScope();
});


/***/ }),

/***/ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-notification-service.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-notification-service.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MCPFrontendNotificationServiceImpl = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "../../node_modules/@theia/core/lib/common/event.js");
let MCPFrontendNotificationServiceImpl = class MCPFrontendNotificationServiceImpl {
    constructor() {
        this.onDidUpdateMCPServersEmitter = new event_1.Emitter();
        this.onDidUpdateMCPServers = this.onDidUpdateMCPServersEmitter.event;
    }
    didUpdateMCPServers() {
        this.onDidUpdateMCPServersEmitter.fire();
    }
};
exports.MCPFrontendNotificationServiceImpl = MCPFrontendNotificationServiceImpl;
exports.MCPFrontendNotificationServiceImpl = MCPFrontendNotificationServiceImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], MCPFrontendNotificationServiceImpl);


/***/ }),

/***/ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-service.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-mcp/lib/browser/mcp-frontend-service.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MCPFrontendServiceImpl = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const mcp_server_manager_1 = __webpack_require__(/*! ../common/mcp-server-manager */ "../../node_modules/@theia/ai-mcp/lib/common/mcp-server-manager.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
let MCPFrontendServiceImpl = class MCPFrontendServiceImpl {
    async startServer(serverName) {
        await this.mcpServerManager.startServer(serverName);
        await this.registerTools(serverName);
    }
    async registerToolsForAllStartedServers() {
        const startedServers = await this.getStartedServers();
        for (const serverName of startedServers) {
            await this.registerTools(serverName);
        }
    }
    async registerTools(serverName) {
        const returnedTools = await this.getTools(serverName);
        if (returnedTools) {
            const toolRequests = returnedTools.tools.map(tool => this.convertToToolRequest(tool, serverName));
            toolRequests.forEach(toolRequest => this.toolInvocationRegistry.registerTool(toolRequest));
            this.createPromptTemplate(serverName, toolRequests);
        }
    }
    getPromptTemplateId(serverName) {
        return `mcp_${serverName}_tools`;
    }
    createPromptTemplate(serverName, toolRequests) {
        const templateId = this.getPromptTemplateId(serverName);
        const functionIds = toolRequests.map(tool => `~{${tool.id}}`);
        const template = functionIds.join('\n');
        this.promptService.storePromptTemplate({
            id: templateId,
            template
        });
    }
    async stopServer(serverName) {
        this.toolInvocationRegistry.unregisterAllTools(`mcp_${serverName}`);
        this.promptService.removePrompt(this.getPromptTemplateId(serverName));
        await this.mcpServerManager.stopServer(serverName);
    }
    getStartedServers() {
        return this.mcpServerManager.getRunningServers();
    }
    getServerNames() {
        return this.mcpServerManager.getServerNames();
    }
    async getServerDescription(name) {
        return this.mcpServerManager.getServerDescription(name);
    }
    async getTools(serverName) {
        try {
            return await this.mcpServerManager.getTools(serverName);
        }
        catch (error) {
            console.error('Error while trying to get tools: ' + error);
            return undefined;
        }
    }
    convertToToolRequest(tool, serverName) {
        const id = `mcp_${serverName}_${tool.name}`;
        return {
            id: id,
            name: id,
            providerName: `mcp_${serverName}`,
            parameters: ai_core_1.ToolRequest.isToolRequestParameters(tool.inputSchema) ? {
                type: tool.inputSchema.type,
                properties: tool.inputSchema.properties,
                required: tool.inputSchema.required
            } : {
                type: 'object',
                properties: {}
            },
            description: tool.description,
            handler: async (arg_string) => {
                try {
                    return await this.mcpServerManager.callTool(serverName, tool.name, arg_string);
                }
                catch (error) {
                    console.error(`Error in tool handler for ${tool.name} on MCP server ${serverName}:`, error);
                    throw error;
                }
            },
        };
    }
};
exports.MCPFrontendServiceImpl = MCPFrontendServiceImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(mcp_server_manager_1.MCPServerManager),
    tslib_1.__metadata("design:type", Object)
], MCPFrontendServiceImpl.prototype, "mcpServerManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.ToolInvocationRegistry),
    tslib_1.__metadata("design:type", Object)
], MCPFrontendServiceImpl.prototype, "toolInvocationRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.PromptService),
    tslib_1.__metadata("design:type", Object)
], MCPFrontendServiceImpl.prototype, "promptService", void 0);
exports.MCPFrontendServiceImpl = MCPFrontendServiceImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], MCPFrontendServiceImpl);


/***/ }),

/***/ "../../node_modules/@theia/ai-mcp/lib/browser/mcp-preferences.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/ai-mcp/lib/browser/mcp-preferences.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.McpServersPreferenceSchema = exports.MCP_SERVERS_PREF = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.MCP_SERVERS_PREF = 'ai-features.mcp.mcpServers';
exports.McpServersPreferenceSchema = {
    type: 'object',
    properties: {
        [exports.MCP_SERVERS_PREF]: {
            type: 'object',
            title: core_1.nls.localize('theia/ai/mcp/servers/title', 'MCP Servers Configuration'),
            markdownDescription: core_1.nls.localize('theia/ai/mcp/servers/mdDescription', 'Configure MCP servers with command, arguments, optionally environment variables, and autostart \
(true by default). Each server is identified by a unique key, such as "brave-search" or "filesystem". \
To start a server, use the "MCP: Start MCP Server" command, which enables you to select the desired server. \
To stop a server, use the "MCP: Stop MCP Server" command. \
Please note that autostart will only take effect after a restart, you need to start a server manually for the first time.\
\n\
Example configuration:\n\
```\
{\n\
  "brave-search": {\n\
    "command": "npx",\n\
    "args": [\n\
      "-y",\n\
      "@modelcontextprotocol/server-brave-search"\n\
    ],\n\
    "env": {\n\
      "BRAVE_API_KEY": "YOUR_API_KEY"\n\
    },\n\
  },\n\
  "filesystem": {\n\
    "command": "npx",\n\
    "args": ["-y", "@modelcontextprotocol/server-filesystem", "/Users/YOUR_USERNAME/Desktop"],\n\
    "env": {\n\
      "CUSTOM_ENV_VAR": "custom-value"\n\
    },\n\
    "autostart": false\n\
  }\n\
}\n```'),
            additionalProperties: {
                type: 'object',
                properties: {
                    command: {
                        type: 'string',
                        title: core_1.nls.localize('theia/ai/mcp/servers/command/title', 'Command to execute the MCP server'),
                        markdownDescription: core_1.nls.localize('theia/ai/mcp/servers/command/mdDescription', 'The command used to start the MCP server, e.g., "uvx" or "npx".')
                    },
                    args: {
                        type: 'array',
                        title: core_1.nls.localize('theia/ai/mcp/servers/args/title', 'Arguments for the command'),
                        markdownDescription: core_1.nls.localize('theia/ai/mcp/servers/args/mdDescription', 'An array of arguments to pass to the command.'),
                    },
                    env: {
                        type: 'object',
                        title: core_1.nls.localize('theia/ai/mcp/servers/env/title', 'Environment variables'),
                        markdownDescription: core_1.nls.localize('theia/ai/mcp/servers/env/mdDescription', 'Optional environment variables to set for the server, such as an API key.'),
                        additionalProperties: {
                            type: 'string'
                        }
                    },
                    autostart: {
                        type: 'boolean',
                        title: core_1.nls.localize('theia/ai/mcp/servers/autostart/title', 'Autostart'),
                        markdownDescription: core_1.nls.localize('theia/ai/mcp/servers/autostart/mdDescription', 'Automatically start this server when the frontend starts. Newly added servers are not immediately auto started, but on restart'),
                        default: true
                    }
                },
                required: ['command', 'args']
            }
        }
    }
};


/***/ }),

/***/ "../../node_modules/@theia/ai-mcp/lib/common/index.js":
/*!************************************************************!*\
  !*** ../../node_modules/@theia/ai-mcp/lib/common/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
tslib_1.__exportStar(__webpack_require__(/*! ./mcp-server-manager */ "../../node_modules/@theia/ai-mcp/lib/common/mcp-server-manager.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/ai-mcp/lib/common/mcp-server-manager.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/ai-mcp/lib/common/mcp-server-manager.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MCPServerManagerPath = exports.MCPServerManager = exports.MCPServerStatus = exports.MCPFrontendNotificationService = exports.MCPFrontendService = void 0;
exports.MCPFrontendService = Symbol('MCPFrontendService');
exports.MCPFrontendNotificationService = Symbol('MCPFrontendNotificationService');
var MCPServerStatus;
(function (MCPServerStatus) {
    MCPServerStatus["NotRunning"] = "Not Running";
    MCPServerStatus["Starting"] = "Starting";
    MCPServerStatus["Running"] = "Running";
    MCPServerStatus["Errored"] = "Errored";
})(MCPServerStatus || (exports.MCPServerStatus = MCPServerStatus = {}));
exports.MCPServerManager = Symbol('MCPServerManager');
exports.MCPServerManagerPath = '/services/mcpservermanager';


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-mcp_lib_browser_mcp-frontend-module_js.js.map