(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_search-in-workspace_lib_browser_search-in-workspace-factory_js"],{

/***/ "../../node_modules/@theia/search-in-workspace/lib/browser/components/search-in-workspace-input.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/browser/components/search-in-workspace-input.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchInWorkspaceInput = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "../../node_modules/@theia/core/shared/lodash.debounce/index.js");
;
class SearchInWorkspaceInput extends React.Component {
    constructor(props) {
        super(props);
        this.input = React.createRef();
        /**
         * Handle history navigation without overriding the parent's onKeyDown handler, if any.
         */
        this.onKeyDown = (e) => {
            var _a, _b, _c, _d;
            if (browser_1.Key.ARROW_UP.keyCode === ((_a = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode)) {
                e.preventDefault();
                this.previousValue();
            }
            else if (browser_1.Key.ARROW_DOWN.keyCode === ((_b = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _b === void 0 ? void 0 : _b.keyCode)) {
                e.preventDefault();
                this.nextValue();
            }
            (_d = (_c = this.props).onKeyDown) === null || _d === void 0 ? void 0 : _d.call(_c, e);
        };
        /**
         * Handle history collection without overriding the parent's onChange handler, if any.
         */
        this.onChange = (e) => {
            var _a, _b;
            this.addToHistory();
            (_b = (_a = this.props).onChange) === null || _b === void 0 ? void 0 : _b.call(_a, e);
        };
        /**
         * Add a nonempty current value to the history, if not already present. (Debounced, 1 second delay.)
         */
        this.addToHistory = debounce(this.doAddToHistory, 1000);
        this.state = {
            history: [],
            index: 0,
        };
    }
    updateState(index, history) {
        this.value = history ? history[index] : this.state.history[index];
        this.setState(prevState => {
            const newState = {
                ...prevState,
                index,
            };
            if (history) {
                newState.history = history;
            }
            return newState;
        });
    }
    get value() {
        var _a, _b;
        return (_b = (_a = this.input.current) === null || _a === void 0 ? void 0 : _a.value) !== null && _b !== void 0 ? _b : '';
    }
    set value(value) {
        if (this.input.current) {
            this.input.current.value = value;
        }
    }
    /**
     * Switch the input's text to the previous value, if any.
     */
    previousValue() {
        const { history, index } = this.state;
        if (!this.value) {
            this.value = history[index];
        }
        else if (index > 0 && index < history.length) {
            this.updateState(index - 1);
        }
    }
    /**
     * Switch the input's text to the next value, if any.
     */
    nextValue() {
        const { history, index } = this.state;
        if (index === history.length - 1) {
            this.value = '';
        }
        else if (!this.value) {
            this.value = history[index];
        }
        else if (index >= 0 && index < history.length - 1) {
            this.updateState(index + 1);
        }
    }
    doAddToHistory() {
        if (!this.value) {
            return;
        }
        const history = this.state.history
            .filter(term => term !== this.value)
            .concat(this.value)
            .slice(-SearchInWorkspaceInput.LIMIT);
        this.updateState(history.length - 1, history);
    }
    render() {
        return (React.createElement("input", { ...this.props, onKeyDown: this.onKeyDown, onChange: this.onChange, spellCheck: false, ref: this.input }));
    }
}
exports.SearchInWorkspaceInput = SearchInWorkspaceInput;
SearchInWorkspaceInput.LIMIT = 100;


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/lib/browser/components/search-in-workspace-textarea.js":
/*!************************************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/browser/components/search-in-workspace-textarea.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchInWorkspaceTextArea = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const react_textarea_autosize_1 = __webpack_require__(/*! react-textarea-autosize */ "../../node_modules/react-textarea-autosize/dist/react-textarea-autosize.browser.development.esm.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "../../node_modules/@theia/core/shared/lodash.debounce/index.js");
;
class SearchInWorkspaceTextArea extends React.Component {
    constructor(props) {
        super(props);
        this.textarea = React.createRef();
        /**
         * Handle history navigation without overriding the parent's onKeyDown handler, if any.
         */
        this.onKeyDown = (e) => {
            var _a, _b, _c, _d, _e;
            // Navigate history only when cursor is at first or last position of the textarea
            if (browser_1.Key.ARROW_UP.keyCode === ((_a = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode) && e.currentTarget.selectionStart === 0) {
                e.preventDefault();
                this.previousValue();
            }
            else if (browser_1.Key.ARROW_DOWN.keyCode === ((_b = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _b === void 0 ? void 0 : _b.keyCode) && e.currentTarget.selectionEnd === e.currentTarget.value.length) {
                e.preventDefault();
                this.nextValue();
            }
            // Prevent newline on enter
            if (browser_1.Key.ENTER.keyCode === ((_c = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _c === void 0 ? void 0 : _c.keyCode) && !e.nativeEvent.shiftKey) {
                e.preventDefault();
            }
            (_e = (_d = this.props).onKeyDown) === null || _e === void 0 ? void 0 : _e.call(_d, e);
        };
        /**
         * Handle history collection and textarea resizing without overriding the parent's onChange handler, if any.
         */
        this.onChange = (e) => {
            var _a, _b;
            this.addToHistory();
            (_b = (_a = this.props).onChange) === null || _b === void 0 ? void 0 : _b.call(_a, e);
        };
        /**
         * Add a nonempty current value to the history, if not already present. (Debounced, 1 second delay.)
         */
        this.addToHistory = debounce(this.doAddToHistory, 1000);
        this.state = {
            history: [],
            index: 0,
        };
    }
    updateState(index, history) {
        this.value = history ? history[index] : this.state.history[index];
        this.setState(prevState => {
            const newState = {
                ...prevState,
                index,
            };
            if (history) {
                newState.history = history;
            }
            return newState;
        });
    }
    get value() {
        var _a, _b;
        return (_b = (_a = this.textarea.current) === null || _a === void 0 ? void 0 : _a.value) !== null && _b !== void 0 ? _b : '';
    }
    set value(value) {
        if (this.textarea.current) {
            this.textarea.current.value = value;
        }
    }
    /**
     * Switch the textarea's text to the previous value, if any.
     */
    previousValue() {
        const { history, index } = this.state;
        if (!this.value) {
            this.value = history[index];
        }
        else if (index > 0 && index < history.length) {
            this.updateState(index - 1);
        }
    }
    /**
     * Switch the textarea's text to the next value, if any.
     */
    nextValue() {
        const { history, index } = this.state;
        if (index === history.length - 1) {
            this.value = '';
        }
        else if (!this.value) {
            this.value = history[index];
        }
        else if (index >= 0 && index < history.length - 1) {
            this.updateState(index + 1);
        }
    }
    doAddToHistory() {
        if (!this.value) {
            return;
        }
        const history = this.state.history
            .filter(term => term !== this.value)
            .concat(this.value)
            .slice(-SearchInWorkspaceTextArea.LIMIT);
        this.updateState(history.length - 1, history);
    }
    render() {
        const { onResize, ...filteredProps } = this.props;
        return (React.createElement(react_textarea_autosize_1.default, { ...filteredProps, autoCapitalize: "off", autoCorrect: "off", maxRows: 7, onChange: this.onChange, onKeyDown: this.onKeyDown, ref: this.textarea, rows: 1, spellCheck: false }));
    }
}
exports.SearchInWorkspaceTextArea = SearchInWorkspaceTextArea;
SearchInWorkspaceTextArea.LIMIT = 100;


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-context-key-service.js":
/*!************************************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-context-key-service.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchInWorkspaceContextKeyService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
let SearchInWorkspaceContextKeyService = class SearchInWorkspaceContextKeyService {
    get searchViewletVisible() {
        return this._searchViewletVisible;
    }
    get searchViewletFocus() {
        return this._searchViewletFocus;
    }
    setSearchInputBoxFocus(searchInputBoxFocus) {
        this.searchInputBoxFocus.set(searchInputBoxFocus);
        this.updateInputBoxFocus();
    }
    setReplaceInputBoxFocus(replaceInputBoxFocus) {
        this.replaceInputBoxFocus.set(replaceInputBoxFocus);
        this.updateInputBoxFocus();
    }
    setPatternIncludesInputBoxFocus(patternIncludesInputBoxFocus) {
        this.patternIncludesInputBoxFocus.set(patternIncludesInputBoxFocus);
        this.updateInputBoxFocus();
    }
    setPatternExcludesInputBoxFocus(patternExcludesInputBoxFocus) {
        this.patternExcludesInputBoxFocus.set(patternExcludesInputBoxFocus);
        this.updateInputBoxFocus();
    }
    updateInputBoxFocus() {
        this.inputBoxFocus.set(this.searchInputBoxFocus.get() ||
            this.replaceInputBoxFocus.get() ||
            this.patternIncludesInputBoxFocus.get() ||
            this.patternExcludesInputBoxFocus.get());
    }
    get replaceActive() {
        return this._replaceActive;
    }
    get hasSearchResult() {
        return this._hasSearchResult;
    }
    init() {
        this._searchViewletVisible = this.contextKeyService.createKey('searchViewletVisible', false);
        this._searchViewletFocus = this.contextKeyService.createKey('searchViewletFocus', false);
        this.inputBoxFocus = this.contextKeyService.createKey('inputBoxFocus', false);
        this.searchInputBoxFocus = this.contextKeyService.createKey('searchInputBoxFocus', false);
        this.replaceInputBoxFocus = this.contextKeyService.createKey('replaceInputBoxFocus', false);
        this.patternIncludesInputBoxFocus = this.contextKeyService.createKey('patternIncludesInputBoxFocus', false);
        this.patternExcludesInputBoxFocus = this.contextKeyService.createKey('patternExcludesInputBoxFocus', false);
        this._replaceActive = this.contextKeyService.createKey('replaceActive', false);
        this._hasSearchResult = this.contextKeyService.createKey('hasSearchResult', false);
    }
};
exports.SearchInWorkspaceContextKeyService = SearchInWorkspaceContextKeyService;
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], SearchInWorkspaceContextKeyService.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], SearchInWorkspaceContextKeyService.prototype, "init", null);
exports.SearchInWorkspaceContextKeyService = SearchInWorkspaceContextKeyService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SearchInWorkspaceContextKeyService);


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-factory.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-factory.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchInWorkspaceFactory = exports.SEARCH_VIEW_CONTAINER_TITLE_OPTIONS = exports.SEARCH_VIEW_CONTAINER_ID = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const search_in_workspace_widget_1 = __webpack_require__(/*! ./search-in-workspace-widget */ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-widget.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
exports.SEARCH_VIEW_CONTAINER_ID = 'search-view-container';
exports.SEARCH_VIEW_CONTAINER_TITLE_OPTIONS = {
    label: nls_1.nls.localizeByDefault('Search'),
    iconClass: (0, browser_1.codicon)('search'),
    closeable: true
};
let SearchInWorkspaceFactory = class SearchInWorkspaceFactory {
    constructor() {
        this.id = exports.SEARCH_VIEW_CONTAINER_ID;
        this.searchWidgetOptions = {
            canHide: false,
            initiallyCollapsed: false
        };
    }
    async createWidget() {
        const viewContainer = this.viewContainerFactory({
            id: exports.SEARCH_VIEW_CONTAINER_ID,
            progressLocationId: 'search'
        });
        viewContainer.setTitleOptions(exports.SEARCH_VIEW_CONTAINER_TITLE_OPTIONS);
        const widget = await this.widgetManager.getOrCreateWidget(search_in_workspace_widget_1.SearchInWorkspaceWidget.ID);
        viewContainer.addWidget(widget, this.searchWidgetOptions);
        return viewContainer;
    }
};
exports.SearchInWorkspaceFactory = SearchInWorkspaceFactory;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ViewContainer.Factory),
    tslib_1.__metadata("design:type", Function)
], SearchInWorkspaceFactory.prototype, "viewContainerFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WidgetManager),
    tslib_1.__metadata("design:type", browser_1.WidgetManager)
], SearchInWorkspaceFactory.prototype, "widgetManager", void 0);
exports.SearchInWorkspaceFactory = SearchInWorkspaceFactory = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SearchInWorkspaceFactory);


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-preferences.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-preferences.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindSearchInWorkspacePreferences = exports.createSearchInWorkspacePreferences = exports.SearchInWorkspacePreferences = exports.SearchInWorkspacePreferenceContribution = exports.SearchInWorkspaceConfiguration = exports.searchInWorkspacePreferencesSchema = void 0;
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const preferences_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences */ "../../node_modules/@theia/core/lib/browser/preferences/index.js");
exports.searchInWorkspacePreferencesSchema = {
    type: 'object',
    properties: {
        'search.lineNumbers': {
            description: nls_1.nls.localizeByDefault('Controls whether to show line numbers for search results.'),
            default: false,
            type: 'boolean',
        },
        'search.collapseResults': {
            description: nls_1.nls.localizeByDefault('Controls whether the search results will be collapsed or expanded.'),
            default: 'auto',
            type: 'string',
            enum: ['auto', 'alwaysCollapse', 'alwaysExpand'],
        },
        'search.quickOpen.includeHistory': {
            description: nls_1.nls.localizeByDefault('Whether to include results from recently opened files in the file results for Quick Open.'),
            default: true,
            type: 'boolean',
        },
        'search.searchOnType': {
            description: nls_1.nls.localizeByDefault('Search all files as you type.'),
            default: true,
            type: 'boolean',
        },
        'search.searchOnTypeDebouncePeriod': {
            // eslint-disable-next-line max-len
            markdownDescription: nls_1.nls.localizeByDefault('When {0} is enabled, controls the timeout in milliseconds between a character being typed and the search starting. Has no effect when {0} is disabled.', '`#search.searchOnType#`'),
            default: 300,
            type: 'number',
        },
        'search.searchOnEditorModification': {
            description: nls_1.nls.localize('theia/search-in-workspace/searchOnEditorModification', 'Search the active editor when modified.'),
            default: true,
            type: 'boolean',
        },
        'search.smartCase': {
            // eslint-disable-next-line max-len
            description: nls_1.nls.localizeByDefault('Search case-insensitively if the pattern is all lowercase, otherwise, search case-sensitively.'),
            default: false,
            type: 'boolean',
        },
        'search.followSymlinks': {
            description: nls_1.nls.localizeByDefault('Controls whether to follow symlinks while searching.'),
            default: true,
            type: 'boolean',
        }
    }
};
class SearchInWorkspaceConfiguration {
}
exports.SearchInWorkspaceConfiguration = SearchInWorkspaceConfiguration;
exports.SearchInWorkspacePreferenceContribution = Symbol('SearchInWorkspacePreferenceContribution');
exports.SearchInWorkspacePreferences = Symbol('SearchInWorkspacePreferences');
function createSearchInWorkspacePreferences(preferences, schema = exports.searchInWorkspacePreferencesSchema) {
    return (0, preferences_1.createPreferenceProxy)(preferences, schema);
}
exports.createSearchInWorkspacePreferences = createSearchInWorkspacePreferences;
function bindSearchInWorkspacePreferences(bind) {
    bind(exports.SearchInWorkspacePreferences).toDynamicValue(ctx => {
        const preferences = ctx.container.get(preferences_1.PreferenceService);
        const contribution = ctx.container.get(exports.SearchInWorkspacePreferenceContribution);
        return createSearchInWorkspacePreferences(preferences, contribution.schema);
    }).inSingletonScope();
    bind(exports.SearchInWorkspacePreferenceContribution).toConstantValue({ schema: exports.searchInWorkspacePreferencesSchema });
    bind(preferences_1.PreferenceContribution).toService(exports.SearchInWorkspacePreferenceContribution);
}
exports.bindSearchInWorkspacePreferences = bindSearchInWorkspacePreferences;


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-result-tree-widget.js":
/*!***********************************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-result-tree-widget.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchInWorkspaceResultTreeWidget = exports.SearchInWorkspaceResultLineNode = exports.SearchInWorkspaceFileNode = exports.SearchInWorkspaceRootFolderNode = exports.SearchInWorkspaceRoot = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const browser_3 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const browser_4 = __webpack_require__(/*! @theia/filesystem/lib/browser */ "../../node_modules/@theia/filesystem/lib/browser/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const search_in_workspace_service_1 = __webpack_require__(/*! ./search-in-workspace-service */ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-service.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const search_in_workspace_preferences_1 = __webpack_require__(/*! ./search-in-workspace-preferences */ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-preferences.js");
const color_registry_1 = __webpack_require__(/*! @theia/core/lib/browser/color-registry */ "../../node_modules/@theia/core/lib/browser/color-registry.js");
const minimatch = __webpack_require__(/*! minimatch */ "../../node_modules/@theia/search-in-workspace/node_modules/minimatch/minimatch.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "../../node_modules/@theia/core/shared/lodash.debounce/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const ROOT_ID = 'ResultTree';
var SearchInWorkspaceRoot;
(function (SearchInWorkspaceRoot) {
    function is(node) {
        return browser_1.CompositeTreeNode.is(node) && node.id === ROOT_ID;
    }
    SearchInWorkspaceRoot.is = is;
})(SearchInWorkspaceRoot || (exports.SearchInWorkspaceRoot = SearchInWorkspaceRoot = {}));
var SearchInWorkspaceRootFolderNode;
(function (SearchInWorkspaceRootFolderNode) {
    function is(node) {
        return browser_1.ExpandableTreeNode.is(node) && browser_1.SelectableTreeNode.is(node) && 'path' in node && 'folderUri' in node && !('fileUri' in node);
    }
    SearchInWorkspaceRootFolderNode.is = is;
})(SearchInWorkspaceRootFolderNode || (exports.SearchInWorkspaceRootFolderNode = SearchInWorkspaceRootFolderNode = {}));
var SearchInWorkspaceFileNode;
(function (SearchInWorkspaceFileNode) {
    function is(node) {
        return browser_1.ExpandableTreeNode.is(node) && browser_1.SelectableTreeNode.is(node) && 'path' in node && 'fileUri' in node && !('folderUri' in node);
    }
    SearchInWorkspaceFileNode.is = is;
})(SearchInWorkspaceFileNode || (exports.SearchInWorkspaceFileNode = SearchInWorkspaceFileNode = {}));
var SearchInWorkspaceResultLineNode;
(function (SearchInWorkspaceResultLineNode) {
    function is(node) {
        return browser_1.SelectableTreeNode.is(node) && 'line' in node && 'character' in node && 'lineText' in node;
    }
    SearchInWorkspaceResultLineNode.is = is;
})(SearchInWorkspaceResultLineNode || (exports.SearchInWorkspaceResultLineNode = SearchInWorkspaceResultLineNode = {}));
let SearchInWorkspaceResultTreeWidget = class SearchInWorkspaceResultTreeWidget extends browser_1.TreeWidget {
    constructor(props, model, contextMenuRenderer) {
        super(props, model, contextMenuRenderer);
        this._showReplaceButtons = false;
        this._replaceTerm = '';
        this.searchTerm = '';
        this.startSearchOnModification = (activeEditor) => debounce(() => this.searchActiveEditor(activeEditor, this.searchTerm, this.searchOptions), this.searchOnEditorModificationDelay);
        this.searchOnEditorModificationDelay = 300;
        this.toDisposeOnActiveEditorChanged = new disposable_1.DisposableCollection();
        // The default root name to add external search results in the case that a workspace is opened.
        this.defaultRootName = nls_1.nls.localizeByDefault('Other files');
        this.forceVisibleRootNode = false;
        this.appliedDecorations = new Map();
        this.changeEmitter = new core_1.Emitter();
        this.onExpansionChangedEmitter = new core_1.Emitter();
        this.onExpansionChanged = this.onExpansionChangedEmitter.event;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        this.focusInputEmitter = new core_1.Emitter();
        this.remove = (node, e) => this.doRemove(node, e);
        model.root = {
            id: ROOT_ID,
            parent: undefined,
            visible: false,
            children: []
        };
        this.toDispose.push(model.onSelectionChanged(nodes => {
            const node = nodes[0];
            if (SearchInWorkspaceResultLineNode.is(node)) {
                this.doOpen(node, true, true);
            }
        }));
        this.toDispose.push(model.onOpenNode(node => {
            if (SearchInWorkspaceResultLineNode.is(node)) {
                this.doOpen(node, true, false);
            }
        }));
        this.resultTree = new Map();
        this.toDispose.push(model.onNodeRefreshed(() => this.changeEmitter.fire(this.resultTree)));
    }
    init() {
        super.init();
        this.addClass('resultContainer');
        this.toDispose.push(this.changeEmitter);
        this.toDispose.push(this.focusInputEmitter);
        this.toDispose.push(this.editorManager.onActiveEditorChanged(activeEditor => {
            this.updateCurrentEditorDecorations();
            this.toDisposeOnActiveEditorChanged.dispose();
            this.toDispose.push(this.toDisposeOnActiveEditorChanged);
            if (activeEditor) {
                this.toDisposeOnActiveEditorChanged.push(activeEditor.editor.onDocumentContentChanged(() => {
                    if (this.searchTerm !== '' && this.searchInWorkspacePreferences['search.searchOnEditorModification']) {
                        this.startSearchOnModification(activeEditor)();
                    }
                }));
            }
        }));
        this.toDispose.push(this.searchInWorkspacePreferences.onPreferenceChanged(() => {
            this.update();
        }));
        this.toDispose.push(this.fileService.onDidFilesChange(event => {
            if (event.gotDeleted()) {
                event.getDeleted().forEach(deletedFile => {
                    const fileNodes = this.getFileNodesByUri(deletedFile.resource);
                    fileNodes.forEach(node => this.removeFileNode(node));
                });
                this.model.refresh();
            }
        }));
        this.toDispose.push(this.model.onExpansionChanged(() => {
            this.onExpansionChangedEmitter.fire(undefined);
        }));
    }
    get fileNumber() {
        let num = 0;
        for (const rootFolderNode of this.resultTree.values()) {
            num += rootFolderNode.children.length;
        }
        return num;
    }
    set showReplaceButtons(srb) {
        this._showReplaceButtons = srb;
        this.update();
    }
    set replaceTerm(rt) {
        this._replaceTerm = rt;
        this.update();
    }
    get isReplacing() {
        return this._replaceTerm !== '' && this._showReplaceButtons;
    }
    get onChange() {
        return this.changeEmitter.event;
    }
    get onFocusInput() {
        return this.focusInputEmitter.event;
    }
    collapseAll() {
        for (const rootFolderNode of this.resultTree.values()) {
            for (const fileNode of rootFolderNode.children) {
                this.expansionService.collapseNode(fileNode);
            }
            if (rootFolderNode.visible) {
                this.expansionService.collapseNode(rootFolderNode);
            }
        }
    }
    expandAll() {
        for (const rootFolderNode of this.resultTree.values()) {
            for (const fileNode of rootFolderNode.children) {
                this.expansionService.expandNode(fileNode);
            }
            if (rootFolderNode.visible) {
                this.expansionService.expandNode(rootFolderNode);
            }
        }
    }
    areResultsCollapsed() {
        for (const rootFolderNode of this.resultTree.values()) {
            for (const fileNode of rootFolderNode.children) {
                if (!browser_1.ExpandableTreeNode.isCollapsed(fileNode)) {
                    return false;
                }
            }
        }
        return true;
    }
    selectNextResult() {
        if (!this.model.getFocusedNode()) {
            return this.selectFirstResult();
        }
        let foundNextResult = false;
        while (!foundNextResult) {
            const nextNode = this.model.getNextNode();
            if (!nextNode) {
                return this.selectFirstResult();
            }
            else if (SearchInWorkspaceResultLineNode.is(nextNode)) {
                foundNextResult = true;
                this.selectExpandOpenResultNode(nextNode);
            }
            else {
                this.model.selectNext();
            }
        }
    }
    selectPreviousResult() {
        if (!this.model.getFocusedNode()) {
            return this.selectLastResult();
        }
        let foundSelectedNode = false;
        while (!foundSelectedNode) {
            const prevNode = this.model.getPrevNode();
            if (!prevNode) {
                return this.selectLastResult();
            }
            else if (SearchInWorkspaceResultLineNode.is(prevNode)) {
                foundSelectedNode = true;
                this.selectExpandOpenResultNode(prevNode);
            }
            else if (prevNode.id === 'ResultTree') {
                return this.selectLastResult();
            }
            else {
                this.model.selectPrev();
            }
        }
    }
    selectExpandOpenResultNode(node) {
        this.model.expandNode(node.parent.parent);
        this.model.expandNode(node.parent);
        this.model.selectNode(node);
        this.model.openNode(node);
    }
    selectFirstResult() {
        for (const rootFolder of this.resultTree.values()) {
            for (const file of rootFolder.children) {
                for (const result of file.children) {
                    if (browser_1.SelectableTreeNode.is(result)) {
                        return this.selectExpandOpenResultNode(result);
                    }
                }
            }
        }
    }
    selectLastResult() {
        const rootFolders = Array.from(this.resultTree.values());
        for (let i = rootFolders.length - 1; i >= 0; i--) {
            const rootFolder = rootFolders[i];
            for (let j = rootFolder.children.length - 1; j >= 0; j--) {
                const file = rootFolder.children[j];
                for (let k = file.children.length - 1; k >= 0; k--) {
                    const result = file.children[k];
                    if (browser_1.SelectableTreeNode.is(result)) {
                        return this.selectExpandOpenResultNode(result);
                    }
                }
            }
        }
    }
    /**
     * Find matches for the given editor.
     * @param searchTerm the search term.
     * @param widget the editor widget.
     * @param searchOptions the search options to apply.
     *
     * @returns the list of matches.
     */
    findMatches(searchTerm, widget, searchOptions) {
        if (!widget.editor.document.findMatches) {
            return [];
        }
        const results = widget.editor.document.findMatches({
            searchString: searchTerm,
            isRegex: !!searchOptions.useRegExp,
            matchCase: !!searchOptions.matchCase,
            matchWholeWord: !!searchOptions.matchWholeWord,
            limitResultCount: searchOptions.maxResults
        });
        const matches = [];
        results.forEach(r => {
            const numberOfLines = searchTerm.split('\n').length;
            const lineTexts = [];
            for (let i = 0; i < numberOfLines; i++) {
                lineTexts.push(widget.editor.document.getLineContent(r.range.start.line + i));
            }
            matches.push({
                line: r.range.start.line,
                character: r.range.start.character,
                length: searchTerm.length,
                lineText: lineTexts.join('\n')
            });
        });
        return matches;
    }
    /**
     * Convert a pattern to match all directories.
     * @param workspaceRootUri the uri of the current workspace root.
     * @param pattern the pattern to be converted.
     */
    convertPatternToGlob(workspaceRootUri, pattern) {
        if (pattern.startsWith('**/')) {
            return pattern;
        }
        if (pattern.startsWith('./')) {
            if (workspaceRootUri === undefined) {
                return pattern;
            }
            return workspaceRootUri.toString() + pattern.replace('./', '/');
        }
        return pattern.startsWith('/')
            ? '**' + pattern
            : '**/' + pattern;
    }
    /**
     * Determine if the URI matches any of the patterns.
     * @param uri the editor URI.
     * @param patterns the glob patterns to verify.
     */
    inPatternList(uri, patterns) {
        const opts = { dot: true, matchBase: true };
        return patterns.some(pattern => minimatch(uri.toString(), this.convertPatternToGlob(this.workspaceService.getWorkspaceRootUri(uri), pattern), opts));
    }
    /**
     * Determine if the given editor satisfies the filtering criteria.
     * An editor should be searched only if:
     * - it is not excluded through the `excludes` list.
     * - it is not explicitly present in a non-empty `includes` list.
     */
    shouldApplySearch(editorWidget, searchOptions) {
        const excludePatterns = this.getExcludeGlobs(searchOptions.exclude);
        if (this.inPatternList(editorWidget.editor.uri, excludePatterns)) {
            return false;
        }
        const includePatterns = searchOptions.include;
        if (!!(includePatterns === null || includePatterns === void 0 ? void 0 : includePatterns.length) && !this.inPatternList(editorWidget.editor.uri, includePatterns)) {
            return false;
        }
        return true;
    }
    /**
     * Search the active editor only and update the tree with those results.
     */
    searchActiveEditor(activeEditor, searchTerm, searchOptions) {
        const includesExternalResults = () => !!this.resultTree.get(this.defaultRootName);
        // Check if outside workspace results are present before searching.
        const hasExternalResultsBefore = includesExternalResults();
        // Collect search results for the given editor.
        const results = this.searchInEditor(activeEditor, searchTerm, searchOptions);
        // Update the tree by removing the result node, and add new results if applicable.
        this.getFileNodesByUri(activeEditor.editor.uri).forEach(fileNode => this.removeFileNode(fileNode));
        if (results) {
            this.appendToResultTree(results);
        }
        // Check if outside workspace results are present after searching.
        const hasExternalResultsAfter = includesExternalResults();
        // Redo a search to update the tree node visibility if:
        // + `Other files` node was present, now it is not.
        // + `Other files` node was not present, now it is.
        if (hasExternalResultsBefore ? !hasExternalResultsAfter : hasExternalResultsAfter) {
            this.search(this.searchTerm, this.searchOptions);
            return;
        }
        this.handleSearchCompleted();
    }
    /**
     * Perform a search in all open editors.
     * @param searchTerm the search term.
     * @param searchOptions the search options to apply.
     *
     * @returns the tuple of result count, and the list of search results.
     */
    searchInOpenEditors(searchTerm, searchOptions) {
        // Track the number of results found.
        let numberOfResults = 0;
        const searchResults = [];
        this.editorManager.all.forEach(e => {
            const editorResults = this.searchInEditor(e, searchTerm, searchOptions);
            if (editorResults) {
                numberOfResults += editorResults.matches.length;
                searchResults.push(editorResults);
            }
        });
        return {
            numberOfResults,
            matches: searchResults
        };
    }
    /**
     * Perform a search in the target editor.
     * @param editorWidget the editor widget.
     * @param searchTerm the search term.
     * @param searchOptions the search options to apply.
     *
     * @returns the search results from the given editor, undefined if the editor is either filtered or has no matches found.
     */
    searchInEditor(editorWidget, searchTerm, searchOptions) {
        var _a;
        if (!this.shouldApplySearch(editorWidget, searchOptions)) {
            return undefined;
        }
        const matches = this.findMatches(searchTerm, editorWidget, searchOptions);
        if (matches.length <= 0) {
            return undefined;
        }
        const fileUri = editorWidget.editor.uri.toString();
        const root = (_a = this.workspaceService.getWorkspaceRootUri(editorWidget.editor.uri)) === null || _a === void 0 ? void 0 : _a.toString();
        return {
            root: root !== null && root !== void 0 ? root : this.defaultRootName,
            fileUri,
            matches
        };
    }
    /**
     * Append search results to the result tree.
     * @param result Search result.
     */
    appendToResultTree(result) {
        const collapseValue = this.searchInWorkspacePreferences['search.collapseResults'];
        let path;
        if (result.root === this.defaultRootName) {
            path = new uri_1.default(result.fileUri).path.dir.fsPath();
        }
        else {
            path = this.filenameAndPath(result.root, result.fileUri).path;
        }
        const tree = this.resultTree;
        let rootFolderNode = tree.get(result.root);
        if (!rootFolderNode) {
            rootFolderNode = this.createRootFolderNode(result.root);
            tree.set(result.root, rootFolderNode);
        }
        let fileNode = rootFolderNode.children.find(f => f.fileUri === result.fileUri);
        if (!fileNode) {
            fileNode = this.createFileNode(result.root, path, result.fileUri, rootFolderNode);
            rootFolderNode.children.push(fileNode);
        }
        for (const match of result.matches) {
            const line = this.createResultLineNode(result, match, fileNode);
            if (fileNode.children.findIndex(lineNode => lineNode.id === line.id) < 0) {
                fileNode.children.push(line);
            }
        }
        this.collapseFileNode(fileNode, collapseValue);
    }
    /**
     * Handle when searching completed.
     */
    handleSearchCompleted(cancelIndicator) {
        if (cancelIndicator) {
            cancelIndicator.cancel();
        }
        this.sortResultTree();
        this.refreshModelChildren();
    }
    /**
     * Sort the result tree by URIs.
     */
    sortResultTree() {
        // Sort the result map by folder URI.
        const entries = [...this.resultTree.entries()];
        entries.sort(([, a], [, b]) => this.compare(a.folderUri, b.folderUri));
        this.resultTree = new Map(entries);
        // Update the list of children nodes, sorting them by their file URI.
        entries.forEach(([, folder]) => {
            folder.children.sort((a, b) => this.compare(a.fileUri, b.fileUri));
        });
    }
    /**
     * Search and populate the result tree with matches.
     * @param searchTerm the search term.
     * @param searchOptions the search options to apply.
     */
    async search(searchTerm, searchOptions) {
        this.searchTerm = searchTerm;
        this.searchOptions = searchOptions;
        searchOptions = {
            ...searchOptions,
            exclude: this.getExcludeGlobs(searchOptions.exclude)
        };
        this.resultTree.clear();
        this.forceVisibleRootNode = false;
        if (this.cancelIndicator) {
            this.cancelIndicator.cancel();
        }
        if (searchTerm === '') {
            this.refreshModelChildren();
            return;
        }
        this.cancelIndicator = new core_1.CancellationTokenSource();
        const cancelIndicator = this.cancelIndicator;
        const token = this.cancelIndicator.token;
        const progress = await this.progressService.showProgress({ text: `search: ${searchTerm}`, options: { location: 'search' } });
        token.onCancellationRequested(() => {
            progress.cancel();
            if (searchId) {
                this.searchService.cancel(searchId);
            }
            this.cancelIndicator = undefined;
            this.changeEmitter.fire(this.resultTree);
        });
        // Collect search results for opened editors which otherwise may not be found by ripgrep (ex: dirty editors).
        const { numberOfResults, matches } = this.searchInOpenEditors(searchTerm, searchOptions);
        // The root node is visible if outside workspace results are found and workspace root(s) are present.
        this.forceVisibleRootNode = matches.some(m => m.root === this.defaultRootName) && this.workspaceService.opened;
        matches.forEach(m => this.appendToResultTree(m));
        // Exclude files already covered by searching open editors.
        this.editorManager.all.forEach(e => {
            const excludePath = e.editor.uri.path.toString();
            searchOptions.exclude = searchOptions.exclude ? searchOptions.exclude.concat(excludePath) : [excludePath];
        });
        // Reduce `maxResults` due to editor results.
        if (searchOptions.maxResults) {
            searchOptions.maxResults -= numberOfResults;
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let pendingRefreshTimeout;
        const searchId = await this.searchService.search(searchTerm, {
            onResult: (aSearchId, result) => {
                if (token.isCancellationRequested || aSearchId !== searchId) {
                    return;
                }
                this.appendToResultTree(result);
                if (pendingRefreshTimeout) {
                    clearTimeout(pendingRefreshTimeout);
                }
                pendingRefreshTimeout = setTimeout(() => this.refreshModelChildren(), 100);
            },
            onDone: () => {
                this.handleSearchCompleted(cancelIndicator);
            }
        }, searchOptions).catch(() => {
            this.handleSearchCompleted(cancelIndicator);
        });
    }
    focusFirstResult() {
        if (SearchInWorkspaceRoot.is(this.model.root) && this.model.root.children.length > 0) {
            const node = this.model.root.children[0];
            if (browser_1.SelectableTreeNode.is(node)) {
                this.node.focus();
                this.model.selectNode(node);
            }
        }
    }
    /**
     * Collapse the search-in-workspace file node
     * based on the preference value.
     */
    collapseFileNode(node, preferenceValue) {
        if (preferenceValue === 'auto' && node.children.length >= 10) {
            node.expanded = false;
        }
        else if (preferenceValue === 'alwaysCollapse') {
            node.expanded = false;
        }
        else if (preferenceValue === 'alwaysExpand') {
            node.expanded = true;
        }
    }
    handleUp(event) {
        if (!this.model.getPrevSelectableNode(this.model.getFocusedNode())) {
            this.focusInputEmitter.fire(true);
        }
        else {
            super.handleUp(event);
        }
    }
    async refreshModelChildren() {
        if (SearchInWorkspaceRoot.is(this.model.root)) {
            this.model.root.children = Array.from(this.resultTree.values());
            this.model.refresh();
            this.updateCurrentEditorDecorations();
        }
    }
    updateCurrentEditorDecorations() {
        this.shell.allTabBars.forEach(tb => {
            const currentTitle = tb.currentTitle;
            if (currentTitle && currentTitle.owner instanceof browser_2.EditorWidget) {
                const widget = currentTitle.owner;
                const fileNodes = this.getFileNodesByUri(widget.editor.uri);
                if (fileNodes.length > 0) {
                    fileNodes.forEach(node => {
                        this.decorateEditor(node, widget);
                    });
                }
                else {
                    this.decorateEditor(undefined, widget);
                }
            }
        });
        const currentWidget = this.editorManager.currentEditor;
        if (currentWidget) {
            const fileNodes = this.getFileNodesByUri(currentWidget.editor.uri);
            fileNodes.forEach(node => {
                this.decorateEditor(node, currentWidget);
            });
        }
    }
    createRootFolderNode(rootUri) {
        const uri = new uri_1.default(rootUri);
        return {
            selected: false,
            path: uri.path.fsPath(),
            folderUri: rootUri,
            uri: new uri_1.default(rootUri),
            children: [],
            expanded: true,
            id: rootUri,
            parent: this.model.root,
            visible: this.forceVisibleRootNode || this.workspaceService.isMultiRootWorkspaceOpened
        };
    }
    createFileNode(rootUri, path, fileUri, parent) {
        return {
            selected: false,
            path,
            children: [],
            expanded: true,
            id: `${rootUri}::${fileUri}`,
            parent,
            fileUri,
            uri: new uri_1.default(fileUri),
        };
    }
    createResultLineNode(result, match, fileNode) {
        return {
            ...result,
            ...match,
            selected: false,
            id: result.fileUri + '-' + match.line + '-' + match.character + '-' + match.length,
            name: typeof match.lineText === 'string' ? match.lineText : match.lineText.text,
            parent: fileNode
        };
    }
    getFileNodesByUri(uri) {
        const nodes = [];
        const fileUri = uri.withScheme('file').toString();
        for (const rootFolderNode of this.resultTree.values()) {
            const rootUri = new uri_1.default(rootFolderNode.path).withScheme('file');
            if (rootUri.isEqualOrParent(uri) || rootFolderNode.id === this.defaultRootName) {
                for (const fileNode of rootFolderNode.children) {
                    if (fileNode.fileUri === fileUri) {
                        nodes.push(fileNode);
                    }
                }
            }
        }
        return nodes;
    }
    filenameAndPath(rootUriStr, uriStr) {
        const uri = new uri_1.default(uriStr);
        const relativePath = new uri_1.default(rootUriStr).relative(uri.parent);
        return {
            name: this.labelProvider.getName(uri),
            path: relativePath ? relativePath.fsPath() : ''
        };
    }
    getDepthPadding(depth) {
        return super.getDepthPadding(depth) + 5;
    }
    renderCaption(node, props) {
        if (SearchInWorkspaceRootFolderNode.is(node)) {
            return this.renderRootFolderNode(node);
        }
        else if (SearchInWorkspaceFileNode.is(node)) {
            return this.renderFileNode(node);
        }
        else if (SearchInWorkspaceResultLineNode.is(node)) {
            return this.renderResultLineNode(node);
        }
        return '';
    }
    renderTailDecorations(node, props) {
        return React.createElement("div", { className: 'result-node-buttons' },
            this._showReplaceButtons && this.renderReplaceButton(node),
            this.renderRemoveButton(node));
    }
    doReplace(node, e) {
        const selection = browser_1.SelectableTreeNode.isSelected(node) ? this.selectionService.selection : [node];
        selection.forEach(n => this.replace(n));
        e.stopPropagation();
    }
    renderReplaceButton(node) {
        const isResultLineNode = SearchInWorkspaceResultLineNode.is(node);
        return React.createElement("span", { className: isResultLineNode ? (0, browser_1.codicon)('replace') : (0, browser_1.codicon)('replace-all'), onClick: e => this.doReplace(node, e), title: isResultLineNode
                ? nls_1.nls.localizeByDefault('Replace')
                : nls_1.nls.localizeByDefault('Replace All') });
    }
    getFileCount(node) {
        if (SearchInWorkspaceRoot.is(node)) {
            return node.children.reduce((acc, current) => acc + this.getFileCount(current), 0);
        }
        else if (SearchInWorkspaceRootFolderNode.is(node)) {
            return node.children.length;
        }
        else if (SearchInWorkspaceFileNode.is(node)) {
            return 1;
        }
        return 0;
    }
    getResultCount(node) {
        if (SearchInWorkspaceRoot.is(node)) {
            return node.children.reduce((acc, current) => acc + this.getResultCount(current), 0);
        }
        else if (SearchInWorkspaceRootFolderNode.is(node)) {
            return node.children.reduce((acc, current) => acc + this.getResultCount(current), 0);
        }
        else if (SearchInWorkspaceFileNode.is(node)) {
            return node.children.length;
        }
        else if (SearchInWorkspaceResultLineNode.is(node)) {
            return 1;
        }
        return 0;
    }
    /**
     * Replace results under the node passed into the function. If node is undefined, replace all results.
     * @param node Node in the tree widget where the "replace all" operation is performed
     */
    async replace(node) {
        const replaceForNode = node || this.model.root;
        const needConfirm = !SearchInWorkspaceFileNode.is(node) && !SearchInWorkspaceResultLineNode.is(node);
        const replacementText = this._replaceTerm;
        if (!needConfirm || await this.confirmReplaceAll(this.getResultCount(replaceForNode), this.getFileCount(replaceForNode), replacementText)) {
            (node ? [node] : Array.from(this.resultTree.values())).forEach(n => {
                this.replaceResult(n, !!node, replacementText);
                this.removeNode(n);
            });
        }
    }
    confirmReplaceAll(resultNumber, fileNumber, replacementText) {
        return new browser_1.ConfirmDialog({
            title: nls_1.nls.localizeByDefault('Replace All'),
            msg: this.buildReplaceAllConfirmationMessage(resultNumber, fileNumber, replacementText)
        }).open();
    }
    buildReplaceAllConfirmationMessage(occurrences, fileCount, replaceValue) {
        if (occurrences === 1) {
            if (fileCount === 1) {
                if (replaceValue) {
                    return nls_1.nls.localizeByDefault("Replace {0} occurrence across {1} file with '{2}'?", occurrences, fileCount, replaceValue);
                }
                return nls_1.nls.localizeByDefault('Replace {0} occurrence across {1} file?', occurrences, fileCount);
            }
            if (replaceValue) {
                return nls_1.nls.localizeByDefault("Replace {0} occurrence across {1} files with '{2}'?", occurrences, fileCount, replaceValue);
            }
            return nls_1.nls.localizeByDefault('Replace {0} occurrence across {1} files?', occurrences, fileCount);
        }
        if (fileCount === 1) {
            if (replaceValue) {
                return nls_1.nls.localizeByDefault("Replace {0} occurrences across {1} file with '{2}'?", occurrences, fileCount, replaceValue);
            }
            return nls_1.nls.localizeByDefault('Replace {0} occurrences across {1} file?', occurrences, fileCount);
        }
        if (replaceValue) {
            return nls_1.nls.localizeByDefault("Replace {0} occurrences across {1} files with '{2}'?", occurrences, fileCount, replaceValue);
        }
        return nls_1.nls.localizeByDefault('Replace {0} occurrences across {1} files?', occurrences, fileCount);
    }
    updateRightResults(node) {
        const fileNode = node.parent;
        const rightPositionedNodes = fileNode.children.filter(rl => rl.line === node.line && rl.character > node.character);
        const diff = this._replaceTerm.length - this.searchTerm.length;
        rightPositionedNodes.forEach(r => r.character += diff);
    }
    /**
     * Replace text either in all search matches under a node or in all search matches, and save the changes.
     * @param node - node in the tree widget in which the "replace all" is performed.
     * @param {boolean} replaceOne - whether the function is to replace all matches under a node. If it is false, replace all.
     * @param replacementText - text to be used for all replacements in the current replacement cycle.
     */
    async replaceResult(node, replaceOne, replacementText) {
        const toReplace = [];
        if (SearchInWorkspaceRootFolderNode.is(node)) {
            node.children.forEach(fileNode => this.replaceResult(fileNode, replaceOne, replacementText));
        }
        else if (SearchInWorkspaceFileNode.is(node)) {
            toReplace.push(...node.children);
        }
        else if (SearchInWorkspaceResultLineNode.is(node)) {
            toReplace.push(node);
            this.updateRightResults(node);
        }
        if (toReplace.length > 0) {
            // Store the state of all tracked editors before another editor widget might be created for text replacing.
            const trackedEditors = this.editorManager.all;
            // Open the file only if the function is called to replace all matches under a specific node.
            const widget = replaceOne ? await this.doOpen(toReplace[0]) : await this.doGetWidget(toReplace[0]);
            const source = widget.editor.document.getText();
            const replaceOperations = toReplace.map(resultLineNode => ({
                text: replacementText,
                range: {
                    start: {
                        line: resultLineNode.line - 1,
                        character: resultLineNode.character - 1
                    },
                    end: this.findEndCharacterPosition(resultLineNode),
                }
            }));
            // Replace the text.
            await widget.editor.replaceText({
                source,
                replaceOperations
            });
            // Save the text replacement changes in the editor.
            await widget.saveable.save();
            // Dispose the widget if it is not opened but created for `replaceAll`.
            if (!replaceOne) {
                if (trackedEditors.indexOf(widget) === -1) {
                    widget.dispose();
                }
            }
        }
    }
    doRemove(node, e) {
        const selection = browser_1.SelectableTreeNode.isSelected(node) ? this.selectionService.selection : [node];
        selection.forEach(n => this.removeNode(n));
        e.stopPropagation();
    }
    renderRemoveButton(node) {
        return React.createElement("span", { className: (0, browser_1.codicon)('close'), onClick: e => this.remove(node, e), title: 'Dismiss' });
    }
    removeNode(node) {
        if (SearchInWorkspaceRootFolderNode.is(node)) {
            this.removeRootFolderNode(node);
        }
        else if (SearchInWorkspaceFileNode.is(node)) {
            this.removeFileNode(node);
        }
        else if (SearchInWorkspaceResultLineNode.is(node)) {
            this.removeResultLineNode(node);
        }
        this.refreshModelChildren();
    }
    removeRootFolderNode(node) {
        for (const rootUri of this.resultTree.keys()) {
            if (rootUri === node.folderUri) {
                this.resultTree.delete(rootUri);
                break;
            }
        }
    }
    removeFileNode(node) {
        const rootFolderNode = node.parent;
        const index = rootFolderNode.children.findIndex(fileNode => fileNode.id === node.id);
        if (index > -1) {
            rootFolderNode.children.splice(index, 1);
        }
        if (this.getFileCount(rootFolderNode) === 0) {
            this.removeRootFolderNode(rootFolderNode);
        }
    }
    removeResultLineNode(node) {
        const fileNode = node.parent;
        const index = fileNode.children.findIndex(n => n.fileUri === node.fileUri && n.line === node.line && n.character === node.character);
        if (index > -1) {
            fileNode.children.splice(index, 1);
            if (this.getResultCount(fileNode) === 0) {
                this.removeFileNode(fileNode);
            }
        }
    }
    findEndCharacterPosition(node) {
        const lineText = typeof node.lineText === 'string' ? node.lineText : node.lineText.text;
        const lines = lineText.split('\n');
        const line = node.line + lines.length - 2;
        let character = node.character - 1 + node.length;
        if (lines.length > 1) {
            character = node.length - lines[0].length + node.character - lines.length;
            if (lines.length > 2) {
                for (const lineNum of Array(lines.length - 2).keys()) {
                    character -= lines[lineNum + 1].length;
                }
            }
        }
        return { line, character };
    }
    renderRootFolderNode(node) {
        return React.createElement("div", { className: 'result' },
            React.createElement("div", { className: 'result-head' },
                React.createElement("div", { className: `result-head-info noWrapInfo noselect ${node.selected ? 'selected' : ''}` },
                    React.createElement("span", { className: `file-icon ${this.toNodeIcon(node) || ''}` }),
                    React.createElement("div", { className: 'noWrapInfo' },
                        React.createElement("span", { className: 'file-name' }, this.toNodeName(node)),
                        node.path !== '/' + this.defaultRootName &&
                            React.createElement("span", { className: 'file-path ' + browser_1.TREE_NODE_INFO_CLASS }, node.path))),
                React.createElement("span", { className: 'notification-count-container highlighted-count-container' },
                    React.createElement("span", { className: 'notification-count' }, this.getFileCount(node)))));
    }
    renderFileNode(node) {
        return React.createElement("div", { className: 'result' },
            React.createElement("div", { className: 'result-head' },
                React.createElement("div", { className: `result-head-info noWrapInfo noselect ${node.selected ? 'selected' : ''}`, title: new uri_1.default(node.fileUri).path.fsPath() },
                    React.createElement("span", { className: `file-icon ${this.toNodeIcon(node)}` }),
                    React.createElement("div", { className: 'noWrapInfo' },
                        React.createElement("span", { className: 'file-name' }, this.toNodeName(node)),
                        React.createElement("span", { className: 'file-path ' + browser_1.TREE_NODE_INFO_CLASS }, node.path))),
                React.createElement("span", { className: 'notification-count-container' },
                    React.createElement("span", { className: 'notification-count' }, this.getResultCount(node)))));
    }
    renderResultLineNode(node) {
        const character = typeof node.lineText === 'string' ? node.character : node.lineText.character;
        const lineText = typeof node.lineText === 'string' ? node.lineText : node.lineText.text;
        let start = Math.max(0, character - 26);
        const wordBreak = /\b/g;
        while (start > 0 && wordBreak.test(lineText) && wordBreak.lastIndex < character) {
            if (character - wordBreak.lastIndex < 26) {
                break;
            }
            start = wordBreak.lastIndex;
            wordBreak.lastIndex++;
        }
        const before = lineText.slice(start, character - 1).trimStart();
        const lineCount = lineText.split('\n').length;
        return React.createElement(React.Fragment, null,
            React.createElement("div", { className: `resultLine noWrapInfo noselect ${node.selected ? 'selected' : ''}`, title: lineText.trim() },
                this.searchInWorkspacePreferences['search.lineNumbers'] && React.createElement("span", { className: 'theia-siw-lineNumber' }, node.line),
                React.createElement("span", null, before),
                this.renderMatchLinePart(node),
                lineCount > 1 || React.createElement("span", null, lineText.slice(node.character + node.length - 1, 250 - before.length + node.length))),
            lineCount > 1 && React.createElement("div", { className: 'match-line-num' },
                "+",
                lineCount - 1));
    }
    renderMatchLinePart(node) {
        const replaceTermLines = this._replaceTerm.split('\n');
        const replaceTerm = this.isReplacing ? React.createElement("span", { className: 'replace-term' }, replaceTermLines[0]) : '';
        const className = `match${this.isReplacing ? ' strike-through' : ''}`;
        const text = typeof node.lineText === 'string' ? node.lineText : node.lineText.text;
        const match = text.substring(node.character - 1, node.character + node.length - 1);
        const matchLines = match.split('\n');
        return React.createElement(React.Fragment, null,
            React.createElement("span", { className: className }, matchLines[0]),
            replaceTerm);
    }
    /**
     * Get the editor widget by the node.
     * @param {SearchInWorkspaceResultLineNode} node - the node representing a match in the search results.
     * @returns The editor widget to which the text replace will be done.
     */
    async doGetWidget(node) {
        const fileUri = new uri_1.default(node.fileUri);
        const editorWidget = await this.editorManager.getOrCreateByUri(fileUri);
        return editorWidget;
    }
    async doOpen(node, asDiffWidget = false, preview = false) {
        let fileUri;
        const resultNode = node.parent;
        if (resultNode && this.isReplacing && asDiffWidget) {
            const leftUri = new uri_1.default(node.fileUri);
            const rightUri = await this.createReplacePreview(resultNode);
            fileUri = browser_1.DiffUris.encode(leftUri, rightUri);
        }
        else {
            fileUri = new uri_1.default(node.fileUri);
        }
        const opts = {
            selection: {
                start: {
                    line: node.line - 1,
                    character: node.character - 1
                },
                end: this.findEndCharacterPosition(node),
            },
            mode: preview ? 'reveal' : 'activate',
            preview,
        };
        const editorWidget = await this.editorManager.open(fileUri, opts);
        if (!browser_1.DiffUris.isDiffUri(fileUri)) {
            this.decorateEditor(resultNode, editorWidget);
        }
        return editorWidget;
    }
    async createReplacePreview(node) {
        const fileUri = new uri_1.default(node.fileUri).withScheme('file');
        const openedEditor = this.editorManager.all.find(({ editor }) => editor.uri.toString() === fileUri.toString());
        let content;
        if (openedEditor) {
            content = openedEditor.editor.document.getText();
        }
        else {
            const resource = await this.fileResourceResolver.resolve(fileUri);
            content = await resource.readContents();
        }
        const searchTermRegExp = new RegExp(this.searchTerm, 'g');
        return fileUri.withScheme(common_1.MEMORY_TEXT).withQuery(content.replace(searchTermRegExp, this._replaceTerm));
    }
    decorateEditor(node, editorWidget) {
        if (!browser_1.DiffUris.isDiffUri(editorWidget.editor.uri)) {
            const key = `${editorWidget.editor.uri.toString()}#search-in-workspace-matches`;
            const oldDecorations = this.appliedDecorations.get(key) || [];
            const newDecorations = this.createEditorDecorations(node);
            const appliedDecorations = editorWidget.editor.deltaDecorations({
                newDecorations,
                oldDecorations,
            });
            this.appliedDecorations.set(key, appliedDecorations);
        }
    }
    createEditorDecorations(resultNode) {
        const decorations = [];
        if (resultNode) {
            resultNode.children.forEach(res => {
                decorations.push({
                    range: {
                        start: {
                            line: res.line - 1,
                            character: res.character - 1
                        },
                        end: {
                            line: res.line - 1,
                            character: res.character - 1 + res.length
                        }
                    },
                    options: {
                        overviewRuler: {
                            color: {
                                id: 'editor.findMatchHighlightBackground'
                            },
                            position: browser_2.OverviewRulerLane.Center
                        },
                        className: res.selected ? 'current-search-in-workspace-editor-match' : 'search-in-workspace-editor-match',
                        stickiness: browser_2.TrackedRangeStickiness.GrowsOnlyWhenTypingBefore
                    }
                });
            });
        }
        return decorations;
    }
    /**
     * Get the list of exclude globs.
     * @param excludeOptions the exclude search option.
     *
     * @returns the list of exclude globs.
     */
    getExcludeGlobs(excludeOptions) {
        const excludePreferences = this.filesystemPreferences['files.exclude'];
        const excludePreferencesGlobs = Object.keys(excludePreferences).filter(key => !!excludePreferences[key]);
        return [...new Set([...excludePreferencesGlobs, ...excludeOptions || []])];
    }
    /**
     * Compare two normalized strings.
     *
     * @param a {string} the first string.
     * @param b {string} the second string.
     */
    compare(a, b) {
        const itemA = a.toLowerCase().trim();
        const itemB = b.toLowerCase().trim();
        return itemA.localeCompare(itemB);
    }
    /**
     * @param recursive if true, all child nodes will be included in the stringified result.
     */
    nodeToString(node, recursive) {
        if (SearchInWorkspaceFileNode.is(node) || SearchInWorkspaceRootFolderNode.is(node)) {
            if (recursive) {
                return this.nodeIteratorToString(new browser_1.TopDownTreeIterator(node, { pruneSiblings: true }));
            }
            return this.labelProvider.getLongName(node.uri);
        }
        if (SearchInWorkspaceResultLineNode.is(node)) {
            return `  ${node.line}:${node.character}: ${node.lineText}`;
        }
        return '';
    }
    treeToString() {
        return this.nodeIteratorToString(this.getVisibleNodes());
    }
    *getVisibleNodes() {
        for (const { node } of this.rows.values()) {
            yield node;
        }
    }
    nodeIteratorToString(nodes) {
        const strings = [];
        for (const node of nodes) {
            const string = this.nodeToString(node, false);
            if (string.length !== 0) {
                strings.push(string);
            }
        }
        return strings.join(core_1.EOL);
    }
};
exports.SearchInWorkspaceResultTreeWidget = SearchInWorkspaceResultTreeWidget;
tslib_1.__decorate([
    (0, inversify_1.inject)(search_in_workspace_service_1.SearchInWorkspaceService),
    tslib_1.__metadata("design:type", search_in_workspace_service_1.SearchInWorkspaceService)
], SearchInWorkspaceResultTreeWidget.prototype, "searchService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    tslib_1.__metadata("design:type", browser_2.EditorManager)
], SearchInWorkspaceResultTreeWidget.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_4.FileResourceResolver),
    tslib_1.__metadata("design:type", browser_4.FileResourceResolver)
], SearchInWorkspaceResultTreeWidget.prototype, "fileResourceResolver", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], SearchInWorkspaceResultTreeWidget.prototype, "shell", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.WorkspaceService),
    tslib_1.__metadata("design:type", browser_3.WorkspaceService)
], SearchInWorkspaceResultTreeWidget.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.TreeExpansionService),
    tslib_1.__metadata("design:type", Object)
], SearchInWorkspaceResultTreeWidget.prototype, "expansionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(search_in_workspace_preferences_1.SearchInWorkspacePreferences),
    tslib_1.__metadata("design:type", Object)
], SearchInWorkspaceResultTreeWidget.prototype, "searchInWorkspacePreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ProgressService),
    tslib_1.__metadata("design:type", core_1.ProgressService)
], SearchInWorkspaceResultTreeWidget.prototype, "progressService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(color_registry_1.ColorRegistry),
    tslib_1.__metadata("design:type", color_registry_1.ColorRegistry)
], SearchInWorkspaceResultTreeWidget.prototype, "colorRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_4.FileSystemPreferences),
    tslib_1.__metadata("design:type", Object)
], SearchInWorkspaceResultTreeWidget.prototype, "filesystemPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], SearchInWorkspaceResultTreeWidget.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], SearchInWorkspaceResultTreeWidget.prototype, "init", null);
exports.SearchInWorkspaceResultTreeWidget = SearchInWorkspaceResultTreeWidget = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(browser_1.TreeProps)),
    tslib_1.__param(1, (0, inversify_1.inject)(browser_1.TreeModel)),
    tslib_1.__param(2, (0, inversify_1.inject)(browser_1.ContextMenuRenderer)),
    tslib_1.__metadata("design:paramtypes", [Object, Object, browser_1.ContextMenuRenderer])
], SearchInWorkspaceResultTreeWidget);
(function (SearchInWorkspaceResultTreeWidget) {
    let Menus;
    (function (Menus) {
        Menus.BASE = ['siw-tree-context-menu'];
        /** Dismiss command, or others that only affect the widget itself */
        Menus.INTERNAL = [...Menus.BASE, '1_internal'];
        /** Copy a stringified representation of content */
        Menus.COPY = [...Menus.BASE, '2_copy'];
        /** Commands that lead out of the widget, like revealing a file in the navigator */
        Menus.EXTERNAL = [...Menus.BASE, '3_external'];
    })(Menus = SearchInWorkspaceResultTreeWidget.Menus || (SearchInWorkspaceResultTreeWidget.Menus = {}));
})(SearchInWorkspaceResultTreeWidget || (exports.SearchInWorkspaceResultTreeWidget = SearchInWorkspaceResultTreeWidget = {}));


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-service.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-service.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017-2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchInWorkspaceService = exports.SearchInWorkspaceClientImpl = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const search_in_workspace_interface_1 = __webpack_require__(/*! ../common/search-in-workspace-interface */ "../../node_modules/@theia/search-in-workspace/lib/common/search-in-workspace-interface.js");
const browser_1 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
/**
 * Class that will receive the search results from the server.  This is separate
 * from the SearchInWorkspaceService class only to avoid a cycle in the
 * dependency injection.
 */
let SearchInWorkspaceClientImpl = class SearchInWorkspaceClientImpl {
    onResult(searchId, result) {
        this.service.onResult(searchId, result);
    }
    onDone(searchId, error) {
        this.service.onDone(searchId, error);
    }
    setService(service) {
        this.service = service;
    }
};
exports.SearchInWorkspaceClientImpl = SearchInWorkspaceClientImpl;
exports.SearchInWorkspaceClientImpl = SearchInWorkspaceClientImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SearchInWorkspaceClientImpl);
/**
 * Service to search text in the workspace files.
 */
let SearchInWorkspaceService = class SearchInWorkspaceService {
    constructor() {
        // All the searches that we have started, that are not done yet (onDone
        // with that searchId has not been called).
        this.pendingSearches = new Map();
        // Due to the asynchronicity of the node backend, it's possible that we
        // start a search, receive an event for that search, and then receive
        // the search id for that search.We therefore need to keep those
        // events until we get the search id and return it to the caller.
        // Otherwise the caller would discard the event because it doesn't know
        // the search id yet.
        this.pendingOnDones = new Map();
        this.lastKnownSearchId = -1;
    }
    init() {
        this.client.setService(this);
    }
    isEnabled() {
        return this.workspaceService.opened;
    }
    onResult(searchId, result) {
        const callbacks = this.pendingSearches.get(searchId);
        if (callbacks) {
            callbacks.onResult(searchId, result);
        }
    }
    onDone(searchId, error) {
        const callbacks = this.pendingSearches.get(searchId);
        if (callbacks) {
            this.pendingSearches.delete(searchId);
            callbacks.onDone(searchId, error);
        }
        else {
            if (searchId > this.lastKnownSearchId) {
                this.logger.debug(`Got an onDone for a searchId we don't know about (${searchId}), stashing it for later with error = `, error);
                this.pendingOnDones.set(searchId, error);
            }
            else {
                // It's possible to receive an onDone for a search we have cancelled.  Just ignore it.
                this.logger.debug(`Got an onDone for a searchId we don't know about (${searchId}), but it's probably an old one, error = `, error);
            }
        }
    }
    // Start a search of the string "what" in the workspace.
    async search(what, callbacks, opts) {
        if (!this.workspaceService.opened) {
            throw new Error('Search failed: no workspace root.');
        }
        const roots = await this.workspaceService.roots;
        return this.doSearch(what, roots.map(r => r.resource.toString()), callbacks, opts);
    }
    async doSearch(what, rootsUris, callbacks, opts) {
        const searchId = await this.searchServer.search(what, rootsUris, opts);
        this.pendingSearches.set(searchId, callbacks);
        this.lastKnownSearchId = searchId;
        this.logger.debug('Service launched search ' + searchId);
        // Check if we received an onDone before search() returned.
        if (this.pendingOnDones.has(searchId)) {
            this.logger.debug('Ohh, we have a stashed onDone for that searchId');
            const error = this.pendingOnDones.get(searchId);
            this.pendingOnDones.delete(searchId);
            // Call the client's searchId, but first give it a
            // chance to record the returned searchId.
            setTimeout(() => {
                this.onDone(searchId, error);
            }, 0);
        }
        return searchId;
    }
    async searchWithCallback(what, rootsUris, callbacks, opts) {
        return this.doSearch(what, rootsUris, callbacks, opts);
    }
    // Cancel an ongoing search.
    cancel(searchId) {
        this.pendingSearches.delete(searchId);
        this.searchServer.cancel(searchId);
    }
};
exports.SearchInWorkspaceService = SearchInWorkspaceService;
tslib_1.__decorate([
    (0, inversify_1.inject)(search_in_workspace_interface_1.SearchInWorkspaceServer),
    tslib_1.__metadata("design:type", Object)
], SearchInWorkspaceService.prototype, "searchServer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(SearchInWorkspaceClientImpl),
    tslib_1.__metadata("design:type", SearchInWorkspaceClientImpl)
], SearchInWorkspaceService.prototype, "client", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WorkspaceService),
    tslib_1.__metadata("design:type", browser_1.WorkspaceService)
], SearchInWorkspaceService.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    tslib_1.__metadata("design:type", Object)
], SearchInWorkspaceService.prototype, "logger", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], SearchInWorkspaceService.prototype, "init", null);
exports.SearchInWorkspaceService = SearchInWorkspaceService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SearchInWorkspaceService);


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-widget.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-widget.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var SearchInWorkspaceWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchInWorkspaceWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const search_in_workspace_result_tree_widget_1 = __webpack_require__(/*! ./search-in-workspace-result-tree-widget */ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-result-tree-widget.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const client_1 = __webpack_require__(/*! @theia/core/shared/react-dom/client */ "../../node_modules/@theia/core/shared/react-dom/client/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const search_in_workspace_context_key_service_1 = __webpack_require__(/*! ./search-in-workspace-context-key-service */ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-context-key-service.js");
const progress_bar_factory_1 = __webpack_require__(/*! @theia/core/lib/browser/progress-bar-factory */ "../../node_modules/@theia/core/lib/browser/progress-bar-factory.js");
const browser_3 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const search_in_workspace_preferences_1 = __webpack_require__(/*! ./search-in-workspace-preferences */ "../../node_modules/@theia/search-in-workspace/lib/browser/search-in-workspace-preferences.js");
const search_in_workspace_input_1 = __webpack_require__(/*! ./components/search-in-workspace-input */ "../../node_modules/@theia/search-in-workspace/lib/browser/components/search-in-workspace-input.js");
const search_in_workspace_textarea_1 = __webpack_require__(/*! ./components/search-in-workspace-textarea */ "../../node_modules/@theia/search-in-workspace/lib/browser/components/search-in-workspace-textarea.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
let SearchInWorkspaceWidget = SearchInWorkspaceWidget_1 = class SearchInWorkspaceWidget extends browser_1.BaseWidget {
    constructor() {
        super(...arguments);
        this.showSearchDetails = false;
        this._hasResults = false;
        this.resultNumber = 0;
        this.searchFieldContainerIsFocused = false;
        this.searchTerm = '';
        this.replaceTerm = '';
        this.searchRef = React.createRef();
        this.replaceRef = React.createRef();
        this.includeRef = React.createRef();
        this.excludeRef = React.createRef();
        this.refsAreSet = new promise_util_1.Deferred();
        this._showReplaceField = false;
        this.onDidUpdateEmitter = new common_1.Emitter();
        this.onDidUpdate = this.onDidUpdateEmitter.event;
        this.focusSearchFieldContainer = () => this.doFocusSearchFieldContainer();
        this.blurSearchFieldContainer = () => this.doBlurSearchFieldContainer();
        this.search = (e) => {
            e.persist();
            const searchOnType = this.searchInWorkspacePreferences['search.searchOnType'];
            if (searchOnType) {
                const delay = this.searchInWorkspacePreferences['search.searchOnTypeDebouncePeriod'] || 0;
                window.clearTimeout(this._searchTimeout);
                this._searchTimeout = window.setTimeout(() => this.doSearch(e), delay);
            }
        };
        this.onKeyDownSearch = (e) => {
            var _a;
            if (browser_1.Key.ENTER.keyCode === ((_a = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode)) {
                this.searchTerm = e.target.value;
                this.performSearch();
            }
        };
        this.handleFocusSearchInputBox = (event) => {
            event.target.placeholder = SearchInWorkspaceWidget_1.LABEL + nls_1.nls.localizeByDefault(' ({0} for history)', '⇅');
            this.contextKeyService.setSearchInputBoxFocus(true);
        };
        this.handleBlurSearchInputBox = (event) => {
            event.target.placeholder = SearchInWorkspaceWidget_1.LABEL;
            this.contextKeyService.setSearchInputBoxFocus(false);
        };
        this.updateReplaceTerm = (e) => this.doUpdateReplaceTerm(e);
        this.handleFocusReplaceInputBox = (event) => {
            event.target.placeholder = nls_1.nls.localizeByDefault('Replace') + nls_1.nls.localizeByDefault(' ({0} for history)', '⇅');
            this.contextKeyService.setReplaceInputBoxFocus(true);
        };
        this.handleBlurReplaceInputBox = (event) => {
            event.target.placeholder = nls_1.nls.localizeByDefault('Replace');
            this.contextKeyService.setReplaceInputBoxFocus(false);
        };
        this.handleFocusIncludesInputBox = () => this.contextKeyService.setPatternIncludesInputBoxFocus(true);
        this.handleBlurIncludesInputBox = () => this.contextKeyService.setPatternIncludesInputBoxFocus(false);
        this.handleFocusExcludesInputBox = () => this.contextKeyService.setPatternExcludesInputBoxFocus(true);
        this.handleBlurExcludesInputBox = () => this.contextKeyService.setPatternExcludesInputBoxFocus(false);
    }
    get hasResults() {
        return this._hasResults;
    }
    set hasResults(hasResults) {
        this.contextKeyService.hasSearchResult.set(hasResults);
        this._hasResults = hasResults;
    }
    get showReplaceField() {
        return this._showReplaceField;
    }
    set showReplaceField(showReplaceField) {
        this.contextKeyService.replaceActive.set(showReplaceField);
        this._showReplaceField = showReplaceField;
    }
    init() {
        this.id = SearchInWorkspaceWidget_1.ID;
        this.title.label = SearchInWorkspaceWidget_1.LABEL;
        this.title.caption = SearchInWorkspaceWidget_1.LABEL;
        this.title.iconClass = (0, browser_1.codicon)('search');
        this.title.closable = true;
        this.contentNode = document.createElement('div');
        this.contentNode.classList.add('t-siw-search-container');
        this.searchFormContainer = document.createElement('div');
        this.searchFormContainer.classList.add('searchHeader');
        this.contentNode.appendChild(this.searchFormContainer);
        this.searchFormContainerRoot = (0, client_1.createRoot)(this.searchFormContainer);
        this.node.tabIndex = 0;
        this.node.appendChild(this.contentNode);
        this.matchCaseState = {
            className: (0, browser_1.codicon)('case-sensitive'),
            enabled: false,
            title: nls_1.nls.localizeByDefault('Match Case')
        };
        this.wholeWordState = {
            className: (0, browser_1.codicon)('whole-word'),
            enabled: false,
            title: nls_1.nls.localizeByDefault('Match Whole Word')
        };
        this.regExpState = {
            className: (0, browser_1.codicon)('regex'),
            enabled: false,
            title: nls_1.nls.localizeByDefault('Use Regular Expression')
        };
        this.includeIgnoredState = {
            className: (0, browser_1.codicon)('eye'),
            enabled: false,
            title: nls_1.nls.localize('theia/search-in-workspace/includeIgnoredFiles', 'Include Ignored Files')
        };
        this.searchInWorkspaceOptions = {
            matchCase: false,
            matchWholeWord: false,
            useRegExp: false,
            multiline: false,
            includeIgnored: false,
            include: [],
            exclude: [],
            maxResults: 2000
        };
        this.toDispose.push(this.resultTreeWidget.onChange(r => {
            this.hasResults = r.size > 0;
            this.resultNumber = 0;
            const results = Array.from(r.values());
            results.forEach(rootFolder => rootFolder.children.forEach(file => this.resultNumber += file.children.length));
            this.update();
        }));
        this.toDispose.push(this.resultTreeWidget.onFocusInput(b => {
            this.focusInputField();
        }));
        this.toDispose.push(this.searchInWorkspacePreferences.onPreferenceChanged(e => {
            if (e.preferenceName === 'search.smartCase') {
                this.performSearch();
            }
        }));
        this.toDispose.push(this.resultTreeWidget);
        this.toDispose.push(this.resultTreeWidget.onExpansionChanged(() => {
            this.onDidUpdateEmitter.fire();
        }));
        this.toDispose.push(this.progressBarFactory({ container: this.node, insertMode: 'prepend', locationId: 'search' }));
    }
    storeState() {
        var _a, _b, _c, _d;
        return {
            matchCaseState: this.matchCaseState,
            wholeWordState: this.wholeWordState,
            regExpState: this.regExpState,
            includeIgnoredState: this.includeIgnoredState,
            showSearchDetails: this.showSearchDetails,
            searchInWorkspaceOptions: this.searchInWorkspaceOptions,
            searchTerm: this.searchTerm,
            replaceTerm: this.replaceTerm,
            showReplaceField: this.showReplaceField,
            searchHistoryState: (_a = this.searchRef.current) === null || _a === void 0 ? void 0 : _a.state,
            replaceHistoryState: (_b = this.replaceRef.current) === null || _b === void 0 ? void 0 : _b.state,
            includeHistoryState: (_c = this.includeRef.current) === null || _c === void 0 ? void 0 : _c.state,
            excludeHistoryState: (_d = this.excludeRef.current) === null || _d === void 0 ? void 0 : _d.state,
        };
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    restoreState(oldState) {
        var _a, _b, _c, _d;
        this.matchCaseState = oldState.matchCaseState;
        this.wholeWordState = oldState.wholeWordState;
        this.regExpState = oldState.regExpState;
        this.includeIgnoredState = oldState.includeIgnoredState;
        // Override the title of the restored state, as we could have changed languages in between
        this.matchCaseState.title = nls_1.nls.localizeByDefault('Match Case');
        this.wholeWordState.title = nls_1.nls.localizeByDefault('Match Whole Word');
        this.regExpState.title = nls_1.nls.localizeByDefault('Use Regular Expression');
        this.includeIgnoredState.title = nls_1.nls.localize('theia/search-in-workspace/includeIgnoredFiles', 'Include Ignored Files');
        this.showSearchDetails = oldState.showSearchDetails;
        this.searchInWorkspaceOptions = oldState.searchInWorkspaceOptions;
        this.searchTerm = oldState.searchTerm;
        this.replaceTerm = oldState.replaceTerm;
        this.showReplaceField = oldState.showReplaceField;
        this.resultTreeWidget.replaceTerm = this.replaceTerm;
        this.resultTreeWidget.showReplaceButtons = this.showReplaceField;
        (_a = this.searchRef.current) === null || _a === void 0 ? void 0 : _a.setState(oldState.searchHistoryState);
        (_b = this.replaceRef.current) === null || _b === void 0 ? void 0 : _b.setState(oldState.replaceHistoryState);
        (_c = this.includeRef.current) === null || _c === void 0 ? void 0 : _c.setState(oldState.includeHistoryState);
        (_d = this.excludeRef.current) === null || _d === void 0 ? void 0 : _d.setState(oldState.excludeHistoryState);
        this.refresh();
    }
    findInFolder(uris) {
        this.showSearchDetails = true;
        const values = Array.from(new Set(uris.map(uri => `${uri}/**`)));
        const value = values.join(', ');
        this.searchInWorkspaceOptions.include = values;
        if (this.includeRef.current) {
            this.includeRef.current.value = value;
            this.includeRef.current.addToHistory();
        }
        this.update();
    }
    /**
     * Update the search term and input field.
     * @param term the search term.
     * @param showReplaceField controls if the replace field should be displayed.
     */
    updateSearchTerm(term, showReplaceField) {
        this.searchTerm = term;
        if (this.searchRef.current) {
            this.searchRef.current.value = term;
            this.searchRef.current.addToHistory();
        }
        if (showReplaceField) {
            this.showReplaceField = true;
        }
        this.refresh();
    }
    hasResultList() {
        return this.hasResults;
    }
    hasSearchTerm() {
        return this.searchTerm !== '';
    }
    refresh() {
        this.performSearch();
        this.update();
    }
    getCancelIndicator() {
        return this.resultTreeWidget.cancelIndicator;
    }
    collapseAll() {
        this.resultTreeWidget.collapseAll();
        this.update();
    }
    expandAll() {
        this.resultTreeWidget.expandAll();
        this.update();
    }
    areResultsCollapsed() {
        return this.resultTreeWidget.areResultsCollapsed();
    }
    clear() {
        this.searchTerm = '';
        this.replaceTerm = '';
        this.searchInWorkspaceOptions.include = [];
        this.searchInWorkspaceOptions.exclude = [];
        this.includeIgnoredState.enabled = false;
        this.matchCaseState.enabled = false;
        this.wholeWordState.enabled = false;
        this.regExpState.enabled = false;
        if (this.searchRef.current) {
            this.searchRef.current.value = '';
        }
        if (this.replaceRef.current) {
            this.replaceRef.current.value = '';
        }
        if (this.includeRef.current) {
            this.includeRef.current.value = '';
        }
        if (this.excludeRef.current) {
            this.excludeRef.current.value = '';
        }
        this.performSearch();
        this.update();
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        this.searchFormContainerRoot.render(React.createElement(React.Fragment, null,
            this.renderSearchHeader(),
            this.renderSearchInfo()));
        browser_1.Widget.attach(this.resultTreeWidget, this.contentNode);
        this.toDisposeOnDetach.push(common_1.Disposable.create(() => {
            browser_1.Widget.detach(this.resultTreeWidget);
        }));
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        const searchInfo = this.renderSearchInfo();
        if (searchInfo) {
            this.searchFormContainerRoot.render(React.createElement(React.Fragment, null,
                this.renderSearchHeader(),
                searchInfo));
            this.onDidUpdateEmitter.fire(undefined);
        }
    }
    onResize(msg) {
        var _a, _b;
        super.onResize(msg);
        (_a = this.searchRef.current) === null || _a === void 0 ? void 0 : _a.forceUpdate();
        (_b = this.replaceRef.current) === null || _b === void 0 ? void 0 : _b.forceUpdate();
        browser_1.MessageLoop.sendMessage(this.resultTreeWidget, browser_1.Widget.ResizeMessage.UnknownSize);
    }
    onAfterShow(msg) {
        super.onAfterShow(msg);
        this.focusInputField();
        this.contextKeyService.searchViewletVisible.set(true);
    }
    onAfterHide(msg) {
        super.onAfterHide(msg);
        this.contextKeyService.searchViewletVisible.set(false);
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.focusInputField();
    }
    async focusInputField() {
        var _a;
        // Wait until React rendering is sufficiently progressed before trying to focus the input field.
        await this.refsAreSet.promise;
        if ((_a = this.searchRef.current) === null || _a === void 0 ? void 0 : _a.textarea.current) {
            this.searchRef.current.textarea.current.focus();
            this.searchRef.current.textarea.current.select();
        }
    }
    renderSearchHeader() {
        const searchAndReplaceContainer = this.renderSearchAndReplace();
        const searchDetails = this.renderSearchDetails();
        return React.createElement("div", { ref: () => this.refsAreSet.resolve() },
            searchAndReplaceContainer,
            searchDetails);
    }
    renderSearchAndReplace() {
        const toggleContainer = this.renderReplaceFieldToggle();
        const searchField = this.renderSearchField();
        const replaceField = this.renderReplaceField();
        return React.createElement("div", { className: 'search-and-replace-container' },
            toggleContainer,
            React.createElement("div", { className: 'search-and-replace-fields' },
                searchField,
                replaceField));
    }
    renderReplaceFieldToggle() {
        const toggle = React.createElement("span", { className: (0, browser_1.codicon)(this.showReplaceField ? 'chevron-down' : 'chevron-right') });
        return React.createElement("div", { title: nls_1.nls.localizeByDefault('Toggle Replace'), className: 'replace-toggle', tabIndex: 0, onClick: e => {
                const elArr = document.getElementsByClassName('replace-toggle');
                if (elArr && elArr.length > 0) {
                    elArr[0].focus();
                }
                this.showReplaceField = !this.showReplaceField;
                this.resultTreeWidget.showReplaceButtons = this.showReplaceField;
                this.update();
            } }, toggle);
    }
    renderNotification() {
        if (this.workspaceService.tryGetRoots().length <= 0 && this.editorManager.all.length <= 0) {
            return React.createElement("div", { className: 'search-notification show' },
                React.createElement("div", null, nls_1.nls.localize('theia/search-in-workspace/noFolderSpecified', 'You have not opened or specified a folder. Only open files are currently searched.')));
        }
        return React.createElement("div", { className: `search-notification ${this.searchInWorkspaceOptions.maxResults && this.resultNumber >= this.searchInWorkspaceOptions.maxResults ? 'show' : ''}` },
            React.createElement("div", null, nls_1.nls.localize('theia/search-in-workspace/resultSubset', 'This is only a subset of all results. Use a more specific search term to narrow down the result list.')));
    }
    doFocusSearchFieldContainer() {
        this.searchFieldContainerIsFocused = true;
        this.update();
    }
    doBlurSearchFieldContainer() {
        this.searchFieldContainerIsFocused = false;
        this.update();
    }
    doSearch(e) {
        var _a;
        if (e.target) {
            const searchValue = e.target.value;
            if (this.searchTerm === searchValue && browser_1.Key.ENTER.keyCode !== ((_a = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode)) {
                return;
            }
            else {
                this.searchTerm = searchValue;
                this.performSearch();
            }
        }
    }
    performSearch() {
        const searchOptions = {
            ...this.searchInWorkspaceOptions,
            followSymlinks: this.shouldFollowSymlinks(),
            matchCase: this.shouldMatchCase(),
            multiline: this.searchTerm.includes('\n')
        };
        this.resultTreeWidget.search(this.searchTerm, searchOptions);
    }
    shouldFollowSymlinks() {
        return this.searchInWorkspacePreferences['search.followSymlinks'];
    }
    /**
     * Determine if search should be case sensitive.
     */
    shouldMatchCase() {
        if (this.matchCaseState.enabled) {
            return this.matchCaseState.enabled;
        }
        // search.smartCase makes siw search case-sensitive if the search term contains uppercase letter(s).
        return (!!this.searchInWorkspacePreferences['search.smartCase']
            && this.searchTerm !== this.searchTerm.toLowerCase());
    }
    renderSearchField() {
        const input = React.createElement(search_in_workspace_textarea_1.SearchInWorkspaceTextArea, { id: 'search-input-field', className: 'theia-input', title: SearchInWorkspaceWidget_1.LABEL, placeholder: SearchInWorkspaceWidget_1.LABEL, defaultValue: this.searchTerm, autoComplete: 'off', onKeyUp: this.search, onKeyDown: this.onKeyDownSearch, onFocus: this.handleFocusSearchInputBox, onBlur: this.handleBlurSearchInputBox, ref: this.searchRef });
        const notification = this.renderNotification();
        const optionContainer = this.renderOptionContainer();
        const tooMany = this.searchInWorkspaceOptions.maxResults && this.resultNumber >= this.searchInWorkspaceOptions.maxResults ? 'tooManyResults' : '';
        const className = `search-field-container ${tooMany} ${this.searchFieldContainerIsFocused ? 'focused' : ''}`;
        return React.createElement("div", { className: className },
            React.createElement("div", { className: 'search-field', tabIndex: -1, onFocus: this.focusSearchFieldContainer, onBlur: this.blurSearchFieldContainer },
                input,
                optionContainer),
            notification);
    }
    doUpdateReplaceTerm(e) {
        var _a;
        if (e.target) {
            this.replaceTerm = e.target.value;
            this.resultTreeWidget.replaceTerm = this.replaceTerm;
            if (((_a = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode) === browser_1.Key.ENTER.keyCode) {
                this.performSearch();
            }
            this.update();
        }
    }
    renderReplaceField() {
        const replaceAllButtonContainer = this.renderReplaceAllButtonContainer();
        const replace = nls_1.nls.localizeByDefault('Replace');
        return React.createElement("div", { className: `replace-field${this.showReplaceField ? '' : ' hidden'}` },
            React.createElement(search_in_workspace_textarea_1.SearchInWorkspaceTextArea, { id: 'replace-input-field', className: 'theia-input', title: replace, placeholder: replace, defaultValue: this.replaceTerm, autoComplete: 'off', onKeyUp: this.updateReplaceTerm, onFocus: this.handleFocusReplaceInputBox, onBlur: this.handleBlurReplaceInputBox, ref: this.replaceRef }),
            replaceAllButtonContainer);
    }
    renderReplaceAllButtonContainer() {
        // The `Replace All` button is enabled if there is a search term present with results.
        const enabled = this.searchTerm !== '' && this.resultNumber > 0;
        return React.createElement("div", { className: 'replace-all-button-container' },
            React.createElement("span", { title: nls_1.nls.localizeByDefault('Replace All'), className: `${(0, browser_1.codicon)('replace-all', true)} ${enabled ? ' ' : ' disabled'}`, onClick: () => {
                    if (enabled) {
                        this.resultTreeWidget.replace(undefined);
                    }
                } }));
    }
    renderOptionContainer() {
        const matchCaseOption = this.renderOptionElement(this.matchCaseState);
        const wholeWordOption = this.renderOptionElement(this.wholeWordState);
        const regexOption = this.renderOptionElement(this.regExpState);
        const includeIgnoredOption = this.renderOptionElement(this.includeIgnoredState);
        return React.createElement("div", { className: 'option-buttons' },
            matchCaseOption,
            wholeWordOption,
            regexOption,
            includeIgnoredOption);
    }
    renderOptionElement(opt) {
        return React.createElement("span", { className: `${opt.className} option action-label ${opt.enabled ? 'enabled' : ''}`, title: opt.title, onClick: () => this.handleOptionClick(opt) });
    }
    handleOptionClick(option) {
        option.enabled = !option.enabled;
        this.updateSearchOptions();
        this.searchFieldContainerIsFocused = true;
        this.performSearch();
        this.update();
    }
    updateSearchOptions() {
        this.searchInWorkspaceOptions.matchCase = this.matchCaseState.enabled;
        this.searchInWorkspaceOptions.matchWholeWord = this.wholeWordState.enabled;
        this.searchInWorkspaceOptions.useRegExp = this.regExpState.enabled;
        this.searchInWorkspaceOptions.includeIgnored = this.includeIgnoredState.enabled;
    }
    renderSearchDetails() {
        const expandButton = this.renderExpandGlobFieldsButton();
        const globFieldContainer = this.renderGlobFieldContainer();
        return React.createElement("div", { className: 'search-details' },
            expandButton,
            globFieldContainer);
    }
    renderGlobFieldContainer() {
        const includeField = this.renderGlobField('include');
        const excludeField = this.renderGlobField('exclude');
        return React.createElement("div", { className: `glob-field-container${!this.showSearchDetails ? ' hidden' : ''}` },
            includeField,
            excludeField);
    }
    renderExpandGlobFieldsButton() {
        return React.createElement("div", { className: 'button-container' },
            React.createElement("span", { title: nls_1.nls.localizeByDefault('Toggle Search Details'), className: (0, browser_1.codicon)('ellipsis'), onClick: () => {
                    this.showSearchDetails = !this.showSearchDetails;
                    this.update();
                } }));
    }
    renderGlobField(kind) {
        const currentValue = this.searchInWorkspaceOptions[kind];
        const value = currentValue && currentValue.join(', ') || '';
        return React.createElement("div", { className: 'glob-field' },
            React.createElement("div", { className: 'label' }, nls_1.nls.localizeByDefault('files to ' + kind)),
            React.createElement(search_in_workspace_input_1.SearchInWorkspaceInput, { className: 'theia-input', type: 'text', size: 1, defaultValue: value, autoComplete: 'off', id: kind + '-glob-field', placeholder: kind === 'include'
                    ? nls_1.nls.localizeByDefault('e.g. *.ts, src/**/include')
                    : nls_1.nls.localizeByDefault('e.g. *.ts, src/**/exclude'), onKeyUp: e => {
                    var _a;
                    if (e.target) {
                        const targetValue = e.target.value || '';
                        let shouldSearch = browser_1.Key.ENTER.keyCode === ((_a = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode);
                        const currentOptions = (this.searchInWorkspaceOptions[kind] || []).slice().map(s => s.trim()).sort();
                        const candidateOptions = this.splitOnComma(targetValue).map(s => s.trim()).sort();
                        const sameAs = (left, right) => {
                            if (left.length !== right.length) {
                                return false;
                            }
                            for (let i = 0; i < left.length; i++) {
                                if (left[i] !== right[i]) {
                                    return false;
                                }
                            }
                            return true;
                        };
                        if (!sameAs(currentOptions, candidateOptions)) {
                            this.searchInWorkspaceOptions[kind] = this.splitOnComma(targetValue);
                            shouldSearch = true;
                        }
                        if (shouldSearch) {
                            this.performSearch();
                        }
                    }
                }, onFocus: kind === 'include' ? this.handleFocusIncludesInputBox : this.handleFocusExcludesInputBox, onBlur: kind === 'include' ? this.handleBlurIncludesInputBox : this.handleBlurExcludesInputBox, ref: kind === 'include' ? this.includeRef : this.excludeRef }));
    }
    splitOnComma(patterns) {
        return patterns.length > 0 ? patterns.split(',').map(s => s.trim()) : [];
    }
    renderSearchInfo() {
        const message = this.getSearchResultMessage() || '';
        return React.createElement("div", { className: 'search-info' }, message);
    }
    getSearchResultMessage() {
        if (!this.searchTerm) {
            return undefined;
        }
        if (this.resultNumber === 0) {
            const isIncludesPresent = this.searchInWorkspaceOptions.include && this.searchInWorkspaceOptions.include.length > 0;
            const isExcludesPresent = this.searchInWorkspaceOptions.exclude && this.searchInWorkspaceOptions.exclude.length > 0;
            let message;
            if (isIncludesPresent && isExcludesPresent) {
                message = nls_1.nls.localizeByDefault("No results found in '{0}' excluding '{1}' - ", this.searchInWorkspaceOptions.include.toString(), this.searchInWorkspaceOptions.exclude.toString());
            }
            else if (isIncludesPresent) {
                message = nls_1.nls.localizeByDefault("No results found in '{0}' - ", this.searchInWorkspaceOptions.include.toString());
            }
            else if (isExcludesPresent) {
                message = nls_1.nls.localizeByDefault("No results found excluding '{0}' - ", this.searchInWorkspaceOptions.exclude.toString());
            }
            else {
                message = nls_1.nls.localizeByDefault('No results found') + ' - ';
            }
            // We have to trim here as vscode will always add a trailing " - " string
            return message.substring(0, message.length - 2).trim();
        }
        else {
            if (this.resultNumber === 1 && this.resultTreeWidget.fileNumber === 1) {
                return nls_1.nls.localizeByDefault('{0} result in {1} file', this.resultNumber.toString(), this.resultTreeWidget.fileNumber.toString());
            }
            else if (this.resultTreeWidget.fileNumber === 1) {
                return nls_1.nls.localizeByDefault('{0} results in {1} file', this.resultNumber.toString(), this.resultTreeWidget.fileNumber.toString());
            }
            else if (this.resultTreeWidget.fileNumber > 0) {
                return nls_1.nls.localizeByDefault('{0} results in {1} files', this.resultNumber.toString(), this.resultTreeWidget.fileNumber.toString());
            }
            else {
                // if fileNumber === 0, return undefined so that `onUpdateRequest()` would not re-render component
                return undefined;
            }
        }
    }
};
exports.SearchInWorkspaceWidget = SearchInWorkspaceWidget;
SearchInWorkspaceWidget.ID = 'search-in-workspace';
SearchInWorkspaceWidget.LABEL = nls_1.nls.localizeByDefault('Search');
tslib_1.__decorate([
    (0, inversify_1.inject)(search_in_workspace_result_tree_widget_1.SearchInWorkspaceResultTreeWidget),
    tslib_1.__metadata("design:type", search_in_workspace_result_tree_widget_1.SearchInWorkspaceResultTreeWidget)
], SearchInWorkspaceWidget.prototype, "resultTreeWidget", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], SearchInWorkspaceWidget.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(search_in_workspace_context_key_service_1.SearchInWorkspaceContextKeyService),
    tslib_1.__metadata("design:type", search_in_workspace_context_key_service_1.SearchInWorkspaceContextKeyService)
], SearchInWorkspaceWidget.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(progress_bar_factory_1.ProgressBarFactory),
    tslib_1.__metadata("design:type", Function)
], SearchInWorkspaceWidget.prototype, "progressBarFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.EditorManager),
    tslib_1.__metadata("design:type", browser_3.EditorManager)
], SearchInWorkspaceWidget.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(search_in_workspace_preferences_1.SearchInWorkspacePreferences),
    tslib_1.__metadata("design:type", Object)
], SearchInWorkspaceWidget.prototype, "searchInWorkspacePreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], SearchInWorkspaceWidget.prototype, "init", null);
exports.SearchInWorkspaceWidget = SearchInWorkspaceWidget = SearchInWorkspaceWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], SearchInWorkspaceWidget);


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/lib/common/search-in-workspace-interface.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/lib/common/search-in-workspace-interface.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017-2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchInWorkspaceServer = exports.SIW_WS_PATH = exports.SearchInWorkspaceClient = exports.SearchInWorkspaceResult = void 0;
var SearchInWorkspaceResult;
(function (SearchInWorkspaceResult) {
    /**
     * Sort search in workspace results according to file, line, character position
     * and then length.
     */
    function compare(a, b) {
        if (a.fileUri !== b.fileUri) {
            return a.fileUri < b.fileUri ? -1 : 1;
        }
        return 0;
    }
    SearchInWorkspaceResult.compare = compare;
})(SearchInWorkspaceResult || (exports.SearchInWorkspaceResult = SearchInWorkspaceResult = {}));
exports.SearchInWorkspaceClient = Symbol('SearchInWorkspaceClient');
exports.SIW_WS_PATH = '/services/search-in-workspace';
exports.SearchInWorkspaceServer = Symbol('SearchInWorkspaceServer');


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/node_modules/minimatch/lib/path.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/node_modules/minimatch/lib/path.js ***!
  \****************************************************************************************/
/***/ ((module) => {

const isWindows = typeof process === 'object' &&
  process &&
  process.platform === 'win32'
module.exports = isWindows ? { sep: '\\' } : { sep: '/' }


/***/ }),

/***/ "../../node_modules/@theia/search-in-workspace/node_modules/minimatch/minimatch.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/search-in-workspace/node_modules/minimatch/minimatch.js ***!
  \*****************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const minimatch = module.exports = (p, pattern, options = {}) => {
  assertValidPattern(pattern)

  // shortcut: comments match nothing.
  if (!options.nocomment && pattern.charAt(0) === '#') {
    return false
  }

  return new Minimatch(pattern, options).match(p)
}

module.exports = minimatch

const path = __webpack_require__(/*! ./lib/path.js */ "../../node_modules/@theia/search-in-workspace/node_modules/minimatch/lib/path.js")
minimatch.sep = path.sep

const GLOBSTAR = Symbol('globstar **')
minimatch.GLOBSTAR = GLOBSTAR
const expand = __webpack_require__(/*! brace-expansion */ "../../node_modules/brace-expansion/index.js")

const plTypes = {
  '!': { open: '(?:(?!(?:', close: '))[^/]*?)'},
  '?': { open: '(?:', close: ')?' },
  '+': { open: '(?:', close: ')+' },
  '*': { open: '(?:', close: ')*' },
  '@': { open: '(?:', close: ')' }
}

// any single thing other than /
// don't need to escape / when using new RegExp()
const qmark = '[^/]'

// * => any number of characters
const star = qmark + '*?'

// ** when dots are allowed.  Anything goes, except .. and .
// not (^ or / followed by one or two dots followed by $ or /),
// followed by anything, any number of times.
const twoStarDot = '(?:(?!(?:\\\/|^)(?:\\.{1,2})($|\\\/)).)*?'

// not a ^ or / followed by a dot,
// followed by anything, any number of times.
const twoStarNoDot = '(?:(?!(?:\\\/|^)\\.).)*?'

// "abc" -> { a:true, b:true, c:true }
const charSet = s => s.split('').reduce((set, c) => {
  set[c] = true
  return set
}, {})

// characters that need to be escaped in RegExp.
const reSpecials = charSet('().*{}+?[]^$\\!')

// characters that indicate we have to add the pattern start
const addPatternStartSet = charSet('[.(')

// normalizes slashes.
const slashSplit = /\/+/

minimatch.filter = (pattern, options = {}) =>
  (p, i, list) => minimatch(p, pattern, options)

const ext = (a, b = {}) => {
  const t = {}
  Object.keys(a).forEach(k => t[k] = a[k])
  Object.keys(b).forEach(k => t[k] = b[k])
  return t
}

minimatch.defaults = def => {
  if (!def || typeof def !== 'object' || !Object.keys(def).length) {
    return minimatch
  }

  const orig = minimatch

  const m = (p, pattern, options) => orig(p, pattern, ext(def, options))
  m.Minimatch = class Minimatch extends orig.Minimatch {
    constructor (pattern, options) {
      super(pattern, ext(def, options))
    }
  }
  m.Minimatch.defaults = options => orig.defaults(ext(def, options)).Minimatch
  m.filter = (pattern, options) => orig.filter(pattern, ext(def, options))
  m.defaults = options => orig.defaults(ext(def, options))
  m.makeRe = (pattern, options) => orig.makeRe(pattern, ext(def, options))
  m.braceExpand = (pattern, options) => orig.braceExpand(pattern, ext(def, options))
  m.match = (list, pattern, options) => orig.match(list, pattern, ext(def, options))

  return m
}





// Brace expansion:
// a{b,c}d -> abd acd
// a{b,}c -> abc ac
// a{0..3}d -> a0d a1d a2d a3d
// a{b,c{d,e}f}g -> abg acdfg acefg
// a{b,c}d{e,f}g -> abdeg acdeg abdeg abdfg
//
// Invalid sets are not expanded.
// a{2..}b -> a{2..}b
// a{b}c -> a{b}c
minimatch.braceExpand = (pattern, options) => braceExpand(pattern, options)

const braceExpand = (pattern, options = {}) => {
  assertValidPattern(pattern)

  // Thanks to Yeting Li <https://github.com/yetingli> for
  // improving this regexp to avoid a ReDOS vulnerability.
  if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
    // shortcut. no need to expand.
    return [pattern]
  }

  return expand(pattern)
}

const MAX_PATTERN_LENGTH = 1024 * 64
const assertValidPattern = pattern => {
  if (typeof pattern !== 'string') {
    throw new TypeError('invalid pattern')
  }

  if (pattern.length > MAX_PATTERN_LENGTH) {
    throw new TypeError('pattern is too long')
  }
}

// parse a component of the expanded set.
// At this point, no pattern may contain "/" in it
// so we're going to return a 2d array, where each entry is the full
// pattern, split on '/', and then turned into a regular expression.
// A regexp is made at the end which joins each array with an
// escaped /, and another full one which joins each regexp with |.
//
// Following the lead of Bash 4.1, note that "**" only has special meaning
// when it is the *only* thing in a path portion.  Otherwise, any series
// of * is equivalent to a single *.  Globstar behavior is enabled by
// default, and can be disabled by setting options.noglobstar.
const SUBPARSE = Symbol('subparse')

minimatch.makeRe = (pattern, options) =>
  new Minimatch(pattern, options || {}).makeRe()

minimatch.match = (list, pattern, options = {}) => {
  const mm = new Minimatch(pattern, options)
  list = list.filter(f => mm.match(f))
  if (mm.options.nonull && !list.length) {
    list.push(pattern)
  }
  return list
}

// replace stuff like \* with *
const globUnescape = s => s.replace(/\\(.)/g, '$1')
const charUnescape = s => s.replace(/\\([^-\]])/g, '$1')
const regExpEscape = s => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&')
const braExpEscape = s => s.replace(/[[\]\\]/g, '\\$&')

class Minimatch {
  constructor (pattern, options) {
    assertValidPattern(pattern)

    if (!options) options = {}

    this.options = options
    this.set = []
    this.pattern = pattern
    this.windowsPathsNoEscape = !!options.windowsPathsNoEscape ||
      options.allowWindowsEscape === false
    if (this.windowsPathsNoEscape) {
      this.pattern = this.pattern.replace(/\\/g, '/')
    }
    this.regexp = null
    this.negate = false
    this.comment = false
    this.empty = false
    this.partial = !!options.partial

    // make the set of regexps etc.
    this.make()
  }

  debug () {}

  make () {
    const pattern = this.pattern
    const options = this.options

    // empty patterns and comments match nothing.
    if (!options.nocomment && pattern.charAt(0) === '#') {
      this.comment = true
      return
    }
    if (!pattern) {
      this.empty = true
      return
    }

    // step 1: figure out negation, etc.
    this.parseNegate()

    // step 2: expand braces
    let set = this.globSet = this.braceExpand()

    if (options.debug) this.debug = (...args) => console.error(...args)

    this.debug(this.pattern, set)

    // step 3: now we have a set, so turn each one into a series of path-portion
    // matching patterns.
    // These will be regexps, except in the case of "**", which is
    // set to the GLOBSTAR object for globstar behavior,
    // and will not contain any / characters
    set = this.globParts = set.map(s => s.split(slashSplit))

    this.debug(this.pattern, set)

    // glob --> regexps
    set = set.map((s, si, set) => s.map(this.parse, this))

    this.debug(this.pattern, set)

    // filter out everything that didn't compile properly.
    set = set.filter(s => s.indexOf(false) === -1)

    this.debug(this.pattern, set)

    this.set = set
  }

  parseNegate () {
    if (this.options.nonegate) return

    const pattern = this.pattern
    let negate = false
    let negateOffset = 0

    for (let i = 0; i < pattern.length && pattern.charAt(i) === '!'; i++) {
      negate = !negate
      negateOffset++
    }

    if (negateOffset) this.pattern = pattern.slice(negateOffset)
    this.negate = negate
  }

  // set partial to true to test if, for example,
  // "/a/b" matches the start of "/*/b/*/d"
  // Partial means, if you run out of file before you run
  // out of pattern, then that's fine, as long as all
  // the parts match.
  matchOne (file, pattern, partial) {
    var options = this.options

    this.debug('matchOne',
      { 'this': this, file: file, pattern: pattern })

    this.debug('matchOne', file.length, pattern.length)

    for (var fi = 0,
        pi = 0,
        fl = file.length,
        pl = pattern.length
        ; (fi < fl) && (pi < pl)
        ; fi++, pi++) {
      this.debug('matchOne loop')
      var p = pattern[pi]
      var f = file[fi]

      this.debug(pattern, p, f)

      // should be impossible.
      // some invalid regexp stuff in the set.
      /* istanbul ignore if */
      if (p === false) return false

      if (p === GLOBSTAR) {
        this.debug('GLOBSTAR', [pattern, p, f])

        // "**"
        // a/**/b/**/c would match the following:
        // a/b/x/y/z/c
        // a/x/y/z/b/c
        // a/b/x/b/x/c
        // a/b/c
        // To do this, take the rest of the pattern after
        // the **, and see if it would match the file remainder.
        // If so, return success.
        // If not, the ** "swallows" a segment, and try again.
        // This is recursively awful.
        //
        // a/**/b/**/c matching a/b/x/y/z/c
        // - a matches a
        // - doublestar
        //   - matchOne(b/x/y/z/c, b/**/c)
        //     - b matches b
        //     - doublestar
        //       - matchOne(x/y/z/c, c) -> no
        //       - matchOne(y/z/c, c) -> no
        //       - matchOne(z/c, c) -> no
        //       - matchOne(c, c) yes, hit
        var fr = fi
        var pr = pi + 1
        if (pr === pl) {
          this.debug('** at the end')
          // a ** at the end will just swallow the rest.
          // We have found a match.
          // however, it will not swallow /.x, unless
          // options.dot is set.
          // . and .. are *never* matched by **, for explosively
          // exponential reasons.
          for (; fi < fl; fi++) {
            if (file[fi] === '.' || file[fi] === '..' ||
              (!options.dot && file[fi].charAt(0) === '.')) return false
          }
          return true
        }

        // ok, let's see if we can swallow whatever we can.
        while (fr < fl) {
          var swallowee = file[fr]

          this.debug('\nglobstar while', file, fr, pattern, pr, swallowee)

          // XXX remove this slice.  Just pass the start index.
          if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
            this.debug('globstar found match!', fr, fl, swallowee)
            // found a match.
            return true
          } else {
            // can't swallow "." or ".." ever.
            // can only swallow ".foo" when explicitly asked.
            if (swallowee === '.' || swallowee === '..' ||
              (!options.dot && swallowee.charAt(0) === '.')) {
              this.debug('dot detected!', file, fr, pattern, pr)
              break
            }

            // ** swallows a segment, and continue.
            this.debug('globstar swallow a segment, and continue')
            fr++
          }
        }

        // no match was found.
        // However, in partial mode, we can't say this is necessarily over.
        // If there's more *pattern* left, then
        /* istanbul ignore if */
        if (partial) {
          // ran out of file
          this.debug('\n>>> no match, partial?', file, fr, pattern, pr)
          if (fr === fl) return true
        }
        return false
      }

      // something other than **
      // non-magic patterns just have to match exactly
      // patterns with magic have been turned into regexps.
      var hit
      if (typeof p === 'string') {
        hit = f === p
        this.debug('string match', p, f, hit)
      } else {
        hit = f.match(p)
        this.debug('pattern match', p, f, hit)
      }

      if (!hit) return false
    }

    // Note: ending in / means that we'll get a final ""
    // at the end of the pattern.  This can only match a
    // corresponding "" at the end of the file.
    // If the file ends in /, then it can only match a
    // a pattern that ends in /, unless the pattern just
    // doesn't have any more for it. But, a/b/ should *not*
    // match "a/b/*", even though "" matches against the
    // [^/]*? pattern, except in partial mode, where it might
    // simply not be reached yet.
    // However, a/b/ should still satisfy a/*

    // now either we fell off the end of the pattern, or we're done.
    if (fi === fl && pi === pl) {
      // ran out of pattern and filename at the same time.
      // an exact hit!
      return true
    } else if (fi === fl) {
      // ran out of file, but still had pattern left.
      // this is ok if we're doing the match as part of
      // a glob fs traversal.
      return partial
    } else /* istanbul ignore else */ if (pi === pl) {
      // ran out of pattern, still have file left.
      // this is only acceptable if we're on the very last
      // empty segment of a file with a trailing slash.
      // a/* should match a/b/
      return (fi === fl - 1) && (file[fi] === '')
    }

    // should be unreachable.
    /* istanbul ignore next */
    throw new Error('wtf?')
  }

  braceExpand () {
    return braceExpand(this.pattern, this.options)
  }

  parse (pattern, isSub) {
    assertValidPattern(pattern)

    const options = this.options

    // shortcuts
    if (pattern === '**') {
      if (!options.noglobstar)
        return GLOBSTAR
      else
        pattern = '*'
    }
    if (pattern === '') return ''

    let re = ''
    let hasMagic = false
    let escaping = false
    // ? => one single character
    const patternListStack = []
    const negativeLists = []
    let stateChar
    let inClass = false
    let reClassStart = -1
    let classStart = -1
    let cs
    let pl
    let sp
    // . and .. never match anything that doesn't start with .,
    // even when options.dot is set.  However, if the pattern
    // starts with ., then traversal patterns can match.
    let dotTravAllowed = pattern.charAt(0) === '.'
    let dotFileAllowed = options.dot || dotTravAllowed
    const patternStart = () =>
      dotTravAllowed
        ? ''
        : dotFileAllowed
        ? '(?!(?:^|\\/)\\.{1,2}(?:$|\\/))'
        : '(?!\\.)'
    const subPatternStart = (p) =>
      p.charAt(0) === '.'
        ? ''
        : options.dot
        ? '(?!(?:^|\\/)\\.{1,2}(?:$|\\/))'
        : '(?!\\.)'


    const clearStateChar = () => {
      if (stateChar) {
        // we had some state-tracking character
        // that wasn't consumed by this pass.
        switch (stateChar) {
          case '*':
            re += star
            hasMagic = true
          break
          case '?':
            re += qmark
            hasMagic = true
          break
          default:
            re += '\\' + stateChar
          break
        }
        this.debug('clearStateChar %j %j', stateChar, re)
        stateChar = false
      }
    }

    for (let i = 0, c; (i < pattern.length) && (c = pattern.charAt(i)); i++) {
      this.debug('%s\t%s %s %j', pattern, i, re, c)

      // skip over any that are escaped.
      if (escaping) {
        /* istanbul ignore next - completely not allowed, even escaped. */
        if (c === '/') {
          return false
        }

        if (reSpecials[c]) {
          re += '\\'
        }
        re += c
        escaping = false
        continue
      }

      switch (c) {
        /* istanbul ignore next */
        case '/': {
          // Should already be path-split by now.
          return false
        }

        case '\\':
          if (inClass && pattern.charAt(i + 1) === '-') {
            re += c
            continue
          }

          clearStateChar()
          escaping = true
        continue

        // the various stateChar values
        // for the "extglob" stuff.
        case '?':
        case '*':
        case '+':
        case '@':
        case '!':
          this.debug('%s\t%s %s %j <-- stateChar', pattern, i, re, c)

          // all of those are literals inside a class, except that
          // the glob [!a] means [^a] in regexp
          if (inClass) {
            this.debug('  in class')
            if (c === '!' && i === classStart + 1) c = '^'
            re += c
            continue
          }

          // if we already have a stateChar, then it means
          // that there was something like ** or +? in there.
          // Handle the stateChar, then proceed with this one.
          this.debug('call clearStateChar %j', stateChar)
          clearStateChar()
          stateChar = c
          // if extglob is disabled, then +(asdf|foo) isn't a thing.
          // just clear the statechar *now*, rather than even diving into
          // the patternList stuff.
          if (options.noext) clearStateChar()
        continue

        case '(': {
          if (inClass) {
            re += '('
            continue
          }

          if (!stateChar) {
            re += '\\('
            continue
          }

          const plEntry = {
            type: stateChar,
            start: i - 1,
            reStart: re.length,
            open: plTypes[stateChar].open,
            close: plTypes[stateChar].close,
          }
          this.debug(this.pattern, '\t', plEntry)
          patternListStack.push(plEntry)
          // negation is (?:(?!(?:js)(?:<rest>))[^/]*)
          re += plEntry.open
          // next entry starts with a dot maybe?
          if (plEntry.start === 0 && plEntry.type !== '!') {
            dotTravAllowed = true
            re += subPatternStart(pattern.slice(i + 1))
          }
          this.debug('plType %j %j', stateChar, re)
          stateChar = false
          continue
        }

        case ')': {
          const plEntry = patternListStack[patternListStack.length - 1]
          if (inClass || !plEntry) {
            re += '\\)'
            continue
          }
          patternListStack.pop()

          // closing an extglob
          clearStateChar()
          hasMagic = true
          pl = plEntry
          // negation is (?:(?!js)[^/]*)
          // The others are (?:<pattern>)<type>
          re += pl.close
          if (pl.type === '!') {
            negativeLists.push(Object.assign(pl, { reEnd: re.length }))
          }
          continue
        }

        case '|': {
          const plEntry = patternListStack[patternListStack.length - 1]
          if (inClass || !plEntry) {
            re += '\\|'
            continue
          }

          clearStateChar()
          re += '|'
          // next subpattern can start with a dot?
          if (plEntry.start === 0 && plEntry.type !== '!') {
            dotTravAllowed = true
            re += subPatternStart(pattern.slice(i + 1))
          }
          continue
        }

        // these are mostly the same in regexp and glob
        case '[':
          // swallow any state-tracking char before the [
          clearStateChar()

          if (inClass) {
            re += '\\' + c
            continue
          }

          inClass = true
          classStart = i
          reClassStart = re.length
          re += c
        continue

        case ']':
          //  a right bracket shall lose its special
          //  meaning and represent itself in
          //  a bracket expression if it occurs
          //  first in the list.  -- POSIX.2 2.8.3.2
          if (i === classStart + 1 || !inClass) {
            re += '\\' + c
            continue
          }

          // split where the last [ was, make sure we don't have
          // an invalid re. if so, re-walk the contents of the
          // would-be class to re-translate any characters that
          // were passed through as-is
          // TODO: It would probably be faster to determine this
          // without a try/catch and a new RegExp, but it's tricky
          // to do safely.  For now, this is safe and works.
          cs = pattern.substring(classStart + 1, i)
          try {
            RegExp('[' + braExpEscape(charUnescape(cs)) + ']')
            // looks good, finish up the class.
            re += c
          } catch (er) {
            // out of order ranges in JS are errors, but in glob syntax,
            // they're just a range that matches nothing.
            re = re.substring(0, reClassStart) + '(?:$.)' // match nothing ever
          }
          hasMagic = true
          inClass = false
        continue

        default:
          // swallow any state char that wasn't consumed
          clearStateChar()

          if (reSpecials[c] && !(c === '^' && inClass)) {
            re += '\\'
          }

          re += c
          break

      } // switch
    } // for

    // handle the case where we left a class open.
    // "[abc" is valid, equivalent to "\[abc"
    if (inClass) {
      // split where the last [ was, and escape it
      // this is a huge pita.  We now have to re-walk
      // the contents of the would-be class to re-translate
      // any characters that were passed through as-is
      cs = pattern.slice(classStart + 1)
      sp = this.parse(cs, SUBPARSE)
      re = re.substring(0, reClassStart) + '\\[' + sp[0]
      hasMagic = hasMagic || sp[1]
    }

    // handle the case where we had a +( thing at the *end*
    // of the pattern.
    // each pattern list stack adds 3 chars, and we need to go through
    // and escape any | chars that were passed through as-is for the regexp.
    // Go through and escape them, taking care not to double-escape any
    // | chars that were already escaped.
    for (pl = patternListStack.pop(); pl; pl = patternListStack.pop()) {
      let tail
      tail = re.slice(pl.reStart + pl.open.length)
      this.debug('setting tail', re, pl)
      // maybe some even number of \, then maybe 1 \, followed by a |
      tail = tail.replace(/((?:\\{2}){0,64})(\\?)\|/g, (_, $1, $2) => {
        /* istanbul ignore else - should already be done */
        if (!$2) {
          // the | isn't already escaped, so escape it.
          $2 = '\\'
        }

        // need to escape all those slashes *again*, without escaping the
        // one that we need for escaping the | character.  As it works out,
        // escaping an even number of slashes can be done by simply repeating
        // it exactly after itself.  That's why this trick works.
        //
        // I am sorry that you have to see this.
        return $1 + $1 + $2 + '|'
      })

      this.debug('tail=%j\n   %s', tail, tail, pl, re)
      const t = pl.type === '*' ? star
        : pl.type === '?' ? qmark
        : '\\' + pl.type

      hasMagic = true
      re = re.slice(0, pl.reStart) + t + '\\(' + tail
    }

    // handle trailing things that only matter at the very end.
    clearStateChar()
    if (escaping) {
      // trailing \\
      re += '\\\\'
    }

    // only need to apply the nodot start if the re starts with
    // something that could conceivably capture a dot
    const addPatternStart = addPatternStartSet[re.charAt(0)]

    // Hack to work around lack of negative lookbehind in JS
    // A pattern like: *.!(x).!(y|z) needs to ensure that a name
    // like 'a.xyz.yz' doesn't match.  So, the first negative
    // lookahead, has to look ALL the way ahead, to the end of
    // the pattern.
    for (let n = negativeLists.length - 1; n > -1; n--) {
      const nl = negativeLists[n]

      const nlBefore = re.slice(0, nl.reStart)
      const nlFirst = re.slice(nl.reStart, nl.reEnd - 8)
      let nlAfter = re.slice(nl.reEnd)
      const nlLast = re.slice(nl.reEnd - 8, nl.reEnd) + nlAfter

      // Handle nested stuff like *(*.js|!(*.json)), where open parens
      // mean that we should *not* include the ) in the bit that is considered
      // "after" the negated section.
      const closeParensBefore = nlBefore.split(')').length
      const openParensBefore = nlBefore.split('(').length - closeParensBefore
      let cleanAfter = nlAfter
      for (let i = 0; i < openParensBefore; i++) {
        cleanAfter = cleanAfter.replace(/\)[+*?]?/, '')
      }
      nlAfter = cleanAfter

      const dollar = nlAfter === '' && isSub !== SUBPARSE ? '(?:$|\\/)' : ''

      re = nlBefore + nlFirst + nlAfter + dollar + nlLast
    }

    // if the re is not "" at this point, then we need to make sure
    // it doesn't match against an empty path part.
    // Otherwise a/* will match a/, which it should not.
    if (re !== '' && hasMagic) {
      re = '(?=.)' + re
    }

    if (addPatternStart) {
      re = patternStart() + re
    }

    // parsing just a piece of a larger pattern.
    if (isSub === SUBPARSE) {
      return [re, hasMagic]
    }

    // if it's nocase, and the lcase/uppercase don't match, it's magic
    if (options.nocase && !hasMagic) {
      hasMagic = pattern.toUpperCase() !== pattern.toLowerCase()
    }

    // skip the regexp for non-magical patterns
    // unescape anything in it, though, so that it'll be
    // an exact match against a file etc.
    if (!hasMagic) {
      return globUnescape(pattern)
    }

    const flags = options.nocase ? 'i' : ''
    try {
      return Object.assign(new RegExp('^' + re + '$', flags), {
        _glob: pattern,
        _src: re,
      })
    } catch (er) /* istanbul ignore next - should be impossible */ {
      // If it was an invalid regular expression, then it can't match
      // anything.  This trick looks for a character after the end of
      // the string, which is of course impossible, except in multi-line
      // mode, but it's not a /m regex.
      return new RegExp('$.')
    }
  }

  makeRe () {
    if (this.regexp || this.regexp === false) return this.regexp

    // at this point, this.set is a 2d array of partial
    // pattern strings, or "**".
    //
    // It's better to use .match().  This function shouldn't
    // be used, really, but it's pretty convenient sometimes,
    // when you just want to work with a regex.
    const set = this.set

    if (!set.length) {
      this.regexp = false
      return this.regexp
    }
    const options = this.options

    const twoStar = options.noglobstar ? star
      : options.dot ? twoStarDot
      : twoStarNoDot
    const flags = options.nocase ? 'i' : ''

    // coalesce globstars and regexpify non-globstar patterns
    // if it's the only item, then we just do one twoStar
    // if it's the first, and there are more, prepend (\/|twoStar\/)? to next
    // if it's the last, append (\/twoStar|) to previous
    // if it's in the middle, append (\/|\/twoStar\/) to previous
    // then filter out GLOBSTAR symbols
    let re = set.map(pattern => {
      pattern = pattern.map(p =>
        typeof p === 'string' ? regExpEscape(p)
        : p === GLOBSTAR ? GLOBSTAR
        : p._src
      ).reduce((set, p) => {
        if (!(set[set.length - 1] === GLOBSTAR && p === GLOBSTAR)) {
          set.push(p)
        }
        return set
      }, [])
      pattern.forEach((p, i) => {
        if (p !== GLOBSTAR || pattern[i-1] === GLOBSTAR) {
          return
        }
        if (i === 0) {
          if (pattern.length > 1) {
            pattern[i+1] = '(?:\\\/|' + twoStar + '\\\/)?' + pattern[i+1]
          } else {
            pattern[i] = twoStar
          }
        } else if (i === pattern.length - 1) {
          pattern[i-1] += '(?:\\\/|' + twoStar + ')?'
        } else {
          pattern[i-1] += '(?:\\\/|\\\/' + twoStar + '\\\/)' + pattern[i+1]
          pattern[i+1] = GLOBSTAR
        }
      })
      return pattern.filter(p => p !== GLOBSTAR).join('/')
    }).join('|')

    // must match entire pattern
    // ending in a * or ** will make it less strict.
    re = '^(?:' + re + ')$'

    // can match anything, as long as it's not this.
    if (this.negate) re = '^(?!' + re + ').*$'

    try {
      this.regexp = new RegExp(re, flags)
    } catch (ex) /* istanbul ignore next - should be impossible */ {
      this.regexp = false
    }
    return this.regexp
  }

  match (f, partial = this.partial) {
    this.debug('match', f, this.pattern)
    // short-circuit in the case of busted things.
    // comments, etc.
    if (this.comment) return false
    if (this.empty) return f === ''

    if (f === '/' && partial) return true

    const options = this.options

    // windows: need to use /, not \
    if (path.sep !== '/') {
      f = f.split(path.sep).join('/')
    }

    // treat the test path as a set of pathparts.
    f = f.split(slashSplit)
    this.debug(this.pattern, 'split', f)

    // just ONE of the pattern sets in this.set needs to match
    // in order for it to be valid.  If negating, then just one
    // match means that we have failed.
    // Either way, return on the first hit.

    const set = this.set
    this.debug(this.pattern, 'set', set)

    // Find the basename of the path by looking for the last non-empty segment
    let filename
    for (let i = f.length - 1; i >= 0; i--) {
      filename = f[i]
      if (filename) break
    }

    for (let i = 0; i < set.length; i++) {
      const pattern = set[i]
      let file = f
      if (options.matchBase && pattern.length === 1) {
        file = [filename]
      }
      const hit = this.matchOne(file, pattern, partial)
      if (hit) {
        if (options.flipNegate) return true
        return !this.negate
      }
    }

    // didn't get any hits.  this is success if it's a negative
    // pattern, failure otherwise.
    if (options.flipNegate) return false
    return this.negate
  }

  static defaults (def) {
    return minimatch.defaults(def).Minimatch
  }
}

minimatch.Minimatch = Minimatch


/***/ }),

/***/ "../../node_modules/react-textarea-autosize/dist/react-textarea-autosize.browser.development.esm.js":
/*!**********************************************************************************************************!*\
  !*** ../../node_modules/react-textarea-autosize/dist/react-textarea-autosize.browser.development.esm.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ index)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "../../node_modules/react-textarea-autosize/node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _babel_runtime_helpers_esm_objectWithoutPropertiesLoose__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/esm/objectWithoutPropertiesLoose */ "../../node_modules/react-textarea-autosize/node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "../../node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var use_latest__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! use-latest */ "../../node_modules/use-latest/dist/use-latest.esm.js");
/* harmony import */ var use_composed_ref__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! use-composed-ref */ "../../node_modules/use-composed-ref/dist/use-composed-ref.esm.js");






var HIDDEN_TEXTAREA_STYLE = {
  'min-height': '0',
  'max-height': 'none',
  height: '0',
  visibility: 'hidden',
  overflow: 'hidden',
  position: 'absolute',
  'z-index': '-1000',
  top: '0',
  right: '0',
  display: 'block'
};
var forceHiddenStyles = function forceHiddenStyles(node) {
  Object.keys(HIDDEN_TEXTAREA_STYLE).forEach(function (key) {
    node.style.setProperty(key, HIDDEN_TEXTAREA_STYLE[key], 'important');
  });
};
var forceHiddenStyles$1 = forceHiddenStyles;

var hiddenTextarea = null;
var getHeight = function getHeight(node, sizingData) {
  var height = node.scrollHeight;
  if (sizingData.sizingStyle.boxSizing === 'border-box') {
    // border-box: add border, since height = content + padding + border
    return height + sizingData.borderSize;
  }

  // remove padding, since height = content
  return height - sizingData.paddingSize;
};
function calculateNodeHeight(sizingData, value, minRows, maxRows) {
  if (minRows === void 0) {
    minRows = 1;
  }
  if (maxRows === void 0) {
    maxRows = Infinity;
  }
  if (!hiddenTextarea) {
    hiddenTextarea = document.createElement('textarea');
    hiddenTextarea.setAttribute('tabindex', '-1');
    hiddenTextarea.setAttribute('aria-hidden', 'true');
    forceHiddenStyles$1(hiddenTextarea);
  }
  if (hiddenTextarea.parentNode === null) {
    document.body.appendChild(hiddenTextarea);
  }
  var paddingSize = sizingData.paddingSize,
    borderSize = sizingData.borderSize,
    sizingStyle = sizingData.sizingStyle;
  var boxSizing = sizingStyle.boxSizing;
  Object.keys(sizingStyle).forEach(function (_key) {
    var key = _key;
    hiddenTextarea.style[key] = sizingStyle[key];
  });
  forceHiddenStyles$1(hiddenTextarea);
  hiddenTextarea.value = value;
  var height = getHeight(hiddenTextarea, sizingData);
  // Double set and calc due to Firefox bug: https://bugzilla.mozilla.org/show_bug.cgi?id=1795904
  hiddenTextarea.value = value;
  height = getHeight(hiddenTextarea, sizingData);

  // measure height of a textarea with a single row
  hiddenTextarea.value = 'x';
  var rowHeight = hiddenTextarea.scrollHeight - paddingSize;
  var minHeight = rowHeight * minRows;
  if (boxSizing === 'border-box') {
    minHeight = minHeight + paddingSize + borderSize;
  }
  height = Math.max(minHeight, height);
  var maxHeight = rowHeight * maxRows;
  if (boxSizing === 'border-box') {
    maxHeight = maxHeight + paddingSize + borderSize;
  }
  height = Math.min(maxHeight, height);
  return [height, rowHeight];
}

var noop = function noop() {};
var pick = function pick(props, obj) {
  return props.reduce(function (acc, prop) {
    acc[prop] = obj[prop];
    return acc;
  }, {});
};

var SIZING_STYLE = ['borderBottomWidth', 'borderLeftWidth', 'borderRightWidth', 'borderTopWidth', 'boxSizing', 'fontFamily', 'fontSize', 'fontStyle', 'fontWeight', 'letterSpacing', 'lineHeight', 'paddingBottom', 'paddingLeft', 'paddingRight', 'paddingTop',
// non-standard
'tabSize', 'textIndent',
// non-standard
'textRendering', 'textTransform', 'width', 'wordBreak', 'wordSpacing', 'scrollbarGutter'];
var isIE = !!document.documentElement.currentStyle ;
var getSizingData = function getSizingData(node) {
  var style = window.getComputedStyle(node);
  if (style === null) {
    return null;
  }
  var sizingStyle = pick(SIZING_STYLE, style);
  var boxSizing = sizingStyle.boxSizing;

  // probably node is detached from DOM, can't read computed dimensions
  if (boxSizing === '') {
    return null;
  }

  // IE (Edge has already correct behaviour) returns content width as computed width
  // so we need to add manually padding and border widths
  if (isIE && boxSizing === 'border-box') {
    sizingStyle.width = parseFloat(sizingStyle.width) + parseFloat(sizingStyle.borderRightWidth) + parseFloat(sizingStyle.borderLeftWidth) + parseFloat(sizingStyle.paddingRight) + parseFloat(sizingStyle.paddingLeft) + 'px';
  }
  var paddingSize = parseFloat(sizingStyle.paddingBottom) + parseFloat(sizingStyle.paddingTop);
  var borderSize = parseFloat(sizingStyle.borderBottomWidth) + parseFloat(sizingStyle.borderTopWidth);
  return {
    sizingStyle: sizingStyle,
    paddingSize: paddingSize,
    borderSize: borderSize
  };
};
var getSizingData$1 = getSizingData;

function useListener(target, type, listener) {
  var latestListener = (0,use_latest__WEBPACK_IMPORTED_MODULE_3__["default"])(listener);
  react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect(function () {
    var handler = function handler(ev) {
      return latestListener.current(ev);
    };
    // might happen if document.fonts is not defined, for instance
    if (!target) {
      return;
    }
    target.addEventListener(type, handler);
    return function () {
      return target.removeEventListener(type, handler);
    };
  }, []);
}
var useFormResetListener = function useFormResetListener(libRef, listener) {
  useListener(document.body, 'reset', function (ev) {
    if (libRef.current.form === ev.target) {
      listener(ev);
    }
  });
};
var useWindowResizeListener = function useWindowResizeListener(listener) {
  useListener(window, 'resize', listener);
};
var useFontsLoadedListener = function useFontsLoadedListener(listener) {
  useListener(document.fonts, 'loadingdone', listener);
};

var _excluded = ["cacheMeasurements", "maxRows", "minRows", "onChange", "onHeightChange"];
var TextareaAutosize = function TextareaAutosize(_ref, userRef) {
  var cacheMeasurements = _ref.cacheMeasurements,
    maxRows = _ref.maxRows,
    minRows = _ref.minRows,
    _ref$onChange = _ref.onChange,
    onChange = _ref$onChange === void 0 ? noop : _ref$onChange,
    _ref$onHeightChange = _ref.onHeightChange,
    onHeightChange = _ref$onHeightChange === void 0 ? noop : _ref$onHeightChange,
    props = (0,_babel_runtime_helpers_esm_objectWithoutPropertiesLoose__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, _excluded);
  if (props.style) {
    if ('maxHeight' in props.style) {
      throw new Error('Using `style.maxHeight` for <TextareaAutosize/> is not supported. Please use `maxRows`.');
    }
    if ('minHeight' in props.style) {
      throw new Error('Using `style.minHeight` for <TextareaAutosize/> is not supported. Please use `minRows`.');
    }
  }
  var isControlled = props.value !== undefined;
  var libRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(null);
  var ref = (0,use_composed_ref__WEBPACK_IMPORTED_MODULE_4__["default"])(libRef, userRef);
  var heightRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(0);
  var measurementsCacheRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef();
  var resizeTextarea = function resizeTextarea() {
    var node = libRef.current;
    var nodeSizingData = cacheMeasurements && measurementsCacheRef.current ? measurementsCacheRef.current : getSizingData$1(node);
    if (!nodeSizingData) {
      return;
    }
    measurementsCacheRef.current = nodeSizingData;
    var _calculateNodeHeight = calculateNodeHeight(nodeSizingData, node.value || node.placeholder || 'x', minRows, maxRows),
      height = _calculateNodeHeight[0],
      rowHeight = _calculateNodeHeight[1];
    if (heightRef.current !== height) {
      heightRef.current = height;
      node.style.setProperty('height', height + "px", 'important');
      onHeightChange(height, {
        rowHeight: rowHeight
      });
    }
  };
  var handleChange = function handleChange(event) {
    if (!isControlled) {
      resizeTextarea();
    }
    onChange(event);
  };
  {
    react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect(resizeTextarea);
    useFormResetListener(libRef, function () {
      if (!isControlled) {
        var currentValue = libRef.current.value;
        requestAnimationFrame(function () {
          var node = libRef.current;
          if (node && currentValue !== node.value) {
            resizeTextarea();
          }
        });
      }
    });
    useWindowResizeListener(resizeTextarea);
    useFontsLoadedListener(resizeTextarea);
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2__.createElement("textarea", (0,_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, props, {
      onChange: handleChange,
      ref: ref
    }));
  }
};
var index = /* #__PURE__ */react__WEBPACK_IMPORTED_MODULE_2__.forwardRef(TextareaAutosize);




/***/ }),

/***/ "../../node_modules/react-textarea-autosize/node_modules/@babel/runtime/helpers/esm/extends.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/react-textarea-autosize/node_modules/@babel/runtime/helpers/esm/extends.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _extends)
/* harmony export */ });
function _extends() {
  return _extends = Object.assign ? Object.assign.bind() : function (n) {
    for (var e = 1; e < arguments.length; e++) {
      var t = arguments[e];
      for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
    }
    return n;
  }, _extends.apply(null, arguments);
}


/***/ }),

/***/ "../../node_modules/react-textarea-autosize/node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js":
/*!**************************************************************************************************************************!*\
  !*** ../../node_modules/react-textarea-autosize/node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js ***!
  \**************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _objectWithoutPropertiesLoose)
/* harmony export */ });
function _objectWithoutPropertiesLoose(r, e) {
  if (null == r) return {};
  var t = {};
  for (var n in r) if ({}.hasOwnProperty.call(r, n)) {
    if (-1 !== e.indexOf(n)) continue;
    t[n] = r[n];
  }
  return t;
}


/***/ }),

/***/ "../../node_modules/use-composed-ref/dist/use-composed-ref.esm.js":
/*!************************************************************************!*\
  !*** ../../node_modules/use-composed-ref/dist/use-composed-ref.esm.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useComposedRef)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../../node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


// basically Exclude<React.ClassAttributes<T>["ref"], string>

var updateRef = function updateRef(ref, value) {
  if (typeof ref === 'function') {
    ref(value);
    return;
  }
  ref.current = value;
};
var useComposedRef = function useComposedRef(libRef, userRef) {
  var prevUserRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef();
  return react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(function (instance) {
    libRef.current = instance;
    if (prevUserRef.current) {
      updateRef(prevUserRef.current, null);
    }
    prevUserRef.current = userRef;
    if (!userRef) {
      return;
    }
    updateRef(userRef, instance);
  }, [userRef]);
};




/***/ }),

/***/ "../../node_modules/use-isomorphic-layout-effect/dist/use-isomorphic-layout-effect.browser.esm.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/use-isomorphic-layout-effect/dist/use-isomorphic-layout-effect.browser.esm.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ index)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../../node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var index = react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect ;




/***/ }),

/***/ "../../node_modules/use-latest/dist/use-latest.esm.js":
/*!************************************************************!*\
  !*** ../../node_modules/use-latest/dist/use-latest.esm.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useLatest)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../../node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var use_isomorphic_layout_effect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! use-isomorphic-layout-effect */ "../../node_modules/use-isomorphic-layout-effect/dist/use-isomorphic-layout-effect.browser.esm.js");



var useLatest = function useLatest(value) {
  var ref = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(value);
  (0,use_isomorphic_layout_effect__WEBPACK_IMPORTED_MODULE_1__["default"])(function () {
    ref.current = value;
  });
  return ref;
};




/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_search-in-workspace_lib_browser_search-in-workspace-factory_js.js.map