/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.ui.internal.preferences;

import java.io.File;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AndroidPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.thym.android.ui.AndroidPreferencePages";

    public AndroidPreferencePage() {
        super(1);
        this.setPreferenceStore(HybridUI.getDefault().getPreferenceStore());
        this.setDescription("Android settings for Hybrid Mobile Application development");
    }

    public void createFieldEditors() {
        AndroidSDKDirectoryFieldEditor editor = new AndroidSDKDirectoryFieldEditor("Android_SDK_Loc", "Android SDK Directory:", this.getFieldEditorParent());
        this.addField((FieldEditor)editor);
    }

    public void init(IWorkbench workbench) {
    }

    private static class AndroidSDKDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public AndroidSDKDirectoryFieldEditor(String prefAndroidSdkLocation, String string, Composite fieldEditorParent) {
            super(prefAndroidSdkLocation, string, fieldEditorParent);
            this.setEmptyStringAllowed(true);
        }

        protected boolean doCheckState() {
            File file;
            String filename = this.getTextControl().getText();
            if ((filename = filename.trim()).isEmpty()) {
                this.getPage().setMessage("A location for the Android SDK must be specified", 2);
                return true;
            }
            this.getPage().setMessage(null);
            if (!filename.endsWith(File.separator)) {
                filename = String.valueOf(filename) + File.separator;
            }
            if (!(file = new File(filename)).isDirectory()) {
                this.setErrorMessage("A directory must be specified");
                return false;
            }
            File toolsFolder = new File(file, "tools");
            File platformToolsFolder = new File(file, "platform-tools");
            if (!toolsFolder.isDirectory() || !platformToolsFolder.isDirectory()) {
                this.setErrorMessage("Not a valid Android SDK directory");
                return false;
            }
            return true;
        }

        public void setValidateStrategy(int value) {
            super.setValidateStrategy(0);
        }
    }
}

