/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AbstractConfigObject {
    protected PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    Element itemNode;

    protected AbstractConfigObject() {
    }

    protected String getNodeAttribute(Node node, String namespace, String name) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        NamedNodeMap nodeMap = node.getAttributes();
        if (nodeMap == null) {
            return null;
        }
        Node attribute = nodeMap.getNamedItemNS(namespace, name);
        if (attribute != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    protected String getTextContentForTag(Node node, String name) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        Element el = (Element)node;
        NodeList nodes = el.getElementsByTagName(name);
        if (nodes.getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return null;
    }

    protected boolean equalField(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one != null && two != null) {
            return one.equals(two);
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void setTextContentValue(Element element, String value) {
        if (element == null) {
            throw new IllegalArgumentException("Element is null");
        }
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                element.removeChild(child);
            }
            child = child.getNextSibling();
        }
        Text textNode = element.getOwnerDocument().createTextNode(value);
        element.appendChild(textNode);
    }

    protected void setTextContentValueForTag(Element element, String namespace, String tagName, String value) {
        if (element == null) {
            throw new IllegalArgumentException("Element is null");
        }
        NodeList nodes = null;
        nodes = namespace == null ? element.getElementsByTagName(tagName) : element.getElementsByTagNameNS(namespace, tagName);
        Node target = null;
        if (nodes.getLength() < 1) {
            target = element.getOwnerDocument().createElementNS(namespace, tagName);
            element.appendChild(target);
        } else {
            target = nodes.item(0);
        }
        Node firstChild = target.getFirstChild();
        if (firstChild != null) {
            firstChild.setNodeValue(value);
        } else {
            target.appendChild(element.getOwnerDocument().createTextNode(value));
        }
    }

    protected void setAttributeValue(Element element, String namespace, String attributeName, String value) {
        if (element == null) {
            throw new IllegalArgumentException("null Element");
        }
        element.setAttributeNS(namespace, attributeName, value);
    }

    public class Property<T> {
        public final String name;
        private T value;

        public Property(String propertyName) {
            this.name = propertyName;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            T old = this.value;
            this.value = value;
            if (AbstractConfigObject.this.propertySupport != null) {
                AbstractConfigObject.this.propertySupport.firePropertyChange(this.name, old, this.value);
            }
        }
    }
}

