/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.engine.PlatformLibrary;

public class HybridMobileEngine {
    private String id;
    private String name;
    private String version;
    private ArrayList<PlatformLibrary> platforms = new ArrayList();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addPlatformLib(PlatformLibrary platform) {
        if (!this.platforms.contains(platform)) {
            this.platforms.add(platform);
        }
    }

    public List<PlatformLibrary> getPlatformLibs() {
        return Collections.unmodifiableList(this.platforms);
    }

    public PlatformLibrary getPlatformLib(String id) {
        List<PlatformLibrary> pls = this.getPlatformLibs();
        for (PlatformLibrary thePlatform : pls) {
            if (!thePlatform.getPlatformId().equals(id)) continue;
            return thePlatform;
        }
        return null;
    }

    public IStatus isLibraryConsistent() {
        List<PlatformLibrary> pls = this.getPlatformLibs();
        MultiStatus status = new MultiStatus("org.eclipse.thym.core", 0, "The library can not support this application", null);
        for (PlatformLibrary thePlatform : pls) {
            status.add(thePlatform.getPlatformLibraryResolver().isLibraryConsistent());
        }
        return status;
    }

    public void preCompile(IProgressMonitor monitor) throws CoreException {
        List<PlatformLibrary> pls = this.getPlatformLibs();
        for (PlatformLibrary thePlatform : pls) {
            HybridMobileLibraryResolver resolver = thePlatform.getPlatformLibraryResolver();
            if (!resolver.needsPreCompilation()) continue;
            resolver.preCompile(monitor);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HybridMobileEngine)) {
            return false;
        }
        HybridMobileEngine that = (HybridMobileEngine)obj;
        if (this.getId().equals(that.getId()) && this.getVersion().equals(that.getVersion())) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getId() != null && this.getVersion() != null) {
            return this.getId().hashCode() + this.getVersion().hashCode();
        }
        return super.hashCode();
    }
}

