/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.PlatformLibrary;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.internal.util.ConfigJSon;

public class HybridMobileEngineManager {
    private final HybridProject project;

    public HybridMobileEngineManager(HybridProject project) {
        this.project = project;
    }

    public HybridMobileEngine getActiveEngine() {
        try {
            ConfigJSon configJson = ConfigJSon.readConfigJson(this.project.getProject());
            if (configJson == null || configJson.getEngineId() == null) {
                HybridCore.log(2, "No engine information on the config.json, this is OK if using an old project. Falling back to default engine.", null);
                return this.defaultEngine();
            }
            if ("cordova".equals(configJson.getEngineId()) || "custom_cordova".equals(configJson.getEngineId())) {
                CordovaEngineProvider engineProvider = new CordovaEngineProvider();
                HybridMobileEngine engine = engineProvider.getEngine(configJson.getEngineId(), configJson.getEngineVersion());
                return engine;
            }
        }
        catch (CoreException e) {
            HybridCore.log(2, "No existing engines can be created", e);
        }
        HybridCore.log(2, "Could not determine the engine used, falling back to default engine", null);
        return this.defaultEngine();
    }

    private HybridMobileEngine defaultEngine() {
        HybridMobileEngine engine = HybridMobileEngineManager.getDefaultEngine();
        if (engine == null) {
            CordovaEngineProvider engineProvider = new CordovaEngineProvider();
            engine = engineProvider.createEngine("cordova", "3.1.0", new PlatformLibrary[0]);
        }
        return engine;
    }

    public static HybridMobileEngine getDefaultEngine() {
        CordovaEngineProvider engineProvider = new CordovaEngineProvider();
        String pref = Platform.getPreferencesService().getString("org.eclipse.thym.ui", "default_engine", null, null);
        if (pref != null && !pref.isEmpty()) {
            String[] valuePair = pref.split(":");
            List<HybridMobileEngine> engines = engineProvider.getAvailableEngines();
            for (HybridMobileEngine engine : engines) {
                if (!engine.getId().equals(valuePair[0]) || !engine.getVersion().equals(valuePair[1])) continue;
                return engine;
            }
        }
        return null;
    }

    public void updateEngine(HybridMobileEngine engine) throws CoreException {
        ConfigJSon configJSon = ConfigJSon.readConfigJson(this.project.getProject());
        if (configJSon == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "config.json does not exist or can not be parsed. Updating the hybrid mobile engine for the project " + this.project.getProject().getName() + " failed."));
        }
        configJSon.setEngineInfo(engine);
        configJSon.persist(this.project.getProject());
    }
}

