/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.extensions.PlatformSupport;

public class PlatformLibrary {
    private final String platformId;
    private final IPath location;
    private HybridMobileLibraryResolver resolver;

    public PlatformLibrary(String platformId, IPath location) {
        Assert.isNotNull((Object)platformId);
        Assert.isNotNull((Object)location);
        this.platformId = platformId;
        this.location = location;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public IPath getLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PlatformLibrary) {
            PlatformLibrary that = (PlatformLibrary)obj;
            return this.platformId.equals(that.getPlatformId()) && this.location.equals((Object)that.getLocation());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public HybridMobileLibraryResolver getPlatformLibraryResolver() {
        Assert.isNotNull((Object)this.platformId);
        if (this.resolver == null) {
            PlatformSupport platform = HybridCore.getPlatformSupport(this.platformId);
            if (platform == null) {
                return null;
            }
            try {
                this.resolver = platform.getLibraryResolver();
                this.resolver.init(this.location);
            }
            catch (CoreException e) {
                HybridCore.log(4, "Library resolver creation error ", e);
                return null;
            }
        }
        return this.resolver;
    }
}

