/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.util;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.HybridMobileEngine;

public class ConfigJSon {
    private String id;
    private String name;
    private Engine engine;

    public void persist(IProject project) throws CoreException {
        block18: {
            IFolder folder = project.getFolder(".cordova");
            if (folder != null && folder.exists()) {
                Gson gson = new Gson();
                String json = gson.toJson((Object)this);
                IFile file = folder.getFile("config.json");
                InputStream stream = null;
                try {
                    try {
                        stream = new ByteArrayInputStream(json.getBytes("utf-8"));
                        if (file.exists()) {
                            file.setContents(stream, 0, (IProgressMonitor)new NullProgressMonitor());
                        } else {
                            file.create(stream, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        HybridCore.log(4, "Error while persisting config.json", e);
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", ".cordova does not exist on project " + project.getName()));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEngineId() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.id;
    }

    public String getEngineVersion() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.ver;
    }

    public void setEngineInfo(HybridMobileEngine hybridMobileEngine) {
        if (hybridMobileEngine == null) {
            this.engine = null;
        } else {
            this.engine = new Engine();
            this.engine.id = hybridMobileEngine.getId();
            this.engine.ver = hybridMobileEngine.getVersion();
        }
    }

    public static ConfigJSon readConfigJson(IProject project) throws CoreException {
        IFolder folder = project.getProject().getFolder(".cordova");
        if (!folder.exists()) {
            HybridCore.log(2, ".cordova folder is missing", null);
            return new ConfigJSon();
        }
        IFile file = folder.getFile("config.json");
        Gson gson = new Gson();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(file.getContents()));
        return (ConfigJSon)gson.fromJson(reader, ConfigJSon.class);
    }

    public class Engine {
        private String id;
        private String ver;
    }
}

