/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin;

import com.github.zafarkhaja.semver.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.PlatformLibrary;
import org.eclipse.thym.core.plugin.PluginJavaScriptModule;

public class CordovaPlugin
extends PlatformObject {
    private String id;
    private String version;
    private String name;
    private String description;
    private String license;
    private String author;
    private String keywords;
    private List<EngineDefinition> supportedEngines;
    private String info;
    private List<PluginJavaScriptModule> modules;
    private IFolder folder;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void addSupportedEngine(String name, String version, String platform) {
        if (this.supportedEngines == null) {
            this.supportedEngines = new ArrayList<EngineDefinition>();
        }
        EngineDefinition engine = new EngineDefinition();
        engine.name = name;
        engine.version = version;
        engine.platform = platform;
        this.supportedEngines.add(engine);
    }

    public List<PluginJavaScriptModule> getModules() {
        if (this.modules == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.modules);
    }

    public void addModule(PluginJavaScriptModule module) {
        if (this.modules == null) {
            this.modules = new ArrayList<PluginJavaScriptModule>();
        }
        this.modules.add(module);
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public IFolder getFolder() {
        return this.folder;
    }

    public void setFolder(IFolder adapter) {
        this.folder = adapter;
    }

    public IStatus isEngineCompatible(HybridMobileEngine engine) {
        if (this.supportedEngines == null || this.supportedEngines.isEmpty()) {
            return Status.OK_STATUS;
        }
        MultiStatus status = new MultiStatus("org.eclipse.thym.core", 0, NLS.bind((String)"Plug-in {0} is not compatible with {1} version {2}", (Object[])new Object[]{this.getLabel(), engine.getName(), engine.getVersion()}), null);
        for (EngineDefinition definition : this.supportedEngines) {
            status.add(this.isDefinitionSatisfied(definition, engine));
        }
        return status;
    }

    private IStatus isDefinitionSatisfied(EngineDefinition definition, HybridMobileEngine engine) {
        String reason;
        if (engine.getId().equals(definition.name)) {
            Version engineVer = Version.valueOf((String)engine.getVersion());
            if (engineVer.satisfies(definition.version)) {
                List<PlatformLibrary> enginePlatforms = engine.getPlatformLibs();
                for (PlatformLibrary ep : enginePlatforms) {
                    if (definition.platform != null && !"*".equals(definition.platform) && !definition.platform.contains(ep.getPlatformId())) continue;
                    return Status.OK_STATUS;
                }
                reason = "engine platform: " + definition.platform;
            } else {
                reason = "engine version: " + definition.version;
            }
        } else {
            reason = "engine id: " + definition.name;
        }
        return new Status(2, "org.eclipse.thym.core", NLS.bind((String)"Plug-in {0} does not support {1} version {2}. Fails version requirement: {3}", (Object[])new Object[]{this.getLabel(), engine.getName(), engine.getVersion(), reason}));
    }

    public String getLabel() {
        return this.getName() != null ? this.getName() : this.getId();
    }

    public String toString() {
        if (this.getId() == null) {
            return super.toString();
        }
        return String.valueOf(this.getId()) + (this.getVersion() == null ? "" : "(" + this.getVersion() + ")");
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CordovaPlugin) {
            CordovaPlugin that = (CordovaPlugin)((Object)obj);
            return this.getId().equals(that.getId());
        }
        return super.equals(obj);
    }

    private class EngineDefinition {
        String name;
        String version;
        String platform;

        private EngineDefinition() {
        }
    }
}

