/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.actions;

import java.io.File;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.internal.util.XMLUtil;
import org.eclipse.thym.core.platform.IPluginInstallationAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigFileAction
implements IPluginInstallationAction {
    protected final File target;
    protected final String parent;
    protected final String xml;
    private XPathExpression xpathExpression;

    public XMLConfigFileAction(File target, String parent, String xml) {
        this.target = target;
        this.parent = parent;
        this.xml = xml;
    }

    @Override
    public void install() throws CoreException {
        Document doc = XMLUtil.loadXML(this.target, false);
        Document newNode = XMLUtil.loadXML(this.xml);
        Node node = this.getParentNode(doc.getDocumentElement());
        if (node == null) {
            this.handleParentNodeException();
            return;
        }
        NodeList childNodes = newNode.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node importedNode = doc.importNode(childNodes.item(i), true);
            node.appendChild(importedNode);
            ++i;
        }
        XMLUtil.saveXML(this.target, doc);
    }

    @Override
    public void unInstall() throws CoreException {
        Document doc = XMLUtil.loadXML(this.target, false);
        Document node = XMLUtil.loadXML(this.xml);
        Node parentNode = this.getParentNode(doc.getDocumentElement());
        if (parentNode == null) {
            this.handleParentNodeException();
            return;
        }
        NodeList childNodes = node.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node importedNode = doc.importNode(childNodes.item(i), true);
            NodeList children = parentNode.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node item = children.item(j);
                if (item.isEqualNode(importedNode)) {
                    parentNode.removeChild(item);
                    break;
                }
                ++j;
            }
            ++i;
        }
        XMLUtil.saveXML(this.target, doc);
    }

    private void handleParentNodeException() throws CoreException {
        HybridCore.log(4, NLS.bind((String)"Parent node could not be retrieved on {0} with expression {1}", (Object[])new String[]{this.target.getName(), this.parent}), null);
    }

    private XPathExpression getXPathExpression() throws XPathExpressionException {
        if (this.xpathExpression == null) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            this.xpathExpression = xpath.compile(this.parent);
        }
        return this.xpathExpression;
    }

    protected Node getParentNode(Element root) throws CoreException {
        try {
            return (Node)this.getXPathExpression().evaluate(root, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"Parent node could not be retrieved on {0} with expression {1}", (Object[])new String[]{this.target.getName(), this.parent}), (Throwable)e));
        }
    }

    @Override
    public String[] filesToOverwrite() {
        return new String[0];
    }
}

