/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.registry;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.thym.core.internal.util.FileUtils;
import org.eclipse.thym.core.internal.util.TarException;

public class PluginReceiver
implements IFileTransferListener {
    private final File cacheDirectory;
    private final Object lock;
    private final IProgressMonitor monitor;
    private int percentComplete;

    public PluginReceiver(File directory, IProgressMonitor monitor, Object lock) {
        this.cacheDirectory = directory;
        this.lock = lock;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTransferEvent(IFileTransferEvent event) {
        block28: {
            File tarFile = new File(this.cacheDirectory, "package.tgz");
            if (event instanceof IIncomingFileTransferReceiveStartEvent) {
                IIncomingFileTransferReceiveStartEvent startEvent = (IIncomingFileTransferReceiveStartEvent)event;
                try {
                    if (!this.cacheDirectory.exists()) {
                        this.cacheDirectory.mkdirs();
                    }
                    startEvent.receive(tarFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (event instanceof IIncomingFileTransferReceiveDataEvent) {
                int completed;
                IIncomingFileTransferReceiveDataEvent dataEvent = (IIncomingFileTransferReceiveDataEvent)event;
                this.percentComplete = completed = (int)(dataEvent.getSource().getPercentComplete() * 100.0);
            } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
                try {
                    IIncomingFileTransferReceiveDoneEvent doneEvent = (IIncomingFileTransferReceiveDoneEvent)event;
                    Exception ex = doneEvent.getException();
                    if (ex == null) {
                        FileUtils.untarFile(tarFile, this.cacheDirectory);
                    } else {
                        ex.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.notifyAll();
                        break block28;
                    }
                }
                catch (TarException e) {
                    Object object;
                    try {
                        e.printStackTrace();
                        object = this.lock;
                    }
                    catch (Throwable throwable) {
                        Object object2 = this.lock;
                        synchronized (object2) {
                            this.lock.notifyAll();
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        this.lock.notifyAll();
                        break block28;
                    }
                }
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
        }
    }
}

