/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.xcode;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.internal.util.ExternalProcessUtility;
import org.eclipse.thym.core.internal.util.TextDetectingStreamListener;
import org.eclipse.thym.core.platform.AbstractNativeBinaryBuildDelegate;
import org.eclipse.thym.ios.core.simulator.IOSDevice;
import org.eclipse.thym.ios.core.simulator.IOSSimulator;
import org.eclipse.thym.ios.core.xcode.XCodeSDK;
import org.eclipse.thym.ios.core.xcode.XcodeProjectGenerator;

public class XCodeBuild
extends AbstractNativeBinaryBuildDelegate {
    public static final String MIN_REQUIRED_VERSION = "6.0.0";
    private ILaunchConfiguration launchConfiguration;

    public static File getBuildDir(File xcodeProjectFolder) {
        return new File(xcodeProjectFolder, "build");
    }

    public List<XCodeSDK> showSdks() throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        SDKListParser parser = new SDKListParser();
        processUtility.execSync("xcodebuild -showsdks ", null, (IStreamListener)parser, (IStreamListener)parser, (IProgressMonitor)new NullProgressMonitor(), null, null);
        return parser.getSDKList();
    }

    public String version() throws CoreException {
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        XCodeVersionParser parser = new XCodeVersionParser();
        processUtility.execSync("xcodebuild -version", null, (IStreamListener)parser, (IStreamListener)parser, (IProgressMonitor)new NullProgressMonitor(), null, null);
        return parser.getVersion();
    }

    public void buildNow(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.beginTask("Build Cordova project for iOS", 10);
            XcodeProjectGenerator creator = new XcodeProjectGenerator(this.getProject(), null, "ios");
            SubProgressMonitor generateMonitor = new SubProgressMonitor(monitor, 1);
            File xcodeProjectDir = creator.generateNow((IProgressMonitor)generateMonitor);
            monitor.worked(4);
            if (monitor.isCanceled()) {
                return;
            }
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
            if (hybridProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Not a hybrid mobile project, can not generate files"));
            }
            String name = hybridProject.getBuildArtifactAppName();
            StringBuilder cmdString = new StringBuilder("xcodebuild -project ");
            cmdString.append("\"").append(name).append(".xcodeproj").append("\"");
            cmdString.append(" -target ").append(name);
            cmdString.append(" -configuration Release ");
            cmdString.append(" -sdk ").append(this.selectSDK());
            cmdString.append(" clean build ");
            cmdString.append("VALID_ARCHS=\"i386 armv6 armv7\"");
            cmdString.append(" CONFIGURATION_BUILD_DIR=").append("\"").append(XCodeBuild.getBuildDir(xcodeProjectDir).getPath()).append("\"");
            if (this.isRelease()) {
                cmdString.append(" CODE_SIGN_IDENTITY=\"\" CODE_SIGNING_REQUIRED=NO");
            }
            ExternalProcessUtility processUtility = new ExternalProcessUtility();
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            TextDetectingStreamListener listener = new TextDetectingStreamListener("** BUILD SUCCEEDED **");
            processUtility.execSync(cmdString.toString(), xcodeProjectDir, (IStreamListener)listener, (IStreamListener)listener, monitor, null, this.getLaunchConfiguration());
            if (!listener.isTextDetected()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "xcodebuild has failed"));
            }
            this.setBuildArtifact(new File(XCodeBuild.getBuildDir(xcodeProjectDir), String.valueOf(name) + ".app"));
            if (!this.getBuildArtifact().exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "xcodebuild has failed: build artifact does not exist"));
            }
        }
        finally {
            monitor.done();
        }
    }

    private Object selectSDK() {
        if (this.isRelease()) {
            XCodeSDK releaseSDK = this.findLatestSDK(false);
            if (releaseSDK != null) {
                return releaseSDK.getIdentifierString();
            }
            return "iphoneos8.0";
        }
        String launchConfigDeviceId = null;
        try {
            if (this.getLaunchConfiguration() != null) {
                launchConfigDeviceId = this.getLaunchConfiguration().getAttribute("org.eclipse.thym.ios.core.ATTR_DEVICE_IDENTIFIER", null);
            }
            IOSDevice device = IOSSimulator.findDevice(launchConfigDeviceId, (IProgressMonitor)new NullProgressMonitor());
            List<XCodeSDK> sdks = this.showSdks();
            for (XCodeSDK sdk : sdks) {
                if (device == null || !device.getiOSName().equals(sdk.getDescription()) || !sdk.isSimulator()) continue;
                return sdk.getIdentifierString();
            }
            XCodeSDK fallbackSDK = this.findLatestSDK(true);
            if (fallbackSDK != null) {
                return fallbackSDK.getIdentifierString();
            }
        }
        catch (CoreException coreException) {}
        return "iphonesimulator8.0";
    }

    private XCodeSDK findLatestSDK(boolean isSimulator) {
        List<XCodeSDK> sdks;
        block5: {
            sdks = this.showSdks();
            if (sdks != null && !sdks.isEmpty()) break block5;
            return null;
        }
        try {
            XCodeSDK latestSDK = null;
            for (XCodeSDK sdk : sdks) {
                if (!sdk.isIOS() || sdk.isSimulator() != isSimulator) continue;
                if (latestSDK == null) {
                    latestSDK = sdk;
                }
                double sdkver = Double.parseDouble(sdk.getVersion());
                double latestVer = Double.parseDouble(latestSDK.getVersion());
                if (!(latestVer < sdkver)) continue;
                latestSDK = sdk;
            }
            return latestSDK;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }

    private class SDKListParser
    implements IStreamListener {
        private StringBuffer buffer = new StringBuffer();

        private SDKListParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        ArrayList<XCodeSDK> getSDKList() {
            ArrayList<XCodeSDK> sdkList = new ArrayList<XCodeSDK>(5);
            if (this.buffer.indexOf("-sdk") > 0) {
                String[] sdks;
                String text = this.buffer.toString();
                text = text.replaceAll("[ a-zA-Z1-9.1-9]*:", "");
                text = text.replaceAll("-sdk [a-z]*[0-9]*.[0-9]*", "");
                String[] stringArray = sdks = text.split("\n");
                int n = sdks.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String clean = string.trim();
                    if (!clean.isEmpty()) {
                        sdkList.add(new XCodeSDK(clean));
                    }
                    ++n2;
                }
            }
            return sdkList;
        }
    }

    private class XCodeVersionParser
    implements IStreamListener {
        private StringBuffer buffer = new StringBuffer();

        private XCodeVersionParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        public String getVersion() {
            return this.buffer.substring("XCode".length() + 1, this.buffer.indexOf("\n"));
        }
    }
}

