/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.xcode;

import com.dd.plist.ASCIIPropertyListParser;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.platform.AbstractProjectGeneratorDelegate;
import org.eclipse.thym.ios.core.xcode.XCodeProjectUtils;

public class XcodeProjectGenerator
extends AbstractProjectGeneratorDelegate {
    public XcodeProjectGenerator() {
    }

    public XcodeProjectGenerator(IProject project, File generationFolder, String platform) {
        this.init(project, generationFolder, platform);
    }

    protected void generateNativeFiles(HybridMobileLibraryResolver resolver) throws CoreException {
        try {
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
            if (hybridProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Not a hybrid mobile project, can not generate files"));
            }
            File destinationDir = this.getDestination();
            Path destinationPath = new Path(destinationDir.toString());
            String name = hybridProject.getBuildArtifactAppName();
            IPath prjPath = destinationPath.append(name);
            Widget widgetModel = WidgetModel.getModel((HybridProject)hybridProject).getWidgetForRead();
            String packageName = widgetModel.getId();
            File prjdir = prjPath.toFile();
            if (!prjdir.exists()) {
                prjdir.mkdirs();
            }
            org.eclipse.thym.core.internal.util.FileUtils.directoryCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)prjdir));
            FileUtils.deleteQuietly((File)new File(prjdir, "__PROJECT_NAME__-Info.plist"));
            FileUtils.deleteQuietly((File)new File(prjdir, "__PROJECT_NAME__-Prefix.pch"));
            IPath cordovaScriptPath = destinationPath.append("cordova");
            org.eclipse.thym.core.internal.util.FileUtils.directoryCopy((URL)resolver.getTemplateFile(cordovaScriptPath.makeRelativeTo((IPath)destinationPath)), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)cordovaScriptPath.toFile()));
            File wwwwCopyScript = cordovaScriptPath.append("lib").append("copy-www-build-step.sh").toFile();
            if (wwwwCopyScript.exists()) {
                wwwwCopyScript.setExecutable(true);
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("__TESTING__", name);
            values.put("__PROJECT_NAME__", name);
            values.put("--ID--", packageName);
            IPath templatePath = prjPath.append(String.valueOf(name) + "-Info.plist");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/$appname-Info.plist")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            templatePath = prjPath.append(String.valueOf(name) + "-Prefix.pch");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/$appname-Prefix.pch")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            IPath xcodeprojDirPath = destinationPath.append(String.valueOf(name) + ".xcodeproj");
            File xcodeDir = xcodeprojDirPath.toFile();
            if (!xcodeDir.exists()) {
                xcodeDir.mkdir();
            }
            IPath xcodeprojectFilePath = xcodeprojDirPath.append("project.pbxproj");
            File xcodeprojectFile = xcodeprojectFilePath.toFile();
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname.xcodeproj/project.pbxproj")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)xcodeprojectFile), values);
            IPath classesPath = prjPath.append("Classes");
            templatePath = classesPath.append("AppDelegate.h");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/Classes/AppDelegate.h")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            templatePath = classesPath.append("AppDelegate.m");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/Classes/AppDelegate.m")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            templatePath = classesPath.append("MainViewController.h");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/Classes/MainViewController.h")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            templatePath = classesPath.append("MainViewController.m");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/Classes/MainViewController.m")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            templatePath = prjPath.append("main.m");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/main.m")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            IPath cordovaLibDirectory = this.getCordovaLibPath();
            org.eclipse.thym.core.internal.util.FileUtils.directoryCopy((URL)resolver.getTemplateFile((IPath)new Path("CordovaLib")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)cordovaLibDirectory.toFile()));
            this.updateCordovaSubProjectPath(xcodeprojectFile, "CordovaLib/CordovaLib.xcodeproj", "<group>");
            File configxml = hybridProject.getConfigFile().getLocation().toFile();
            org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)configxml), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)new File(prjdir, "/config.xml")));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error generating the native iOS project", (Throwable)e));
        }
    }

    private void updateCordovaSubProjectPath(File pbxprojfile, String path, String sourcetree) throws CoreException {
        try {
            NSDictionary dict = (NSDictionary)ASCIIPropertyListParser.parse((File)pbxprojfile);
            NSDictionary objects = (NSDictionary)dict.objectForKey("objects");
            HashMap hashmap = objects.getHashMap();
            Collection values = hashmap.values();
            for (NSObject nsObject : values) {
                NSDictionary obj = (NSDictionary)nsObject;
                NSString isa = (NSString)obj.objectForKey("isa");
                NSString pathObj = (NSString)obj.objectForKey("path");
                if (isa == null || !isa.getContent().equals("PBXFileReference") || path == null || !pathObj.getContent().contains("CordovaLib.xcodeproj")) continue;
                obj.remove("path");
                obj.put("path", path);
                obj.remove("sourceTree");
                obj.put("sourceTree", sourcetree);
                if (!obj.containsKey("name")) {
                    obj.put("name", "CordovaLib.xcodeproj");
                }
                PropertyListParser.saveAsASCII((NSDictionary)dict, (File)pbxprojfile);
                break;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error updating CordovaLib subproject", (Throwable)e));
        }
    }

    private IPath getCordovaLibPath() {
        return new Path(this.getDestination().toString()).append("CordovaLib");
    }

    protected void replaceCordovaPlatformFiles(HybridMobileLibraryResolver resolver) throws IOException {
        org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)resolver.getTemplateFile(HybridMobileLibraryResolver.PATH_CORDOVA_JS), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)new File(this.getPlatformWWWDirectory(), "cordova.js")));
    }

    protected File getPlatformWWWDirectory() {
        return XCodeProjectUtils.getPlatformWWWDirectory(this.getDestination());
    }
}

