/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.engine;

import com.github.zafarkhaja.semver.Version;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.projectGenerator.ProjectGeneratorContentProvider;
import org.eclipse.thym.ui.internal.projectGenerator.ProjectGeneratorLabelProvider;
import org.eclipse.thym.ui.internal.status.StatusManager;

public class EngineDownloadDialog
extends TitleAreaDialog {
    private static final int TABLE_WIDTH = 350;
    private static final int TABLE_HEIGHT = 100;
    private ComboViewer versionViewer;
    private CheckboxTableViewer platformList;
    private CordovaEngineProvider engineProvider;
    private List<HybridMobileEngine> engines;
    private ProgressMonitorPart progressMonitorPart;

    public EngineDownloadDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.toggleOKButton(false);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Download Hybrid Mobile Engine");
        this.setMessage("Download a new engine version or add a platform to an existing one");
        parent.getShell().setText("Download Hybrid Mobile Engine");
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).spacing(LayoutConstants.getSpacing()).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label versionLbl = new Label(composite, 0);
        versionLbl.setText("Version:");
        Combo versionCombo = new Combo(composite, 8);
        this.versionViewer = new ComboViewer(versionCombo);
        this.versionViewer.setContentProvider((IContentProvider)new DownloadableVersionsContentProvider());
        this.versionViewer.setComparator(new ViewerComparator((Comparator)new VersionStringComparator()));
        this.versionViewer.setLabelProvider((IBaseLabelProvider)new DownloadableEngineLabelProvider());
        this.versionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                DownloadableCordovaEngine engine = (DownloadableCordovaEngine)sel.getFirstElement();
                EngineDownloadDialog.this.platformList.setInput((Object)engine.getVersion());
                EngineDownloadDialog.this.validate();
            }
        });
        Table table = new Table(composite, 67620);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).minSize(new Point(350, 100)).applyTo((Control)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableColumn col = new TableColumn(table, 0);
        col.setWidth(120);
        col.setText("Platform");
        this.platformList = new CheckboxTableViewer(table);
        this.platformList.setContentProvider((IContentProvider)new ProjectGeneratorContentProvider());
        this.platformList.setFilters(new ViewerFilter[]{new ContentProviderSupportFilter()});
        this.platformList.setLabelProvider((IBaseLabelProvider)new PlatformsLabelProvider());
        this.platformList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                EngineDownloadDialog.this.validate();
            }
        });
        this.createProgressMonitorPart(composite);
        this.engineProvider = new CordovaEngineProvider();
        try {
            this.versionViewer.setInput((Object)this.engineProvider.getDownloadableVersions());
        }
        catch (CoreException e) {
            this.setErrorMessage("Unable to retrieve the downloadable versions list, please try again later.");
            HybridUI.log(4, "Unable to retrieve the downloadable versions list", e);
        }
        return composite;
    }

    private void createProgressMonitorPart(Composite composite) {
        this.progressMonitorPart = new ProgressMonitorPart(composite, (Layout)new GridLayout());
        this.progressMonitorPart.setVisible(true);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.progressMonitorPart);
    }

    public void setVersion(String version) {
        this.versionViewer.setSelection((ISelection)new StructuredSelection((Object)version));
        this.validate();
    }

    public String getVersion() {
        IStructuredSelection sel = (IStructuredSelection)this.versionViewer.getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        DownloadableCordovaEngine engine = (DownloadableCordovaEngine)sel.getFirstElement();
        return engine.getVersion();
    }

    private boolean isInstalled(String version, String platformId) {
        if (version == null || platformId == null) {
            return false;
        }
        if (this.engines == null) {
            this.engines = this.engineProvider.getAvailableEngines();
        }
        for (HybridMobileEngine engine : this.engines) {
            if (!engine.getVersion().equals(version) || !engine.getId().equals("cordova") || engine.getPlatformLib(platformId) == null) continue;
            return true;
        }
        return false;
    }

    private void validate() {
        if (this.platformList.getElementAt(0) == null) {
            this.setErrorMessage(NLS.bind((String)"All supported platforms are already installed for {0} {1}", (Object[])new String[]{this.engineProvider.getName(), this.getVersion()}));
            this.toggleOKButton(false);
            return;
        }
        Object[] checked = this.platformList.getCheckedElements();
        if (checked == null || checked.length == 0) {
            this.toggleOKButton(false);
            return;
        }
        this.setErrorMessage(null);
        this.toggleOKButton(true);
    }

    private void toggleOKButton(boolean state) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(state);
        }
    }

    protected void okPressed() {
        Object[] checked = this.platformList.getCheckedElements();
        final String[] platforms = new String[checked.length];
        int i = 0;
        while (i < checked.length) {
            PlatformSupport gen = (PlatformSupport)checked[i];
            platforms[i] = gen.getPlatformId();
            ++i;
        }
        final String version = this.getVersion();
        this.versionViewer.getCombo().setEnabled(false);
        this.platformList.getTable().setEnabled(false);
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                EngineDownloadDialog.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Button okButton = EngineDownloadDialog.this.getButton(0);
                        okButton.setEnabled(false);
                    }
                });
                EngineDownloadDialog.this.engineProvider.downloadEngine(version, monitor, platforms);
            }
        });
        super.okPressed();
    }

    private void run(IRunnableWithProgress runnable) {
        this.progressMonitorPart.attachToCancelComponent((Control)this.getButton(1));
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.progressMonitorPart, (Display)this.getShell().getDisplay());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                if (e.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)e.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error downloading engine", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Error downloading the engine", e.getTargetException()));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        this.progressMonitorPart.removeFromCancelComponent((Control)this.getButton(1));
    }

    private class ContentProviderSupportFilter
    extends ViewerFilter {
        private ContentProviderSupportFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            PlatformSupport gen = (PlatformSupport)element;
            String version = (String)parentElement;
            return EngineDownloadDialog.this.engineProvider.isSupportedPlatform(version, gen.getPlatformId()) && !EngineDownloadDialog.this.isInstalled(version, gen.getPlatformId());
        }
    }

    private class DownloadableEngineLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private DownloadableEngineLabelProvider() {
        }

        public String getText(Object element) {
            DownloadableCordovaEngine engine = (DownloadableCordovaEngine)element;
            return engine == null ? "" : engine.getVersion();
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    private class DownloadableVersionsContentProvider
    implements IStructuredContentProvider {
        private DownloadableCordovaEngine[] versions;

        private DownloadableVersionsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                List list = (List)newInput;
                this.versions = list.toArray(new DownloadableCordovaEngine[list.size()]);
            } else {
                this.versions = null;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (this.versions == null) {
                EngineDownloadDialog.this.engineProvider = new CordovaEngineProvider();
                try {
                    List engineList = EngineDownloadDialog.this.engineProvider.getDownloadableVersions();
                    this.versions = engineList.toArray(new DownloadableCordovaEngine[engineList.size()]);
                }
                catch (CoreException e) {
                    StatusManager.handle(e);
                }
            }
            return this.versions;
        }
    }

    private class PlatformsLabelProvider
    extends ProjectGeneratorLabelProvider
    implements ITableLabelProvider {
        private PlatformsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return super.getImage(element);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return super.getText(element);
                }
            }
            return null;
        }
    }

    private class VersionStringComparator
    implements Comparator<String> {
        private VersionStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            Version version1 = Version.valueOf((String)o1);
            Version version2 = Version.valueOf((String)o2);
            return version2.compareTo(version1);
        }
    }
}

