/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.p2.ui.discovery.util.FilteredViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.util.PatternFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.util.SelectionProviderAdapter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginInfo;
import org.eclipse.thym.ui.plugins.internal.ControlListItem;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginFilter;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginInfoItem;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginWizardResources;
import org.eclipse.thym.ui.plugins.internal.InstalledPluginFilter;
import org.eclipse.thym.ui.plugins.internal.PluginControlListViewer;

public class CordovaPluginCatalogViewer
extends FilteredViewer {
    public static final int FILTER_INSTALLED = 2;
    private final SelectionProviderAdapter selectionProvider;
    private CordovaPluginWizardResources resources;
    private List<CordovaRegistryPluginInfo> selectedItems = new ArrayList<CordovaRegistryPluginInfo>();
    private HybridProject project;
    private int style;
    private InstalledPluginFilter installedPluginsFilter;
    private Button showInstalledBtn;

    public CordovaPluginCatalogViewer(int style) {
        this.style = style;
        this.selectionProvider = new SelectionProviderAdapter();
        this.setAutomaticFind(false);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.removeSelectionChangedListener(listener);
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.selectionProvider.getSelection();
    }

    void modifySelection(CordovaRegistryPluginInfo element, boolean selection) {
        if (selection && !this.selectedItems.contains(element)) {
            this.selectedItems.add(element);
            this.selectionProvider.setSelection((ISelection)new StructuredSelection(this.selectedItems));
        }
        if (!selection && this.selectedItems.contains(element)) {
            this.selectedItems.remove(element);
            this.selectionProvider.setSelection((ISelection)new StructuredSelection(this.selectedItems));
        }
    }

    protected void doCreateHeaderControls(Composite parent) {
        if ((this.style & 2) != 0) {
            this.showInstalledBtn = new Button(parent, 32);
            this.showInstalledBtn.setText("Show Installed");
            this.showInstalledBtn.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    CordovaPluginCatalogViewer.this.updateInstalledPluginsFilter();
                }
            });
        }
        this.setFilterText(" ");
    }

    protected PatternFilter doCreateFilter() {
        return new CordovaPluginFilter();
    }

    protected StructuredViewer doCreateViewer(Composite container) {
        this.resources = new CordovaPluginWizardResources(container.getDisplay());
        PluginControlListViewer viewer = new PluginControlListViewer(container, 2048){

            protected ControlListItem<CordovaRegistryPluginInfo> doCreateItem(Composite parent, Object element) {
                return CordovaPluginCatalogViewer.this.doCreateViewerItem(parent, element);
            }
        };
        CordovaPluginInfoContentProvider provider = new CordovaPluginInfoContentProvider();
        viewer.setContentProvider((IContentProvider)provider);
        viewer.setComparator(new CordovaPluginViewerComparator());
        return viewer;
    }

    private ControlListItem<CordovaRegistryPluginInfo> doCreateViewerItem(Composite parent, Object element) {
        CordovaRegistryPluginInfo pluginInfo = (CordovaRegistryPluginInfo)element;
        boolean installed = false;
        if (this.project != null) {
            installed = this.project.getPluginManager().isPluginInstalled(pluginInfo.getName());
        }
        return new CordovaPluginInfoItem(parent, pluginInfo, this.resources, this, installed);
    }

    public void applyFilter(String filterText) {
        this.setFilterText(filterText);
    }

    public HybridProject getProject() {
        return this.project;
    }

    public void setProject(HybridProject project) {
        this.project = project;
        this.updateInstalledPluginsFilter();
    }

    private void updateInstalledPluginsFilter() {
        if ((this.style & 2) == 0) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (CordovaPluginCatalogViewer.this.showInstalledBtn.getSelection()) {
                    if (CordovaPluginCatalogViewer.this.installedPluginsFilter != null) {
                        CordovaPluginCatalogViewer.this.getViewer().removeFilter((ViewerFilter)CordovaPluginCatalogViewer.this.installedPluginsFilter);
                        CordovaPluginCatalogViewer.this.installedPluginsFilter = null;
                    }
                } else if (CordovaPluginCatalogViewer.this.installedPluginsFilter == null) {
                    CordovaPluginCatalogViewer.this.installedPluginsFilter = new InstalledPluginFilter();
                    CordovaPluginCatalogViewer.this.installedPluginsFilter.setProject(CordovaPluginCatalogViewer.this.project);
                    CordovaPluginCatalogViewer.this.getViewer().addFilter((ViewerFilter)CordovaPluginCatalogViewer.this.installedPluginsFilter);
                } else {
                    CordovaPluginCatalogViewer.this.installedPluginsFilter.setProject(CordovaPluginCatalogViewer.this.project);
                    CordovaPluginCatalogViewer.this.getViewer().refresh();
                }
            }
        });
    }

    private static class CordovaPluginInfoContentProvider
    implements IStructuredContentProvider {
        private Object[] pluginInfos;

        private CordovaPluginInfoContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.pluginInfos = (Object[])newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.pluginInfos;
        }
    }

    private static class CordovaPluginViewerComparator
    extends ViewerComparator {
        private static final String CORDOVA_NAMESPACE = "org.apache.cordova";
        private static final int CATEGORY_CORDOVA = 0;
        private static final int CATEGORY_OTHER = 1;

        private CordovaPluginViewerComparator() {
        }

        public int category(Object element) {
            CordovaRegistryPluginInfo info = (CordovaRegistryPluginInfo)element;
            if (info.getName().startsWith(CORDOVA_NAMESPACE)) {
                return 0;
            }
            return 1;
        }
    }
}

