/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.plugins.internal.RestorePluginWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class RestorePluginsListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] projectDeltas;
        IResourceDelta[] iResourceDeltaArray = projectDeltas = event.getDelta().getAffectedChildren();
        int n = projectDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            if (delta.getKind() == 1 && (delta.getFlags() & 0x4000) != 0 && delta.getResource().getType() == 4) {
                IProject project = delta.getResource().getProject();
                try {
                    if (project.hasNature("org.eclipse.thym.core.HybridAppNature")) {
                        PluginCheckJob job = new PluginCheckJob(project);
                        job.schedule();
                    }
                }
                catch (CoreException e) {
                    HybridUI.log(4, NLS.bind((String)"Can not check nature for project {0} ", (Object)project.getName()), e);
                }
            }
            ++n2;
        }
    }

    private void runRestoreUI(final HybridProject project) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                RestorePluginWizard wizard = new RestorePluginWizard(project);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.setMinimumPageSize(550, 450);
                dialog.open();
            }
        });
    }

    private class PluginCheckJob
    extends Job {
        private IProject project;

        public PluginCheckJob(IProject project) {
            super("Saved Cordova plug-ins job");
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.project);
            if (hybridProject == null) {
                return Status.OK_STATUS;
            }
            try {
                List restorables = hybridProject.getPluginManager().getRestorablePlugins(monitor);
                if (!restorables.isEmpty()) {
                    RestorePluginsListener.this.runRestoreUI(hybridProject);
                }
            }
            catch (CoreException e) {
                HybridUI.log(2, "Could not restore Cordova plug-ins from config.xml", e);
            }
            return Status.OK_STATUS;
        }
    }
}

