/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.internal.core;

import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.wp.core.WPCore;
import org.eclipse.thym.wp.core.vstudio.MSBuild;
import org.eclipse.thym.wp.core.vstudio.WPEmulator;
import org.eclipse.thym.wp.internal.core.Messages;

public class WPLaunchDelegate
implements ILaunchConfigurationDelegate2 {
    private File buildArtifact;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.WPLaunchDelegate_LaunchTask, 10);
        IProject kernelProject = this.getProject(configuration);
        Assert.isNotNull((Object)kernelProject, (String)Messages.WPLaunchDelegate_NoProjectError);
        int deviceId = configuration.getAttribute("org.eclipse.thym.wp.core.ATTR_DEVICE_IDENTIFIER", -1);
        WPEmulator emulator = new WPEmulator(WPCore.getSDKLocation());
        HybridProject project = HybridProject.getHybridProject((IProject)kernelProject);
        if (project == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.wp.core", NLS.bind((String)Messages.WPLaunchDelegate_NotHybridError, (Object)kernelProject.getName())));
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        emulator.setProcessEnvironmentVariables(envp).emulate(this.buildArtifact, deviceId);
        monitor.worked(2);
        monitor.done();
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        MSBuild build = new MSBuild();
        build.setLaunchConfiguration(configuration);
        build.init(this.getProject(configuration), null);
        build.buildNow(monitor);
        this.buildArtifact = build.getBuildArtifact();
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.done();
        return true;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String sdkLocation = WPCore.getSDKLocation();
        if (sdkLocation == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.wp.core", Messages.WPLaunchDelegate_SDKMissingMessage));
        }
        WPEmulator emluator = new WPEmulator(sdkLocation);
        Map<String, Integer> devices = emluator.getDevices();
        if (devices == null || devices.isEmpty()) {
            throw new CoreException((IStatus)new HybridMobileStatus(4, "org.eclipse.thym.wp.core", 330, MessageFormat.format(Messages.WPLaunchDelegate_NoEmulatorsError, "http://dev.windows.com/en-us/develop/download-phone-sdk"), null));
        }
        return true;
    }

    private IProject getProject(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", null);
            if (projectName != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }
}

