/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.internal.core.vstudio;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.thym.core.plugin.actions.CopyFileAction;
import org.eclipse.thym.wp.internal.core.vstudio.WPProjectUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WPCopyFileAction
extends CopyFileAction {
    private static final String DOT_CS = ".cs";
    private static final String DOT_XAML = ".xaml";
    private static final String PAGE = "Page";
    private static final String DEPENDENT_UPON = "DependentUpon";
    private static final String CONTENT = "Content";
    private static final String COMPILE = "Compile";
    private static final String GENERATOR = "Generator";
    private static final String SUB_TYPE = "SubType";
    private static final String INCLUDE = "Include";
    private static final String ITEM_GROUP = "ItemGroup";
    private File rootFolder;
    private Document document;

    public WPCopyFileAction(File source, File target, File rootFolder) {
        super(source, target);
        this.rootFolder = rootFolder;
    }

    public void install() throws CoreException {
        super.install();
        File csprojFile = WPProjectUtils.getCsrojFile(this.rootFolder);
        if (csprojFile != null) {
            this.setDocument(WPProjectUtils.readXML(csprojFile));
            Element root = this.getDocument().getDocumentElement();
            Element itemGroup = this.getItemGroup();
            String name = this.target.getName();
            if (name.endsWith(DOT_CS)) {
                itemGroup.appendChild(this.getCompileInclude());
                if (name.endsWith(".xaml.cs")) {
                    itemGroup.appendChild(this.getPageInclude());
                }
            } else if (!name.endsWith(DOT_XAML)) {
                itemGroup.appendChild(this.getContentInclude());
            }
            root.appendChild(itemGroup);
            WPProjectUtils.writeXML(csprojFile, this.getDocument());
        }
    }

    private Document getDocument() {
        return this.document;
    }

    private void setDocument(Document document) {
        this.document = document;
    }

    private Element getItemGroup() {
        return this.getDocument().createElement(ITEM_GROUP);
    }

    private Node getPageInclude() {
        Element pageInclude = this.getDocument().createElement(PAGE);
        String relativePath = this.getRelativePath(this.target);
        relativePath = relativePath.substring(0, relativePath.indexOf(DOT_CS));
        pageInclude.setAttribute(INCLUDE, relativePath);
        Element subType = this.getDocument().createElement(SUB_TYPE);
        subType.setTextContent("Designer");
        pageInclude.appendChild(subType);
        Element generator = this.getDocument().createElement(GENERATOR);
        generator.setTextContent("MSBuild:Compile");
        pageInclude.appendChild(generator);
        return pageInclude;
    }

    private Element getCompileInclude() {
        Element compileInclude = this.getDocument().createElement(COMPILE);
        String relativePath = this.getRelativePath(this.target);
        compileInclude.setAttribute(INCLUDE, relativePath);
        if (relativePath.endsWith(".xaml.cs")) {
            compileInclude.appendChild(this.getDependetUpon(relativePath));
        }
        return compileInclude;
    }

    private Element getContentInclude() {
        Element contentInclude = this.getDocument().createElement(CONTENT);
        String relativePath = this.getRelativePath(this.target);
        contentInclude.setAttribute(INCLUDE, relativePath);
        return contentInclude;
    }

    private Element getDependetUpon(String fullPath) {
        Element dependUpon = this.getDocument().createElement(DEPENDENT_UPON);
        Path path = new Path(fullPath);
        String fileName = path.lastSegment();
        fileName = fileName.substring(0, fileName.indexOf(DOT_CS));
        dependUpon.setTextContent(fileName);
        return dependUpon;
    }

    private String getRelativePath(File target) {
        Path targetPath = new Path(target.getAbsolutePath());
        Path rootPath = new Path(this.rootFolder.getAbsolutePath());
        targetPath = targetPath.makeRelativeTo((IPath)rootPath);
        return targetPath.toString().replace('/', '\\');
    }
}

