/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine.internal.cordova;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.AbstractEngineRepoProvider;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileEngineLocator;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.eclipse.thym.core.engine.internal.cordova.EngineDownloadReceiver;
import org.eclipse.thym.core.engine.internal.cordova.NpmBasedEngineRepoProvider;
import org.eclipse.thym.core.extensions.CordovaEngineRepoProvider;
import org.eclipse.thym.core.extensions.PlatformSupport;

public class CordovaEngineProvider
implements HybridMobileEngineLocator,
HybridMobileEngineLocator.EngineSearchListener {
    public static final String CORDOVA_ENGINE_ID = "cordova";
    public static final String CUSTOM_CORDOVA_ENGINE_ID = "custom_cordova";
    private static volatile ArrayList<HybridMobileEngine> engineList;

    public List<HybridMobileEngine> getAvailableEngines() {
        this.initEngineList();
        return engineList;
    }

    private void resetEngineList() {
        engineList = null;
    }

    private void initEngineList() {
        if (engineList != null) {
            return;
        }
        engineList = new ArrayList();
        File libFolder = CordovaEngineProvider.getLibFolder().toFile();
        if (!libFolder.isDirectory()) {
            return;
        }
        this.searchForRuntimes((IPath)new Path(libFolder.toString()), this, (IProgressMonitor)new NullProgressMonitor());
        String[] locs = HybridCore.getDefault().getCustomLibraryLocations();
        if (locs != null) {
            int i = 0;
            while (i < locs.length) {
                this.searchForRuntimes((IPath)new Path(locs[i]), this, (IProgressMonitor)new NullProgressMonitor());
                ++i;
            }
        }
    }

    public String getName() {
        return "Apache Cordova";
    }

    public HybridMobileEngine getEngine(String id, String version) {
        this.initEngineList();
        for (HybridMobileEngine engine : engineList) {
            if (!engine.getVersion().equals(version) || !engine.getId().equals(id)) continue;
            return engine;
        }
        return null;
    }

    public HybridMobileEngine createEngine(String id, String version, HybridMobileLibraryResolver resolver, IPath location) {
        HybridMobileEngine engine = new HybridMobileEngine();
        engine.setId(id);
        engine.setName(NLS.bind((String)"{0}-{1}", (Object[])new String[]{CORDOVA_ENGINE_ID, id}));
        engine.setResolver(resolver);
        engine.setVersion(version);
        engine.setLocation(location);
        return engine;
    }

    public static IPath getLibFolder() {
        Path path = new Path(FileUtils.getUserDirectory().toString());
        path = path.append(".cordova").append("lib");
        return path;
    }

    public List<DownloadableCordovaEngine> getDownloadableVersions() throws CoreException {
        AbstractEngineRepoProvider provider = new NpmBasedEngineRepoProvider();
        IProduct product = Platform.getProduct();
        if (product != null) {
            String productId = Platform.getProduct().getId();
            List<CordovaEngineRepoProvider> providerProxies = HybridCore.getCordovaEngineRepoProviders();
            for (CordovaEngineRepoProvider providerProxy : providerProxies) {
                if (!productId.equals(providerProxy.getProductId())) continue;
                provider = providerProxy.createProvider();
            }
        }
        return ((AbstractEngineRepoProvider)provider).getEngines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadEngine(DownloadableCordovaEngine[] engines, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IRetrieveFileTransfer transfer = HybridCore.getDefault().getFileTransferService();
        int platformSize = engines.length;
        Object lock = new Object();
        int incompleteCount = platformSize;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)platformSize);
        int i = 0;
        while (i < platformSize) {
            sm.setTaskName("Download Cordova Engine " + engines[i].getVersion());
            try {
                URI uri = URI.create(engines[i].getDownloadURL());
                IFileID remoteFileID = FileIDFactory.getDefault().createFileID(transfer.getRetrieveNamespace(), uri);
                if (sm.isCanceled()) {
                    return;
                }
                transfer.sendRetrieveRequest(remoteFileID, (IFileTransferListener)new EngineDownloadReceiver(engines[i].getVersion(), engines[i].getPlatformId(), lock, (IProgressMonitor)sm), null);
            }
            catch (FileCreateException e) {
                HybridCore.log(4, "Engine download file create error", e);
            }
            catch (IncomingFileTransferException e) {
                HybridCore.log(4, "Engine download file transfer error", e);
            }
            ++i;
        }
        Object object = lock;
        synchronized (object) {
            while (incompleteCount > 0) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    HybridCore.log(1, "interrupted while waiting for all engines to download", e);
                }
                --incompleteCount;
                sm.worked(1);
            }
        }
        this.resetEngineList();
    }

    public boolean isSupportedPlatform(String version, String platformId) {
        Assert.isNotNull((Object)platformId);
        Assert.isNotNull((Object)version);
        List<DownloadableCordovaEngine> engines = null;
        try {
            engines = this.getDownloadableVersions();
        }
        catch (CoreException e) {
            HybridCore.log(4, "Error retrieving downloadable engines", e);
        }
        if (engines == null) {
            return false;
        }
        for (DownloadableCordovaEngine downloadable : engines) {
            if (!downloadable.getVersion().equals(version) || !downloadable.getPlatformId().equals(platformId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void searchForRuntimes(IPath path, HybridMobileEngineLocator.EngineSearchListener listener, IProgressMonitor monitor) {
        if (path == null) {
            return;
        }
        File root = path.toFile();
        if (!root.isDirectory()) {
            return;
        }
        this.searchDir(root, listener, monitor);
    }

    private void searchDir(File dir, HybridMobileEngineLocator.EngineSearchListener listener, IProgressMonitor monitor) {
        File[] dirs;
        File createScript;
        if ("bin".equals(dir.getName()) && (createScript = new File(dir, "create")).exists()) {
            Path libraryRoot = new Path(dir.getParent());
            List<PlatformSupport> platforms = HybridCore.getPlatformSupports();
            for (PlatformSupport platformSupport : platforms) {
                try {
                    HybridMobileLibraryResolver resolver = platformSupport.getLibraryResolver();
                    resolver.init((IPath)libraryRoot);
                    if (!resolver.isLibraryConsistent().isOK()) continue;
                    HybridMobileEngine engine = this.createEngine(platformSupport.getPlatformId(), resolver.detectVersion(), resolver, (IPath)libraryRoot);
                    listener.engineFound(engine);
                    return;
                }
                catch (CoreException e) {
                    HybridCore.log(2, "Error on engine search", e);
                }
            }
        }
        if ((dirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) != null) {
            int i = 0;
            while (i < dirs.length) {
                String name;
                if (!(monitor.isCanceled() || (name = dirs[i].getName()).equals("npm_cache") || name.equals("tmp"))) {
                    this.searchDir(dirs[i], listener, monitor);
                }
                ++i;
            }
        }
    }

    @Override
    public void engineFound(HybridMobileEngine engine) {
        engineList.add(engine);
    }

    public void deleteEngineLibraries(HybridMobileEngine selectedEngine) {
        IPath path = selectedEngine.getLocation();
        FileUtils.deleteQuietly((File)path.toFile());
        this.resetEngineList();
    }
}

