/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.cordova;

import java.util.Scanner;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.core.internal.cordova.CordovaCLIResult;

public class ErrorDetectingCLIResult
extends CordovaCLIResult {
    private static final String ERROR_PREFIX = "Error:";
    private StringBuffer errorMessage = new StringBuffer();
    private int errorCode = 500;

    public ErrorDetectingCLIResult(String message) {
        super(message);
        this.parseErrors();
    }

    @Override
    public IStatus asStatus() {
        if (this.errorMessage.length() > 0) {
            return new HybridMobileStatus(4, "org.eclipse.thym.core", this.errorCode, this.errorMessage.toString(), null);
        }
        return super.asStatus();
    }

    private void parseErrors() {
        Scanner scanner = new Scanner(this.getMessage());
        boolean error = false;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if ((line = line.trim()).startsWith(ERROR_PREFIX)) {
                error = true;
                this.errorMessage = this.errorMessage.append(line.substring(ERROR_PREFIX.length(), line.length()).trim());
                continue;
            }
            if (line.contains("command not found") || line.contains("is not recognized as an internal or external command")) {
                error = true;
                this.errorMessage.append("Cordova not found, please run 'npm install -g cordova' on a command line to install Cordova globally");
                this.errorCode = 501;
                continue;
            }
            if (!error) continue;
            this.errorMessage.append(System.lineSeparator());
            this.errorMessage.append(line);
        }
        scanner.close();
    }
}

