/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.thym.core.internal.util.TarEntry;
import org.eclipse.thym.core.internal.util.TarException;
import org.eclipse.thym.core.internal.util.TarFile;

public final class FileUtils {
    private FileUtils() {
    }

    public static void directoryCopy(URL source, URL destination) throws IOException {
        FileUtils.checkCanCopy(source, destination);
        source = FileUtils.getFileURL(source);
        destination = FileUtils.getFileURL(destination);
        File dstFile = new File(destination.getFile());
        if (!dstFile.exists() && !dstFile.mkdir()) {
            return;
        }
        if ("file".equals(source.getProtocol())) {
            File srcFile = new File(source.getFile());
            FileUtils.copyFile(srcFile, dstFile);
        } else if ("jar".equals(source.getProtocol())) {
            ZipFile zipFile = FileUtils.getZipFile(source);
            String file = source.getFile();
            int exclamation = file.indexOf(33);
            String jarLocation = file.substring(exclamation + 2);
            FileUtils.copyFromZip(zipFile, jarLocation, dstFile);
        }
    }

    public static void fileCopy(URL source, URL destination) throws IOException {
        FileUtils.checkCanCopy(source, destination);
        source = FileUtils.getFileURL(source);
        destination = FileUtils.getFileURL(destination);
        File dstFile = new File(destination.getFile());
        if (dstFile.exists()) {
            return;
        }
        if (!dstFile.getParentFile().exists() && !dstFile.getParentFile().mkdirs()) {
            return;
        }
        if (!dstFile.createNewFile()) {
            return;
        }
        if ("file".equals(source.getProtocol())) {
            File srcFile = new File(source.getFile());
            FileUtils.copyFile(srcFile, dstFile);
        } else if ("jar".equals(source.getProtocol())) {
            ZipFile zipFile = FileUtils.getZipFile(source);
            String file = source.getFile();
            int exclamation = file.indexOf(33);
            String jarLocation = file.substring(exclamation + 2);
            FileUtils.copyFromZip(zipFile, jarLocation, dstFile);
        }
    }

    public static void templatedFileCopy(URL source, URL destination, Map<String, String> templateValues) throws IOException {
        FileUtils.checkCanCopy(source, destination);
        if (templateValues == null) {
            throw new IllegalArgumentException("Template values can not be null");
        }
        source = FileUtils.getFileURL(source);
        destination = FileUtils.getFileURL(destination);
        File dstFile = new File(destination.getFile());
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            String line;
            out = new BufferedWriter(new FileWriter(dstFile));
            if ("file".equals(source.getProtocol())) {
                File srcFile = new File(source.getFile());
                in = new BufferedReader(new FileReader(srcFile));
            } else if ("jar".equals(source.getProtocol())) {
                int exclamation;
                String file;
                String jarLocation;
                ZipFile zipFile = FileUtils.getZipFile(source);
                ZipEntry zipEntry = zipFile.getEntry(jarLocation = (file = source.getFile()).substring((exclamation = file.indexOf(33)) + 2));
                if (zipEntry == null) {
                    throw new IllegalArgumentException(source + " can not be found on the zip file");
                }
                InputStream zipStream = zipFile.getInputStream(zipEntry);
                in = new BufferedReader(new InputStreamReader(zipStream));
            }
            while ((line = in.readLine()) != null) {
                for (Map.Entry<String, String> entry : templateValues.entrySet()) {
                    line = line.replace(entry.getKey(), entry.getValue());
                }
                out.write(line);
                out.newLine();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public static boolean isNewer(URL file, URL reference) {
        ZipEntry zipEntry;
        ZipFile zipFile;
        if (file == null || reference == null) {
            throw new IllegalArgumentException("null file value");
        }
        file = FileUtils.getFileURL(file);
        reference = FileUtils.getFileURL(reference);
        if (!FileUtils.isFile(file) && !FileUtils.isFile(reference)) {
            throw new IllegalArgumentException("destination is not a file URL");
        }
        long fileLastModified = 0L;
        long referenceLastModified = 0L;
        if ("file".equals(file.getProtocol())) {
            File srcFile = new File(file.getFile());
            fileLastModified = srcFile.lastModified();
        }
        if ("file".equals(reference.getProtocol())) {
            File referenceFile = new File(reference.getFile());
            referenceLastModified = referenceFile.lastModified();
        }
        if ("jar".equals(file.getProtocol())) {
            zipFile = FileUtils.getZipFile(file);
            zipEntry = FileUtils.getZipEntry(file, zipFile);
            if (zipEntry == null) {
                throw new IllegalArgumentException(file + " can not be found on the zip file");
            }
            fileLastModified = zipEntry.getTime();
        }
        if ("jar".equals(reference.getProtocol())) {
            zipFile = FileUtils.getZipFile(reference);
            zipEntry = FileUtils.getZipEntry(reference, zipFile);
            if (zipEntry == null) {
                throw new IllegalArgumentException(reference + " can not be found on the zip file");
            }
            referenceLastModified = zipEntry.getTime();
        }
        return fileLastModified >= referenceLastModified;
    }

    public static URL toURL(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static File[] resolveFile(File parent, String filename) {
        if (parent == null) {
            return new File[0];
        }
        if (!parent.isDirectory() || filename == null || filename.isEmpty() || filename.equals(".")) {
            return new File[]{parent};
        }
        File f = new File(parent, filename);
        if (f.exists()) {
            return new File[]{f};
        }
        Collection theFiles = org.apache.commons.io.FileUtils.listFiles((File)parent, (IOFileFilter)new WildcardFileFilter(filename), (IOFileFilter)TrueFileFilter.INSTANCE);
        return theFiles.toArray(new File[theFiles.size()]);
    }

    private static void checkCanCopy(URL source, URL destination) {
        if (source == null || destination == null) {
            throw new IllegalArgumentException("null source or destination value");
        }
        FileUtils.getFileURL(source);
        destination = FileUtils.getFileURL(destination);
        if (!FileUtils.isFile(destination)) {
            throw new IllegalArgumentException("destination is not a file URL");
        }
    }

    private static boolean isFile(URL url) {
        return "file".equals(url.getProtocol());
    }

    private static URL getFileURL(URL url) {
        try {
            url = FileLocator.resolve((URL)url);
            return FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static ZipFile getZipFile(URL url) {
        if (!"jar".equals(url.getProtocol())) {
            return null;
        }
        String file = url.getFile();
        int exclamation = file.indexOf(33);
        if (exclamation < 0) {
            return null;
        }
        URL fileUrl = null;
        try {
            fileUrl = new URL(file.substring(0, exclamation));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        File pluginJar = new File(fileUrl.getFile());
        if (!pluginJar.exists()) {
            return null;
        }
        try {
            ZipFile zipFile = new ZipFile(pluginJar);
            return zipFile;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static ZipEntry getZipEntry(URL file, ZipFile zipFile) {
        String fileString = file.getFile();
        int exclamation = fileString.indexOf(33);
        String jarLocation = fileString.substring(exclamation + 2);
        return zipFile.getEntry(jarLocation);
    }

    private static void copyFromZip(ZipFile zipFile, String locationInBundle, File destination) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (!zipEntry.getName().startsWith(locationInBundle)) continue;
            String path = zipEntry.getName().substring(locationInBundle.length());
            File file = new File(destination, path);
            if (!zipEntry.isDirectory()) {
                FileUtils.createFileFromZipFile(file, zipFile, zipEntry);
                continue;
            }
            if (file.exists()) continue;
            file.mkdir();
        }
    }

    private static void createFileFromZipFile(File file, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException("Can not create parent directory for " + file.toString());
        }
        file.createNewFile();
        FileOutputStream fout = null;
        AbstractInterruptibleChannel out = null;
        InputStream in = null;
        try {
            fout = new FileOutputStream(file);
            out = fout.getChannel();
            in = zipFile.getInputStream(zipEntry);
            ((FileChannel)out).transferFrom(Channels.newChannel(in), 0L, Integer.MAX_VALUE);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    private static void copyFile(File source, File target) throws IOException {
        File file = null;
        if (source.isDirectory() && source.exists() && target.isDirectory() && target.exists()) {
            File[] children;
            File[] fileArray = children = source.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                file = target;
                if (child.isDirectory() && !(file = new File(target, child.getName())).exists()) {
                    file.mkdir();
                }
                FileUtils.copyFile(child, file);
                ++n2;
            }
        } else {
            file = target.isFile() ? target : new File(target, source.getName());
            AbstractInterruptibleChannel out = null;
            AbstractInterruptibleChannel in = null;
            try {
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    out = new FileOutputStream(file).getChannel();
                    in = new FileInputStream(source).getChannel();
                    ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public static File[] untarFile(File source, File outputDir) throws IOException, TarException {
        ArrayList<File> untarredFiles = new ArrayList<File>();
        try (TarFile tarFile = new TarFile(source);){
            Enumeration<TarEntry> e = tarFile.entries();
            while (e.hasMoreElements()) {
                TarEntry entry = e.nextElement();
                try (InputStream input = tarFile.getInputStream(entry);){
                    File outFile = new File(outputDir, entry.getName());
                    outFile = outFile.getCanonicalFile();
                    untarredFiles.add(outFile);
                    if (entry.getFileType() == 53) {
                        outFile.mkdirs();
                        continue;
                    }
                    if (outFile.exists()) {
                        outFile.delete();
                    } else {
                        outFile.getParentFile().mkdirs();
                    }
                    try {
                        FileUtils.copyStream(input, false, new FileOutputStream(outFile), true);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                    outFile.setLastModified(entry.getTime());
                }
            }
        }
        return untarredFiles.toArray(new File[untarredFiles.size()]);
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }
}

