/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin;

import java.util.Scanner;
import java.util.regex.MatchResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.core.internal.cordova.ErrorDetectingCLIResult;

public class PluginMessagesCLIResult
extends ErrorDetectingCLIResult {
    private HybridMobileStatus pluginStatus;

    public PluginMessagesCLIResult(String message) {
        super(message);
        this.parseMessage();
    }

    @Override
    public IStatus asStatus() {
        if (this.pluginStatus != null) {
            return this.pluginStatus;
        }
        return super.asStatus();
    }

    private void parseMessage() {
        Scanner scanner = new Scanner(this.getMessage());
        while (scanner.hasNextLine()) {
            if (scanner.findInLine("(?:\\s\\-\\-variable\\s(\\w*)=value)") != null) {
                MatchResult mr = scanner.match();
                StringBuilder missingVars = new StringBuilder();
                int i = 0;
                while (i < mr.groupCount()) {
                    if (i > 0) {
                        missingVars.append(",");
                    }
                    missingVars.append(mr.group());
                    ++i;
                }
                this.pluginStatus = new HybridMobileStatus(4, "org.eclipse.thym.core", 550, NLS.bind((String)"This plugin requires {0} to be defined", (Object)missingVars), null);
            }
            scanner.nextLine();
        }
        scanner.close();
    }
}

