/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.simulator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.thym.core.internal.util.ExternalProcessUtility;
import org.eclipse.thym.ios.core.IOSCore;
import org.eclipse.thym.ios.core.simulator.IOSDevice;

public class IOSSimulator {
    private String[] environment;
    private IOSDevice deviceId;
    private IProgressMonitor monitor;

    public IOSSimulator(IOSDevice deviceId) {
        this.setDeviceId(deviceId);
    }

    public IOSSimulator launch() throws CoreException {
        StringBuilder cmdLine = new StringBuilder();
        cmdLine.append("xcrun");
        cmdLine.append(" instruments -w ");
        cmdLine.append(this.getDeviceId().getDeviceId());
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        processUtility.execSync(cmdLine.toString(), null, null, null, this.getProgressMonitor(), this.environment, null);
        return this;
    }

    public IOSSimulator installApp(String path) throws CoreException {
        StringBuilder cmdLine = new StringBuilder();
        cmdLine.append("xcrun");
        cmdLine.append(" simctl install ");
        cmdLine.append(this.getDeviceId().getDeviceId()).append(" ");
        cmdLine.append("\"").append(path).append("\"");
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        processUtility.execSync(cmdLine.toString(), null, null, null, this.getProgressMonitor(), this.environment, null);
        return this;
    }

    public IOSSimulator startApp(String id) throws CoreException {
        StringBuilder cmdLine = new StringBuilder();
        cmdLine.append("xcrun");
        cmdLine.append(" simctl launch ");
        cmdLine.append(this.getDeviceId().getDeviceId()).append(" ");
        cmdLine.append(id);
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        processUtility.execSync(cmdLine.toString(), null, null, null, this.getProgressMonitor(), this.environment, null);
        return this;
    }

    public static List<IOSDevice> listDevices(IProgressMonitor monitor) throws CoreException {
        StringBuilder cmdLine = new StringBuilder();
        cmdLine.append("xcrun");
        cmdLine.append(" simctl list ");
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        DeviceListParser parser = new DeviceListParser();
        processUtility.execSync(cmdLine.toString(), null, (IStreamListener)parser, (IStreamListener)parser, monitor, null, null);
        return parser.getDeviceList();
    }

    public static IOSDevice findDevice(String deviceId, IProgressMonitor monitor) throws CoreException {
        if (deviceId == null) {
            return null;
        }
        List<IOSDevice> devices = IOSSimulator.listDevices(monitor);
        if (devices == null) {
            return null;
        }
        for (IOSDevice iosDevice : devices) {
            if (!iosDevice.getDeviceId().equals(deviceId)) continue;
            return iosDevice;
        }
        return null;
    }

    public IOSSimulator setProcessEnvironmentVariables(String[] envp) {
        this.environment = envp;
        return this;
    }

    public IOSDevice getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(IOSDevice deviceId) {
        this.deviceId = deviceId;
    }

    private IProgressMonitor getProgressMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    public IOSSimulator setProgressMonitor(IProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
        return this;
    }

    private static class DeviceListParser
    implements IStreamListener {
        private StringBuffer buffer = new StringBuffer();

        private DeviceListParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        public List<IOSDevice> getDeviceList() {
            if (this.buffer == null || this.buffer.length() < 1) {
                return null;
            }
            try {
                StringReader reader = new StringReader(this.buffer.toString());
                BufferedReader read = new BufferedReader(reader);
                String line = null;
                String iosVersion = null;
                boolean parsingDevices = false;
                ArrayList<IOSDevice> devices = new ArrayList<IOSDevice>();
                while ((line = read.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    if (line.equals("== Devices ==")) {
                        parsingDevices = true;
                        continue;
                    }
                    if (!parsingDevices) continue;
                    if (line.startsWith("==")) break;
                    if (line.startsWith("--")) {
                        line = line.replace("--", "");
                        iosVersion = line.trim();
                        continue;
                    }
                    String[] parts = line.split("[\\(\\)]");
                    if (parts.length < 2) continue;
                    IOSDevice device = new IOSDevice();
                    device.setDeviceName(parts[0].trim());
                    device.setDeviceId(parts[1].trim());
                    device.setiOSName(iosVersion);
                    devices.add(device);
                }
                return devices;
            }
            catch (IOException e) {
                IOSCore.log(4, "error parsing device list", e);
                return Collections.emptyList();
            }
        }
    }
}

