/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.xcode;

public class XCodeSDK {
    private String description;

    XCodeSDK(String definitionString) {
        this.description = definitionString;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isIOS() {
        return this.description.contains("iOS");
    }

    public boolean isSimulator() {
        return this.description.contains("Simulator");
    }

    public String getVersion() {
        String[] tokens;
        String[] stringArray = tokens = this.description.split(" ");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (Character.isDigit(string.charAt(0))) {
                return string;
            }
            ++n2;
        }
        return "";
    }

    public String getIdentifierString() {
        if (this.isIOS()) {
            if (this.isSimulator()) {
                return "iphonesimulator" + this.getVersion();
            }
            return "iphoneos" + this.getVersion();
        }
        return "macosx" + this.getVersion();
    }
}

