/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.engine;

import com.github.zafarkhaja.semver.Version;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.eclipse.thym.core.engine.internal.cordova.DownloadableCordovaEngine;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.PlatformImage;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;

public class EngineDownloadDialog
extends TitleAreaDialog {
    private static final int TREE_WIDTH = 350;
    private static final int TREE_HEIGHT = 175;
    private CheckboxTreeViewer platformList;
    private CordovaEngineProvider engineProvider;
    private List<HybridMobileEngine> engines;
    private ProgressMonitorPart progressMonitorPart;

    public EngineDownloadDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.toggleOKButton(false);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Download Hybrid Mobile Engine");
        this.setMessage("Download a new engine version");
        parent.getShell().setText("Download Hybrid Mobile Engine");
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).spacing(LayoutConstants.getSpacing()).numColumns(1).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        Tree tree = new Tree(composite, 67616);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(new Point(350, 175)).applyTo((Control)tree);
        tree.setHeaderVisible(false);
        tree.setLinesVisible(true);
        this.platformList = new CheckboxTreeViewer(tree);
        this.platformList.setContentProvider((IContentProvider)new DownloadableVersionsContentProvider());
        this.platformList.setLabelProvider((IBaseLabelProvider)new DownloadableEngineLabelProvider());
        this.platformList.setComparator((ViewerComparator)new DownloadableEngineComparator());
        this.platformList.addFilter((ViewerFilter)new InstalledVersionsFilter());
        this.platformList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof PlatformSupport) {
                    EngineDownloadDialog.this.platformList.setChecked(event.getElement(), false);
                }
                EngineDownloadDialog.this.validate();
            }
        });
        this.createProgressMonitorPart(composite);
        this.engineProvider = new CordovaEngineProvider();
        try {
            this.platformList.setInput((Object)this.engineProvider.getDownloadableVersions());
        }
        catch (CoreException e) {
            this.platformList.setInput(new Object());
            this.setErrorMessage(e.getMessage());
            HybridUI.log(4, "Unable to retrieve the downloadable versions list", e);
        }
        return composite;
    }

    private void createProgressMonitorPart(Composite composite) {
        this.progressMonitorPart = new ProgressMonitorPart(composite, (Layout)new GridLayout());
        this.progressMonitorPart.setVisible(true);
        GridDataFactory.fillDefaults().applyTo((Control)this.progressMonitorPart);
    }

    private boolean isInstalled(String version, String platformId) {
        if (version == null || platformId == null) {
            return false;
        }
        if (this.engines == null) {
            this.engines = this.engineProvider.getAvailableEngines();
        }
        for (HybridMobileEngine engine : this.engines) {
            if (!engine.getVersion().equals(version) || !engine.getId().equals(platformId)) continue;
            return true;
        }
        return false;
    }

    private void validate() {
        Object[] checked = this.platformList.getCheckedElements();
        if (checked == null || checked.length == 0) {
            this.toggleOKButton(false);
            return;
        }
        this.setErrorMessage(null);
        this.toggleOKButton(true);
    }

    private void toggleOKButton(boolean state) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(state);
        }
    }

    protected void okPressed() {
        final DownloadableCordovaEngine[] downloads = this.getDownloadsList();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                EngineDownloadDialog.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        EngineDownloadDialog.this.toggleOKButton(false);
                    }
                });
                EngineDownloadDialog.this.engineProvider.downloadEngine(downloads, monitor);
            }
        };
        Button cancelBtn = this.getButton(1);
        this.progressMonitorPart.attachToCancelComponent((Control)cancelBtn);
        try {
            try {
                ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.progressMonitorPart, (Display)this.getShell().getDisplay());
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    if (e.getTargetException() instanceof CoreException) {
                        StatusManager.handle((CoreException)e.getTargetException());
                    } else {
                        ErrorDialog.openError((Shell)this.getShell(), (String)"Error downloading engine", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Error downloading the engine", e.getTargetException()));
                    }
                }
                if (this.getShell() != null && !this.getShell().isDisposed()) {
                    this.progressMonitorPart.removeFromCancelComponent((Control)cancelBtn);
                }
                super.okPressed();
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            if (this.getShell() != null && !this.getShell().isDisposed()) {
                this.progressMonitorPart.removeFromCancelComponent((Control)cancelBtn);
            }
            super.okPressed();
        }
    }

    private DownloadableCordovaEngine[] getDownloadsList() {
        Object[] checked = this.platformList.getCheckedElements();
        DownloadableCordovaEngine[] downloads = new DownloadableCordovaEngine[checked.length];
        int i = 0;
        while (i < checked.length) {
            DownloadableCordovaEngine dce;
            downloads[i] = dce = (DownloadableCordovaEngine)checked[i];
            ++i;
        }
        return downloads;
    }

    private class DownloadableEngineComparator
    extends ViewerComparator
    implements Comparator<DownloadableCordovaEngine> {
        private DownloadableEngineComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof DownloadableCordovaEngine && e2 instanceof DownloadableCordovaEngine) {
                DownloadableCordovaEngine o1 = (DownloadableCordovaEngine)e1;
                DownloadableCordovaEngine o2 = (DownloadableCordovaEngine)e2;
                return this.compare(o1, o2);
            }
            return 1;
        }

        @Override
        public int compare(DownloadableCordovaEngine o1, DownloadableCordovaEngine o2) {
            Version v1 = Version.valueOf((String)o1.getVersion());
            Version v2 = Version.valueOf((String)o2.getVersion());
            return v2.compareTo(v1);
        }
    }

    private class DownloadableEngineLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DownloadableEngineLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof PlatformSupport) {
                PlatformSupport platform = (PlatformSupport)element;
                return PlatformImage.getImageFor("platformSupport", platform.getID());
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PlatformSupport) {
                return ((PlatformSupport)element).getPlatform();
            }
            if (element instanceof DownloadableCordovaEngine) {
                return ((DownloadableCordovaEngine)element).getVersion();
            }
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    private class DownloadableVersionsContentProvider
    implements ITreeContentProvider {
        private DownloadableCordovaEngine[] downloadables;
        private PlatformSupport[] platforms;

        private DownloadableVersionsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null && newInput instanceof List) {
                List list = (List)newInput;
                this.downloadables = list.toArray(new DownloadableCordovaEngine[list.size()]);
            } else {
                this.downloadables = null;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (this.platforms == null) {
                List allPlatforms = HybridCore.getPlatformSupports();
                ArrayList<PlatformSupport> elements = new ArrayList<PlatformSupport>();
                IEvaluationService service = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
                for (PlatformSupport generator : allPlatforms) {
                    try {
                        if (!generator.isEnabled(service.getCurrentState())) continue;
                        elements.add(generator);
                    }
                    catch (CoreException e) {
                        HybridUI.log(4, "Error filtering objects", e);
                    }
                }
                this.platforms = elements.toArray(new PlatformSupport[elements.size()]);
            }
            return this.platforms;
        }

        public Object[] getChildren(Object parentElement) {
            if (this.downloadables == null || !this.hasChildren(parentElement)) {
                return null;
            }
            PlatformSupport platform = (PlatformSupport)parentElement;
            ArrayList<DownloadableCordovaEngine> platformDownloadables = new ArrayList<DownloadableCordovaEngine>();
            DownloadableCordovaEngine[] downloadableCordovaEngineArray = this.downloadables;
            int n = this.downloadables.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadableCordovaEngine engine = downloadableCordovaEngineArray[n2];
                if (engine.getPlatformId().equals(platform.getPlatformId())) {
                    platformDownloadables.add(engine);
                }
                ++n2;
            }
            return platformDownloadables.toArray(new DownloadableCordovaEngine[platformDownloadables.size()]);
        }

        public Object getParent(Object element) {
            if (this.platforms != null && element instanceof DownloadableCordovaEngine) {
                DownloadableCordovaEngine engine = (DownloadableCordovaEngine)element;
                PlatformSupport[] platformSupportArray = this.platforms;
                int n = this.platforms.length;
                int n2 = 0;
                while (n2 < n) {
                    PlatformSupport platformSupport = platformSupportArray[n2];
                    if (engine.getPlatformId().equals(platformSupport.getPlatformId())) {
                        return platformSupport;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PlatformSupport;
        }
    }

    private class InstalledVersionsFilter
    extends ViewerFilter {
        private InstalledVersionsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof DownloadableCordovaEngine) {
                DownloadableCordovaEngine e = (DownloadableCordovaEngine)element;
                return !EngineDownloadDialog.this.isInstalled(e.getVersion(), e.getPlatformId());
            }
            return true;
        }
    }
}

