/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ControlListItem<T>
extends Composite {
    IndexListener indexListener;
    private boolean selected;
    private final MouseAdapter mouseListener;
    protected boolean isShowing = false;

    public ControlListItem(Composite parent, int style, T element) {
        super(parent, style | 0x80000 | 0x20000000);
        Assert.isNotNull(element);
        super.setData(element);
        this.setLayoutData(new GridData(4, 0, true, false));
        this.mouseListener = this.doCreateMouseListener();
        this.registerChild((Control)this);
    }

    public T getData() {
        return (T)super.getData();
    }

    public void setData(Object data) {
        throw new IllegalArgumentException();
    }

    private MouseAdapter doCreateMouseListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ControlListItem.this.indexListener != null) {
                    if (e.count == 2) {
                        ControlListItem.this.indexListener.open();
                    } else {
                        ControlListItem.this.indexListener.select();
                    }
                }
            }
        };
    }

    protected void registerChild(Control child) {
        child.addMouseListener((MouseListener)this.mouseListener);
    }

    protected abstract void refresh();

    public void setForeground(Color color) {
        Control[] children;
        super.setForeground(color);
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setForeground(color);
            ++n2;
        }
    }

    public void setBackground(Color color) {
        Control[] children;
        super.setBackground(color);
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setBackground(color);
            ++n2;
        }
    }

    public void setSelected(boolean select) {
        this.selected = select;
    }

    void setIndexListener(IndexListener indexListener) {
        this.indexListener = indexListener;
    }

    public boolean isSelected() {
        return this.selected;
    }

    void setDisplayed(int top, int bottom) {
        int itemTop = this.getLocation().y;
        int itemBottom = itemTop + this.getBounds().height;
        this.setDisplayed(itemTop <= bottom && itemBottom > top);
    }

    private void setDisplayed(boolean displayed) {
        boolean refresh = this.isShowing ^ displayed;
        this.isShowing = displayed;
        if (refresh) {
            this.refresh();
        }
    }

    static interface IndexListener {
        public void selectPrevious();

        public void selectNext();

        public void select();

        public void open();
    }
}

