/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class CordovaPluginWizardResources {
    private final ResourceManager resourceManager;
    private final FontDescriptor h2FontDescriptor;
    private final FontDescriptor subFontDescriptor;
    private final FontDescriptor italicFontDescriptor;
    private final FontDescriptor h2ItalicFontDescriptor;

    public CordovaPluginWizardResources(Display display) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)display));
        this.h2FontDescriptor = this.createFontDescriptor(1, 1.15f);
        this.h2ItalicFontDescriptor = this.createFontDescriptor(3, 1.15f);
        this.subFontDescriptor = this.createFontDescriptor(0, 0.75f);
        this.italicFontDescriptor = this.createFontDescriptor(2, 1.0f);
    }

    private FontDescriptor createFontDescriptor(int style, float heightMultiplier) {
        Font baseFont = JFaceResources.getDialogFont();
        FontData[] fontData = baseFont.getFontData();
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < newFontData.length) {
            newFontData[i] = new FontData(fontData[i].getName(), (int)((float)fontData[i].getHeight() * heightMultiplier), fontData[i].getStyle() | style);
            ++i;
        }
        return FontDescriptor.createFrom((FontData[])newFontData);
    }

    public Font getSmallHeaderFont() {
        return this.resourceManager.createFont(this.h2FontDescriptor);
    }

    public Font getSmallItalicHeaderFont() {
        return this.resourceManager.createFont(this.h2ItalicFontDescriptor);
    }

    public Font getSubTextFont() {
        return this.resourceManager.createFont(this.subFontDescriptor);
    }

    public Font getItalicFont() {
        return this.resourceManager.createFont(this.italicFontDescriptor);
    }
}

