/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.export;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.extensions.NativeProjectBuilder;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.wizard.export.BaseExportWizardDestinationPage;
import org.eclipse.thym.ui.wizard.export.NativeProjectBuilderContentProvider;
import org.eclipse.thym.ui.wizard.export.NativeProjectBuilderLabelProvider;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class NativeBinaryDestinationPage
extends BaseExportWizardDestinationPage
implements IOverwriteQuery {
    private static final String IMAGE_WIZBAN = "/icons/wizban/exportnativeprj_wiz.png";

    protected NativeBinaryDestinationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setImageDescriptor(HybridUI.getImageDescriptor("org.eclipse.thym.ui", IMAGE_WIZBAN));
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getPlatformsGroup().getTableViewer().setInput((Object)HybridCore.getNativeProjectBuilders());
    }

    public String queryOverwrite(String pathString) {
        final MessageDialog dialog = new MessageDialog(this.getShell(), "Overwrite Files?", null, String.valueOf(pathString) + " already exists. Would you like to overwrite it?", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "NO", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    @Override
    protected IContentProvider getPlatformContentProvider() {
        return new NativeProjectBuilderContentProvider();
    }

    @Override
    protected IBaseLabelProvider getPlatformLabelProvider() {
        return new NativeProjectBuilderLabelProvider();
    }

    public List<NativeProjectBuilder> getSelectedPlatforms() {
        Object[] checked = this.getPlatformsGroup().getTableViewer().getCheckedElements();
        ArrayList<NativeProjectBuilder> builders = new ArrayList<NativeProjectBuilder>(checked.length);
        int i = 0;
        while (i < checked.length) {
            builders.add((NativeProjectBuilder)checked[i]);
            ++i;
        }
        return builders;
    }
}

