/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.project;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileEngineManager;
import org.eclipse.thym.ui.internal.engine.AvailableCordovaEnginesSection;

public class EngineConfigurationPage
extends WizardPage {
    private AvailableCordovaEnginesSection engineSection;

    protected EngineConfigurationPage(String pageName) {
        super(pageName);
        this.setTitle("Select a Hybrid Mobile Engine");
        this.setDescription("Select a hybrid mobile engine that will be used for building the mobile application");
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.initializeDialogUnits((Control)control);
        GridLayoutFactory.fillDefaults().applyTo(control);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)control);
        this.engineSection = new AvailableCordovaEnginesSection();
        this.engineSection.createControl(control);
        this.engineSection.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EngineConfigurationPage.this.setPageComplete(EngineConfigurationPage.this.validatePage());
            }
        });
        this.setControl((Control)control);
        this.setDefaultEngine();
        this.setPageComplete(this.validatePage());
        Dialog.applyDialogFont((Control)this.getControl());
    }

    private boolean validatePage() {
        IStructuredSelection selection = (IStructuredSelection)this.engineSection.getSelection();
        if (selection.isEmpty()) {
            this.setErrorMessage("Please select a Hybrid Mobile Engine ");
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private void setDefaultEngine() {
        Object[] engines = HybridMobileEngineManager.defaultEngines();
        if (engines != null && engines.length > 0) {
            this.engineSection.setSelection((ISelection)new StructuredSelection(engines));
        }
    }

    public HybridMobileEngine[] getSelectedEngines() {
        IStructuredSelection selection = (IStructuredSelection)this.engineSection.getSelection();
        List selected = selection.toList();
        return selected.toArray(new HybridMobileEngine[selected.size()]);
    }
}

