/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.project;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.thym.core.HybridProjectConventions;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WorkingSetGroup;

public class WizardNewHybridProjectCreationPage
extends WizardNewProjectCreationPage {
    private Text txtName;
    private Text txtID;
    private WorkingSetGroup workingSetGroup;
    private final PropertyModifyListener propertyModifyListener = new PropertyModifyListener();
    private IStructuredSelection currentSelection;

    public WizardNewHybridProjectCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.currentSelection = selection;
        this.setTitle("Create Hybrid Mobile Application Project");
        this.setDescription("Create a hybrid mobile application using Apache Cordova for cross-platform mobile development");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Group applicationGroup = new Group((Composite)this.getControl(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        applicationGroup.setLayout((Layout)layout);
        applicationGroup.setLayoutData((Object)new GridData(768));
        applicationGroup.setText("Mobile Application");
        Label lblName = new Label((Composite)applicationGroup, 0);
        lblName.setText("Name:");
        this.txtName = new Text((Composite)applicationGroup, 2048);
        this.txtName.addModifyListener((ModifyListener)this.propertyModifyListener);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtName.setMessage("a friendly name");
        Label lblId = new Label((Composite)applicationGroup, 0);
        lblId.setText("ID:");
        this.txtID = new Text((Composite)applicationGroup, 2048);
        this.txtID.setMessage("com.mycom.app");
        this.txtID.addModifyListener((ModifyListener)this.propertyModifyListener);
        this.txtID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createWorkingSetGroup();
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        Dialog.applyDialogFont((Control)this.getControl());
    }

    protected boolean validatePage() {
        boolean superValidate = super.validatePage();
        if (!superValidate || this.txtID == null || this.txtName == null) {
            return superValidate;
        }
        if (!this.propertyModifyListener.isNameOrIDChanged()) {
            String id = HybridProjectConventions.generateProjectID((String)this.getProjectName());
            String name = HybridProjectConventions.generateApplicationName((String)this.getProjectName());
            this.propertyModifyListener.setSkipValidation(true);
            if (id != null) {
                this.txtID.setText(id);
            }
            this.txtName.setText(name);
            this.propertyModifyListener.setSkipValidation(false);
        }
        IStatus status1 = HybridProjectConventions.validateApplicationName((String)this.txtName.getText());
        IStatus status2 = HybridProjectConventions.validateProjectID((String)this.txtID.getText());
        IStatus status = null;
        if (status1.matches(4)) {
            status = status1;
        }
        if (status2.matches(4)) {
            status = status2;
        }
        if (status1.matches(2)) {
            status = status1;
        }
        if (status2.matches(2)) {
            status = status2;
        }
        if (status == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        if (status.getSeverity() == 4) {
            this.setMessage(status.getMessage(), 3);
            return false;
        }
        if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.getContainer().updateMessage();
            return true;
        }
        return true;
    }

    private void createWorkingSetGroup() {
        String[] workingSetIds = new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.wst.jsdt.ui.JavaWorkingSetPage"};
        this.workingSetGroup = new WorkingSetGroup((Composite)this.getControl(), this.currentSelection, workingSetIds);
    }

    public String getApplicationName() {
        return this.txtName.getText();
    }

    public String getApplicationID() {
        return this.txtID.getText();
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.workingSetGroup.getSelectedWorkingSets();
    }

    class PropertyModifyListener
    implements ModifyListener {
        private boolean skipValidation = false;
        private boolean changed = false;

        PropertyModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!this.skipValidation) {
                if (!(this.changed || e.widget != WizardNewHybridProjectCreationPage.this.txtID && e.widget != WizardNewHybridProjectCreationPage.this.txtName)) {
                    this.changed = true;
                }
                WizardNewHybridProjectCreationPage.this.setPageComplete(WizardNewHybridProjectCreationPage.this.validatePage());
            }
        }

        public void setSkipValidation(boolean skipValidation) {
            this.skipValidation = skipValidation;
        }

        public boolean isNameOrIDChanged() {
            return this.changed;
        }
    }
}

