/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.internal.core;

public class Version
implements Comparable<Version> {
    public static final Version UNKNOWN = new Version(-1, -1, -1, null);
    private int major;
    private int minor;
    private int build;
    private String fullVersion;

    private Version(int major, int minor, int build, String fullVersion) {
        this.major = major;
        this.minor = minor;
        this.build = build;
        this.fullVersion = fullVersion;
    }

    public String getName() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    public String toString() {
        return this.fullVersion;
    }

    @Override
    public int compareTo(Version v) {
        if (this.getMajor() < v.getMajor()) {
            return -1;
        }
        if (this.getMajor() > v.getMajor()) {
            return 1;
        }
        if (this.getMinor() != -1 && v.getMinor() != -1) {
            if (this.getMinor() < v.getMinor()) {
                return -1;
            }
            if (this.getMinor() > v.getMinor()) {
                return 1;
            }
        }
        if (this.getBuild() != -1 && v.getBuild() != -1) {
            if (this.getBuild() < v.getBuild()) {
                return -1;
            }
            if (this.getBuild() > v.getBuild()) {
                return 1;
            }
        }
        return 0;
    }

    public static Version byName(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        return Version.parse(name);
    }

    private static Version parse(String name) {
        String toParse = name.trim();
        if (name.equals("*")) {
            return UNKNOWN;
        }
        if (toParse.startsWith("v") || toParse.startsWith("V")) {
            toParse = toParse.substring(1);
        }
        String[] segments = toParse.split("\\.");
        int[] result = new int[4];
        int i = 0;
        while (i < result.length) {
            if (segments.length > i) {
                if (segments[i].equalsIgnoreCase("x")) {
                    result[i] = 9999999;
                } else if (segments[i].equalsIgnoreCase("*")) {
                    result[i] = -1;
                } else {
                    try {
                        result[i] = Integer.valueOf(segments[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        result[i] = -1;
                    }
                }
            } else {
                result[i] = 0;
            }
            ++i;
        }
        return new Version(result[0], result[1], result[2], name);
    }
}

