/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.internal.core.vstudio;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.thym.wp.core.WPCore;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class WPProjectUtils {
    public static final String CSPROJ_EXTENSION = ".csproj";
    public static final String SLN_EXTENSION = ".sln";
    public static final String WP8 = "wp8";
    public static final String BIN = "Bin";
    public static final String DEBUG = "Debug";
    public static final String RELEASE = "Release";

    public static File getPlatformWWWDirectory(File projectRoot) {
        return new File(projectRoot, "www");
    }

    public static File getCsrojFile(File projectRoot) {
        File[] csprojFiles = projectRoot.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(WPProjectUtils.CSPROJ_EXTENSION);
            }
        });
        return csprojFiles != null && csprojFiles.length > 0 ? csprojFiles[0] : null;
    }

    public static Document readXML(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(file.getAbsolutePath());
        }
        catch (ParserConfigurationException e) {
            WPCore.log(4, "error during XML file parsing", e);
        }
        catch (SAXException e) {
            WPCore.log(4, "error during XML file parsing", e);
        }
        catch (IOException e) {
            WPCore.log(4, "error during XML file parsing", e);
        }
        return null;
    }

    public static void writeXML(File file, Document doc) {
        try {
            StreamResult result = new StreamResult(file);
            DOMSource source = new DOMSource(doc);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            xformer.transform(source, result);
        }
        catch (TransformerFactoryConfigurationError e) {
            WPCore.log(4, "error during XML file writing", e);
        }
        catch (TransformerException e) {
            WPCore.log(4, "error during XML file writing", e);
        }
    }
}

