/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CalledStringFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.Messages;

public final class CalledFunctionFactory {
    private static final String SEPARATOR = ": ";
    private static final String ERROR_MSG = "Cannot create a called function of type : ";

    private CalledFunctionFactory() {
    }

    public static AbstractCalledFunction create(long start, long end, int depth, Object stateValue, int processId, @Nullable ICalledFunction parent) {
        if (stateValue instanceof Integer) {
            return CalledFunctionFactory.create(start, end, depth, ((Integer)stateValue).intValue(), processId, parent);
        }
        if (stateValue instanceof Long) {
            return CalledFunctionFactory.create(start, end, depth, (Long)stateValue, processId, parent);
        }
        if (stateValue instanceof String) {
            return CalledFunctionFactory.create(start, end, depth, (String)stateValue, processId, parent);
        }
        throw new IllegalArgumentException(ERROR_MSG + String.valueOf(stateValue.getClass()) + SEPARATOR + stateValue.toString());
    }

    private static CalledFunction create(long start, long end, int depth, long value, int processId, @Nullable ICalledFunction parent) {
        if (start > end) {
            throw new IllegalArgumentException(Messages.TimeError + "[" + start + "," + end + "]");
        }
        return new CalledFunction(start, end, value, depth, processId, parent);
    }

    public static CalledStringFunction create(long start, long end, int depth, String value, int processId, @Nullable ICalledFunction parent) {
        if (start > end) {
            throw new IllegalArgumentException(Messages.TimeError + "[" + start + "," + end + "]");
        }
        return new CalledStringFunction(start, end, value, depth, processId, parent);
    }
}

