/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpoints;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractAllBreakpointEnablement;
import org.eclipse.jface.action.IAction;

public class DisableAllBreakpointsAction
extends AbstractAllBreakpointEnablement
implements IBreakpointsListener {
    @Override
    protected boolean isEnabled() {
        IBreakpoint[] breakpoints = this.getBreakpoints();
        if (breakpoints.length == 1) {
            return false;
        }
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            try {
                if (bp.isEnabled()) {
                    return true;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            ++n2;
        }
        return false;
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        this.update();
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.update();
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.getAction() != null) {
            this.update();
        }
    }

    @Override
    protected void initialize() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    @Override
    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        super.dispose();
    }

    @Override
    public void run(IAction action) {
        this.updateBreakpoints(false);
    }
}

