/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.properties.EnumeratedStringPropertyDescriptor;
import org.eclipse.wst.xml.ui.internal.tabletree.DOMPropertyDescriptorFactory;
import org.eclipse.wst.xml.ui.internal.tabletree.TreeContentHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLTableTreePropertyDescriptorFactory
extends DOMPropertyDescriptorFactory {
    protected TreeContentHelper treeContentHelper = new TreeContentHelper();

    protected IPropertyDescriptor createPropertyDescriptorHelper(String name, Element element, CMNode cmNode) {
        Object result = null;
        ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        String[] valuesArray = null;
        if (mq != null) {
            valuesArray = mq.getPossibleDataTypeValues(element, cmNode);
        }
        result = valuesArray != null && valuesArray.length > 0 ? new EnumeratedStringPropertyDescriptor(name, name, valuesArray) : this.createDefaultPropertyDescriptor(name);
        return result;
    }

    @Override
    public IPropertyDescriptor createTextPropertyDescriptor(Text text) {
        TextPropertyDescriptor result = null;
        Node parentNode = text.getParentNode();
        if (parentNode != null && parentNode.getNodeType() == 1) {
            Element parentElement = (Element)parentNode;
            ModelQuery mq = ModelQueryUtil.getModelQuery((Document)text.getOwnerDocument());
            CMElementDeclaration ed = null;
            if (mq != null) {
                ed = mq.getCMElementDeclaration(parentElement);
            }
            result = ed != null ? this.createPropertyDescriptorHelper("hack", parentElement, (CMNode)ed) : this.createDefaultPropertyDescriptor(parentElement.getNodeName());
        }
        if (result == null) {
            result = new TextPropertyDescriptor((Object)"hack", "hack");
        }
        return result;
    }

    @Override
    public IPropertyDescriptor createAttributePropertyDescriptor(Attr attr) {
        IPropertyDescriptor result = null;
        String attributeName = attr.getName();
        ModelQuery mq = ModelQueryUtil.getModelQuery((Document)attr.getOwnerDocument());
        CMAttributeDeclaration ad = null;
        if (mq != null) {
            ad = mq.getCMAttributeDeclaration(attr);
        }
        if (ad != null) {
            result = this.createPropertyDescriptorHelper(attributeName, attr.getOwnerElement(), (CMNode)ad);
        }
        if (result == null) {
            result = new TextPropertyDescriptor((Object)attributeName, attributeName);
        }
        return result;
    }

    @Override
    public IPropertyDescriptor createElementPropertyDescriptor(Element element) {
        Text text;
        TextPropertyDescriptor result = null;
        List list = this.treeContentHelper.getElementTextContent(element);
        if (list != null && (text = this.treeContentHelper.getEffectiveTextNodeForCombinedNodeList(list)) != null) {
            result = this.createTextPropertyDescriptor(text);
        }
        if (result == null) {
            result = new TextPropertyDescriptor((Object)"hack", "hack");
        }
        return result;
    }
}

