/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ArchiveUtil;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipEntry;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipFile;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;

public class GzipLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private final GzipFile fFile;
    private final GzipEntry root = new GzipEntry();
    private final GzipEntry fEntry;

    public GzipLeveledStructureProvider(GzipFile sourceFile) {
        this.fFile = sourceFile;
        this.fEntry = sourceFile.entries().nextElement();
    }

    public List getChildren(Object element) {
        ArrayList<GzipEntry> children = new ArrayList<GzipEntry>();
        if (element == this.root) {
            children.add(this.fEntry);
        }
        return children;
    }

    public InputStream getContents(Object element) {
        return this.fFile.getInputStream((GzipEntry)element);
    }

    public String getFullPath(Object element) {
        String name = ((GzipEntry)element).getName();
        return ArchiveUtil.toValidNamesPath(name).toOSString();
    }

    public String getLabel(Object element) {
        if (element != this.root && element != this.fEntry) {
            throw new IllegalArgumentException();
        }
        String name = ((GzipEntry)element).getName();
        if (element.equals(this.root)) {
            return name;
        }
        return ArchiveUtil.toValidNamesPath(name).lastSegment();
    }

    public GzipEntry getRoot() {
        return this.root;
    }

    public boolean closeArchive() {
        try {
            this.fFile.close();
        }
        catch (IOException e) {
            Activator.getDefault().logError(String.valueOf(DataTransferMessages.ZipImport_couldNotClose) + this.fFile.getName(), e);
            return false;
        }
        return true;
    }

    public boolean isFolder(Object element) {
        return ((GzipEntry)element).getFileType() == 53;
    }

    public void setStrip(int level) {
    }

    public int getStrip() {
        return 0;
    }
}

