/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.dialog.ui;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.ErrorDialog;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.InfoDialog;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.OptionsDialog;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.WarningDialog;

public class MessageDialog
extends Dialog {
    protected Composite parent;
    protected static final int LIST_ITEM_COUNT = 7;
    protected Button detailsButton;
    protected String title;
    protected String message;
    protected org.eclipse.swt.widgets.List list;
    protected Text details;
    protected boolean listCreated = false;
    protected boolean detailsCreated = false;
    protected int displayMask = 65535;
    protected IStatus status;
    private Point savedSize = null;
    protected List statusList;

    public MessageDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
        super(parentShell);
        this.title = dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle;
        this.message = message == null ? status.getMessage() : JFaceResources.format((String)"Reason", (Object[])new Object[]{message, status.getMessage()});
        this.status = status;
        this.statusList = Arrays.asList(status.getChildren());
        this.displayMask = displayMask;
        this.setShellStyle(67696);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.status.isMultiStatus() || this.status.getException() != null) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
        parent.setLayoutData((Object)new GridData(768));
    }

    protected Image getDialogImage() {
        return PlatformUI.getWorkbench().getDisplay().getSystemImage(2);
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite imageAndLabel = new Composite(composite, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        imageAndLabel.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(768));
        Image image = this.getDialogImage();
        if (image != null) {
            Label label = new Label(imageAndLabel, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        if (this.message != null) {
            Text text = new Text(imageAndLabel, 72);
            text.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            text.setLayoutData((Object)data);
            text.setFont(parent.getFont());
        }
        return composite;
    }

    protected org.eclipse.swt.widgets.List createDropDownList(Composite parent) {
        this.list = new org.eclipse.swt.widgets.List(parent, 2816);
        this.populateList(this.list);
        GridData data = new GridData(1808);
        data.heightHint = this.list.getItemHeight() * 7;
        this.list.setLayoutData((Object)data);
        this.listCreated = true;
        return this.list;
    }

    protected Text createDropDownDetails(Composite parent) {
        this.details = new Text(parent, 2824);
        Color color = new Color((Device)parent.getShell().getDisplay(), 255, 255, 255);
        this.details.setBackground(color);
        this.populateDetails(this.details, this.status, 0);
        GridData data = new GridData(1808);
        this.details.setLayoutData((Object)data);
        this.details.setSelection(0);
        this.detailsCreated = true;
        return this.details;
    }

    public int open() {
        if (MessageDialog.shouldDisplay(this.status, this.displayMask)) {
            return super.open();
        }
        return 0;
    }

    public static int openMessage(Shell parent, String dialogTitle, String message, IStatus status) {
        switch (status.getSeverity()) {
            case 1: {
                return MessageDialog.openInfo(parent, dialogTitle, message, status, 7);
            }
            case 2: {
                return MessageDialog.openWarning(parent, dialogTitle, message, status, 7);
            }
        }
        return MessageDialog.openError(parent, dialogTitle, message, status, 7);
    }

    public static int openMessage(Shell parent, String dialogTitle, String message, IStatus status, Choice[] options) {
        return MessageDialog.openOptions(parent, dialogTitle, message, status, 7, options);
    }

    public static int openError(Shell parentShell, String title, String message, IStatus status, int displayMask) {
        ErrorDialog dialog = new ErrorDialog(parentShell, title, message, status, displayMask);
        return dialog.open();
    }

    public static int openInfo(Shell parentShell, String title, String message, IStatus status, int displayMask) {
        InfoDialog dialog = new InfoDialog(parentShell, title, message, status, displayMask);
        return dialog.open();
    }

    public static int openWarning(Shell parentShell, String title, String message, IStatus status, int displayMask) {
        WarningDialog dialog = new WarningDialog(parentShell, title, message, status, displayMask);
        return dialog.open();
    }

    public static int openOptions(Shell parentShell, String title, String message, IStatus status, int displayMask, Choice[] options) {
        OptionsDialog dialog = new OptionsDialog(parentShell, title, message, status, displayMask, options);
        dialog.open();
        return dialog.getReturnCode();
    }

    private void populateList(org.eclipse.swt.widgets.List list) {
        for (IStatus childStatus : this.statusList) {
            this.populateList(list, childStatus, 0);
        }
    }

    private void populateList(org.eclipse.swt.widgets.List list, IStatus status, int nesting) {
        if (!status.matches(this.displayMask)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < nesting) {
            sb.append("  ");
            ++i;
        }
        sb.append(status.getMessage());
        list.add(sb.toString());
        IStatus[] children = status.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.populateList(list, children[i2], nesting + 1);
            ++i2;
        }
    }

    private void populateDetails(Text text, IStatus status, int nesting) {
        if (!status.matches(this.displayMask)) {
            return;
        }
        String tabChars = this.repeat(' ', nesting * 2);
        String messageLine = String.valueOf(tabChars) + status.getMessage() + System.getProperty("line.separator");
        Throwable except = status.getException();
        text.append(messageLine);
        if (except != null) {
            String[] trace = this.getStackTrace(except);
            int index = 0;
            while (index < trace.length) {
                text.append(String.valueOf(tabChars) + "    " + trace[index] + System.getProperty("line.separator"));
                ++index;
            }
        }
        IStatus[] children = status.getChildren();
        int i = 0;
        while (i < children.length) {
            this.populateDetails(text, children[i], nesting + 1);
            ++i;
        }
    }

    protected static boolean shouldDisplay(IStatus status, int mask) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return status.matches(mask);
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].matches(mask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        int newHeight = -1;
        if (this.detailsCreated) {
            this.details.dispose();
            this.detailsCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
            this.getContents().computeSize(-1, -1);
            newHeight = this.savedSize.y;
        } else {
            if (this.savedSize == null) {
                this.savedSize = windowSize;
            }
            this.details = this.createDropDownDetails((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            newHeight = this.getContents().computeSize((int)-1, (int)-1).y;
        }
        newHeight = newHeight > 400 ? 400 : newHeight;
        this.getShell().setSize(new Point(windowSize.x, newHeight));
    }

    private String[] getStackTrace(Throwable exc) {
        Vector<String> lines = new Vector<String>();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exc.printStackTrace(printWriter);
        try {
            printWriter.close();
            stringWriter.close();
        }
        catch (Exception exception) {
            return new String[0];
        }
        StringReader stringReader = new StringReader(stringWriter.toString());
        BufferedReader reader = new BufferedReader(stringReader);
        String line = null;
        try {
            line = reader.readLine();
            while (line != null) {
                lines.add(line.trim());
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            return new String[0];
        }
        return lines.toArray(new String[0]);
    }

    private String repeat(char the_char, int count) {
        StringBuffer buf = new StringBuffer(count);
        int index = 0;
        while (index < count) {
            buf.append(the_char);
            ++index;
        }
        return buf.toString();
    }
}

