/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceLoggerComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class ChangeLoggerStateHandler
extends BaseControlViewHandler {
    protected Parameter fParam;

    protected abstract TraceEnablement getNewState();

    protected abstract void changeState(TraceDomainComponent var1, List<String> var2, ITraceLogLevel var3, LogLevelType var4, IProgressMonitor var5) throws ExecutionException;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            final Parameter param = new Parameter(this.fParam);
            Job job = new Job(Messages.TraceControl_ChangeLoggerStateJob){

                protected IStatus run(IProgressMonitor monitor) {
                    ExecutionException error = null;
                    TraceSessionComponent session = null;
                    try {
                        if (param.getLoggers() != null) {
                            session = param.getDomain().getSession();
                            ArrayList<String> loggerNames = new ArrayList<String>();
                            List<TraceLoggerComponent> loggers = param.getLoggers();
                            for (TraceLoggerComponent logger : loggers) {
                                if ("*".equals(logger.getName())) {
                                    ChangeLoggerStateHandler.this.changeState(param.getDomain(), null, param.getLogLevel(), param.getLogLevelType(), monitor);
                                    continue;
                                }
                                loggerNames.add(logger.getName());
                            }
                            if (!loggerNames.isEmpty()) {
                                ChangeLoggerStateHandler.this.changeState(param.getDomain(), loggerNames, param.getLogLevel(), param.getLogLevelType(), monitor);
                            }
                            for (TraceLoggerComponent logger : loggers) {
                                logger.setState(ChangeLoggerStateHandler.this.getNewState());
                            }
                        }
                    }
                    catch (ExecutionException e) {
                        error = e;
                    }
                    if (session != null) {
                        session.fireComponentChanged(session);
                    }
                    if (error != null) {
                        return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_ChangeLoggerStateFailure, (Throwable)error);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        TraceDomainComponent domain = null;
        ITraceLogLevel logLevel = null;
        LogLevelType logLevelType = null;
        ArrayList<TraceLoggerComponent> loggers = new ArrayList<TraceLoggerComponent>();
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            String sessionName = null;
            String domainName = null;
            for (Object element : structered) {
                if (!(element instanceof TraceLoggerComponent)) continue;
                TraceLoggerComponent logger = (TraceLoggerComponent)element;
                if (logger.getName().equals("*") && !logger.getTargetNode().isVersionSupported("2.8.1")) {
                    return false;
                }
                if (sessionName == null) {
                    sessionName = String.valueOf(logger.getSessionName());
                }
                if (domain == null) {
                    domain = (TraceDomainComponent)logger.getParent();
                }
                if (domainName == null) {
                    domainName = logger.getDomain().name();
                }
                if (logLevel == null) {
                    logLevel = logger.getLogLevel();
                }
                if (logLevelType == null) {
                    logLevelType = logger.getLogLevelType();
                }
                if (!sessionName.equals(logger.getSessionName()) || !domain.getName().equalsIgnoreCase(logger.getDomain().name())) {
                    loggers.clear();
                    break;
                }
                if (!logLevel.equals(logger.getLogLevel()) || !logLevelType.equals((Object)logger.getLogLevelType())) {
                    loggers.clear();
                    break;
                }
                if (logger.getState() == this.getNewState()) continue;
                loggers.add(logger);
            }
        }
        boolean isEnabled = !loggers.isEmpty();
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new Parameter(domain, loggers, logLevel, logLevelType);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    protected static class Parameter {
        private final TraceDomainComponent fDomain;
        private final List<TraceLoggerComponent> fLoggers = new ArrayList<TraceLoggerComponent>();
        private final ITraceLogLevel fLogLevel;
        private final LogLevelType fLogLevelType;

        public Parameter(TraceDomainComponent domain, List<TraceLoggerComponent> loggers, ITraceLogLevel logLevel, LogLevelType logLevelType) {
            this.fDomain = domain;
            this.fLoggers.addAll(loggers);
            this.fLogLevel = logLevel;
            this.fLogLevelType = logLevelType;
        }

        public Parameter(Parameter other) {
            this(other.fDomain, other.fLoggers, other.fLogLevel, other.fLogLevelType);
        }

        public TraceDomainComponent getDomain() {
            return this.fDomain;
        }

        public List<TraceLoggerComponent> getLoggers() {
            return this.fLoggers;
        }

        public LogLevelType getLogLevelType() {
            return this.fLogLevelType;
        }

        public ITraceLogLevel getLogLevel() {
            return this.fLogLevel;
        }
    }
}

