/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.cep.tooling.ui.builder;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ViatraCepProjectBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 9 || kind == 10) {
            ChangeDetector visitor = new ChangeDetector(this.getProject().getFullPath());
            this.getDelta(this.getProject()).accept((IResourceDeltaVisitor)visitor);
            if (visitor.isChangeFound()) {
                this.getProject().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        String extension = resource.getFileExtension();
                        if ("vepl".equals(extension)) {
                            resource.touch((IProgressMonitor)new NullProgressMonitor());
                        }
                        return false;
                    }
                });
            }
        }
        return new IProject[0];
    }

    private static final class ChangeDetector
    implements IResourceDeltaVisitor {
        private final IPath path;
        private boolean changeFound = false;

        public ChangeDetector(IPath path) {
            this.path = path;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.path.equals((Object)delta.getFullPath())) {
                this.changeFound = true;
            }
            return !this.changeFound;
        }

        public boolean isChangeFound() {
            return this.changeFound;
        }
    }
}

