/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.cep.tooling.ui.wizards;

import com.google.inject.Inject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.viatra.cep.tooling.ui.internal.Activator;
import org.eclipse.viatra.cep.tooling.ui.wizards.NewVeplFileWizardContainerConfigurationPage;
import org.eclipse.viatra.cep.vepl.vepl.EventModel;
import org.eclipse.viatra.cep.vepl.vepl.VeplFactory;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class NewVeplFileWizard
extends Wizard
implements INewWizard {
    private static final String NEW_VEPL_FILE = "Create a new VEPL file.";
    private NewVeplFileWizardContainerConfigurationPage page1;
    private ISelection selection;
    private IWorkbench workbench;
    private final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    private IPath filePath;
    @Inject
    private IResourceSetProvider resourceSetProvider;

    public NewVeplFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page1 = new NewVeplFileWizardContainerConfigurationPage();
        this.page1.init((IStructuredSelection)this.selection);
        this.page1.setDescription(NEW_VEPL_FILE);
        this.addPage((IWizardPage)this.page1);
        this.setForcePreviousAndNextButtons(false);
    }

    private String getFileNameWithExtension(String originalFileName) {
        if (originalFileName.endsWith(".vepl")) {
            return originalFileName;
        }
        return originalFileName.concat(".vepl");
    }

    public boolean performFinish() {
        final String containerName = this.page1.getContainerName();
        final String fileName = this.getFileNameWithExtension(this.page1.getFileName());
        final String packageName = this.page1.getPackageName().replaceAll("\\.", "/");
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask("Creating " + fileName, 1);
                        IFile file = NewVeplFileWizard.this.createVeplFile(containerName, fileName, packageName);
                        BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)NewVeplFileWizard.this.workbench.getActiveWorkbenchWindow());
                        IDE.openEditor((IWorkbenchPage)NewVeplFileWizard.this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            Activator.getDefault().logException("Cannot create VEPL file: " + realException.getMessage(), realException);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private IFile createVeplFile(String containerName, String fileName, String packageName) throws IOException, CoreException {
        IResource containerResource = this.root.findMember((IPath)new Path(containerName));
        ResourceSet resourceSet = this.resourceSetProvider.get(containerResource.getProject());
        this.filePath = containerResource.getFullPath().append(String.valueOf(packageName) + "/" + fileName);
        IFile file = this.root.getFile(this.filePath);
        String fullPath = this.filePath.toString();
        URI fileURI = URI.createPlatformResourceURI((String)fullPath, (boolean)false);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)this.getDefaultEventModel(packageName));
        resource.save(Collections.EMPTY_MAP);
        containerResource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return file;
    }

    private EventModel getDefaultEventModel(String packageName) {
        EventModel eventModel = VeplFactory.eINSTANCE.createEventModel();
        eventModel.setName(packageName.replaceAll("/", "\\."));
        return eventModel;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
    }
}

