/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.viatra2.EclipseExtensionProvider;
import org.eclipse.viatra2.GeneralCodeoutFactory;
import org.eclipse.viatra2.GeneralInterpreterFactory;
import org.eclipse.viatra2.GeneralLoaderFactory;
import org.eclipse.viatra2.GeneralNativeImporterFactory;
import org.eclipse.viatra2.codegen.CodeOutputPluginFactory;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.properties.IViatraPropertyProvider;
import org.eclipse.viatra2.imports.NativeImporterFactory;
import org.eclipse.viatra2.interpreters.ModelInterpreterFactory;
import org.eclipse.viatra2.loaders.LoaderFactory;
import org.eclipse.viatra2.logger.EclipseLogger;
import org.eclipse.viatra2.logger.Logger;
import org.eclipse.viatra2.logger.LoggerFactory;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViatraPlugin
extends AbstractUIPlugin {
    private static ViatraPlugin plugin;
    static final String import_ext_id = "org.eclipse.viatra2.core2.modelimport";
    static final String loader_ext_id = "org.eclipse.viatra2.core2.programloader";
    static final String native_ext_id = "org.eclipse.viatra2.core2.nativefunction";
    static final String codeout_ext_id = "org.eclipse.viatra2.core2.codeout";
    static final String logger_ext_id = "org.eclipse.viatra2.core2.logger";
    static final String interpreter_ext_id = "org.eclipse.viatra2.core2.interpreter";
    static final String properties_ext_id = "org.eclipse.viatra2.core2.properties";
    List<IViatraPropertyProvider> propProviders;
    public ILog log;
    List<NativeImporterFactory> nativeImporterPlugins;
    List<LoaderFactory> loaderPlugins;
    private BundleContext context;

    public ViatraPlugin() {
        plugin = this;
        FrameworkManager.getInstance().setExtensionProvider(new EclipseExtensionProvider());
    }

    private List<IViatraPropertyProvider> initPropertyProviders() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint(properties_ext_id);
        ArrayList<IViatraPropertyProvider> r = new ArrayList<IViatraPropertyProvider>();
        if (poi == null) {
            return r;
        }
        IExtension[] exts = poi.getExtensions();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] el = exts[i].getConfigurationElements();
            int j = 0;
            while (j < el.length) {
                try {
                    Object o = el[j].createExecutableExtension("class");
                    if (o instanceof IViatraPropertyProvider) {
                        r.add((IViatraPropertyProvider)o);
                    }
                }
                catch (Exception exception) {}
                ++j;
            }
            ++i;
        }
        this.initPrefs(r);
        return r;
    }

    public List<IViatraPropertyProvider> getPropertyProviders() {
        if (this.propProviders == null) {
            this.propProviders = this.initPropertyProviders();
        }
        return this.propProviders;
    }

    private void initPrefs(List<IViatraPropertyProvider> providers) {
        IPreferenceStore prefs = ViatraPlugin.getDefault().getPreferenceStore();
        for (IViatraPropertyProvider p : providers) {
            for (String prop_id : p.getAllPropertyIds()) {
                if (prefs.contains(String.valueOf(p.getProviderID()) + "::" + prop_id)) continue;
                switch (p.getPropertyKind(prop_id)) {
                    case STRING: {
                        prefs.setDefault(String.valueOf(p.getProviderID()) + "::" + prop_id, p.getDefaultPropertyValue(prop_id));
                        break;
                    }
                    case INTEGER: {
                        prefs.setDefault(String.valueOf(p.getProviderID()) + "::" + prop_id, Integer.parseInt(p.getDefaultPropertyValue(prop_id)));
                        break;
                    }
                    case BOOLEAN: {
                        prefs.setDefault(String.valueOf(p.getProviderID()) + "::" + prop_id, Boolean.parseBoolean(p.getDefaultPropertyValue(prop_id)));
                        break;
                    }
                    case PATH: {
                        prefs.setDefault(String.valueOf(p.getProviderID()) + "::" + prop_id, p.getDefaultPropertyValue(prop_id));
                    }
                }
            }
        }
    }

    public List<ASMNativeFunction> initNativeFunctionPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint(native_ext_id);
        ArrayList<ASMNativeFunction> ret = new ArrayList<ASMNativeFunction>();
        if (poi == null) {
            return ret;
        }
        IExtension[] exts = poi.getExtensions();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] el = exts[i].getConfigurationElements();
            int j = 0;
            while (j < el.length) {
                try {
                    Object o = el[j].createExecutableExtension("class");
                    if (o instanceof ASMNativeFunction) {
                        ret.add((ASMNativeFunction)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public Vector<LoaderFactory> initLoaderPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint(loader_ext_id);
        Vector<LoaderFactory> v = new Vector<LoaderFactory>();
        if (poi == null) {
            return v;
        }
        IExtension[] exts = poi.getExtensions();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] el = exts[i].getConfigurationElements();
            int j = 0;
            while (j < el.length) {
                try {
                    String name = el[j].getAttribute("name");
                    String id = el[j].getAttribute("id");
                    String fileExtensionList = el[j].getAttribute("fileExtensionList");
                    String[] list = new String[]{};
                    try {
                        StringTokenizer tok = new StringTokenizer(fileExtensionList, ",");
                        list = new String[tok.countTokens()];
                        int k = 0;
                        while (k < list.length) {
                            list[k] = tok.nextToken();
                            ++k;
                        }
                    }
                    catch (Exception exception) {}
                    GeneralLoaderFactory fact = new GeneralLoaderFactory(id, name, el[j], list);
                    v.add(fact);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public Vector<NativeImporterFactory> initModelImportPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint(import_ext_id);
        Vector<NativeImporterFactory> v = new Vector<NativeImporterFactory>();
        if (poi == null) {
            return v;
        }
        IExtension[] exts = poi.getExtensions();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] el = exts[i].getConfigurationElements();
            int j = 0;
            while (j < el.length) {
                try {
                    String name = el[j].getAttribute("name");
                    String id = el[j].getAttribute("id");
                    String fileExtensionList = el[j].getAttribute("fileExtensionList");
                    String[] list = new String[]{};
                    try {
                        StringTokenizer tok = new StringTokenizer(fileExtensionList, ",");
                        list = new String[tok.countTokens()];
                        int k = 0;
                        while (k < list.length) {
                            list[k] = tok.nextToken();
                            ++k;
                        }
                    }
                    catch (Exception exception) {}
                    GeneralNativeImporterFactory fact = new GeneralNativeImporterFactory(id, name, el[j], list);
                    v.add(fact);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public Vector<CodeOutputPluginFactory> initCodeOutPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint(codeout_ext_id);
        if (poi == null) {
            return new Vector<CodeOutputPluginFactory>();
        }
        IExtension[] exts = poi.getExtensions();
        Vector<CodeOutputPluginFactory> v = new Vector<CodeOutputPluginFactory>();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] el = exts[i].getConfigurationElements();
            int j = 0;
            while (j < el.length) {
                try {
                    String id = el[j].getAttribute("id");
                    String name = el[j].getAttribute("name");
                    GeneralCodeoutFactory fact = new GeneralCodeoutFactory(id, name, el[j]);
                    v.add(fact);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public Vector<LoggerFactory> initLoggerPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint(logger_ext_id);
        if (poi == null) {
            return new Vector<LoggerFactory>();
        }
        IExtension[] exts = poi.getExtensions();
        Vector<LoggerFactory> v = new Vector<LoggerFactory>();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] el = exts[i].getConfigurationElements();
            int j = 0;
            while (j < el.length) {
                try {
                    LoggerFactory o = (LoggerFactory)el[j].createExecutableExtension("class");
                    v.add(o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public Vector<ModelInterpreterFactory> initInterpreterPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint(interpreter_ext_id);
        if (poi == null) {
            return new Vector<ModelInterpreterFactory>();
        }
        IExtension[] exts = poi.getExtensions();
        Vector<ModelInterpreterFactory> v = new Vector<ModelInterpreterFactory>();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] el = exts[i].getConfigurationElements();
            int j = 0;
            while (j < el.length) {
                try {
                    GeneralInterpreterFactory o = new GeneralInterpreterFactory(el[j]);
                    v.add(o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
        this.log = Platform.getLog((Bundle)context.getBundle());
        try {
            this.nativeImporterPlugins = this.initModelImportPlugins();
            this.loaderPlugins = this.initLoaderPlugins();
        }
        catch (Exception e) {
            this.logError("error : " + e.getLocalizedMessage());
        }
    }

    public NativeImporterFactory[] getImporterPlugins() {
        return this.nativeImporterPlugins.toArray(new NativeImporterFactory[0]);
    }

    public LoaderFactory[] getLoaderPlugins() {
        return this.loaderPlugins.toArray(new LoaderFactory[0]);
    }

    public void logError(String s) {
        Status st = new Status(4, "ViatraCore", 1, s, null);
        this.log.log((IStatus)st);
    }

    public void logInfo(String s) {
        Status st = new Status(1, "ViatraCore", 1, s, null);
        this.log.log((IStatus)st);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static ViatraPlugin getDefault() {
        return plugin;
    }

    public Logger getEclipseLogger() {
        ILog elog = ViatraPlugin.getDefault().log;
        EclipseLogger eclLogger = new EclipseLogger(elog);
        eclLogger.init(null);
        return eclLogger;
    }

    public BundleContext getContext() {
        return this.context;
    }
}

