/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.codegen;

import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.viatra2.codegen.CodeOutputPlugin;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.logger.Logger;

public class FileCodeFormatter
implements CodeOutputPlugin {
    Logger log;
    PrintStream codeout = System.out;
    boolean inFile = false;
    boolean printLN = true;

    public void init(IFramework fw) {
        this.log = fw.getLogger();
        this.log.debug("File-based code formatter loaded.");
        String s = fw.getProperties().getRuntimeProperty("codeout", "file.autolinefeed");
        if (s != null) {
            this.printLN = s.toLowerCase().equals("yes");
        }
    }

    public void beginWork() {
        this.inFile = false;
    }

    public void endWork() {
        if (this.inFile) {
            this.codeout.flush();
            this.codeout.close();
        }
    }

    public void codeOut(String s) {
        if (this.inFile) {
            if (s.startsWith("//!!ENDFILE")) {
                this.inFile = false;
                this.codeout.close();
            } else if (this.printLN) {
                this.codeout.println(s);
            } else {
                this.codeout.print(s.replaceAll("\\\\n", "\n"));
            }
        } else if (s.startsWith("//!!FILE=")) {
            String s2 = s.substring(9);
            try {
                this.codeout = new PrintStream(new FileOutputStream(s2, false), true);
                this.inFile = true;
            }
            catch (Exception e) {
                this.log.error("File " + s2 + " cannot be created for code output. Reason: " + e.getMessage());
            }
        }
    }
}

