/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.copier;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.viatra2.copier.ModelCopyException;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCopy {
    Map<IModelElement, IModelElement> remap;
    Set<IModelElement> toCopy;
    TreeMap<IModelElement, IModelElement> src2tg = new TreeMap();
    IModelSpace targetModel;
    IModelSpace sourceModel;
    IModelManager tModelManager;

    public static void copyModel(IModelSpace sourceModel, IModelSpace targetModel, Set<IModelElement> toCopy, Map<IModelElement, IModelElement> remap) throws VPMCoreException, ModelCopyException {
        ModelCopy mc = new ModelCopy();
        mc._copyModel(sourceModel, targetModel, toCopy, remap);
    }

    public static IModelElement copyModel(IModelSpace sourceModel, IModelSpace targetModel, IModelElement root, IModelElement destinationContainer, boolean doOutEdges) throws VPMCoreException, ModelCopyException {
        TreeSet<IModelElement> elementsToCopy = new TreeSet<IModelElement>();
        ModelCopy.addModelElementAndChildren(root, root, elementsToCopy, doOutEdges);
        TreeMap<IModelElement, IModelElement> remap = new TreeMap<IModelElement, IModelElement>();
        remap.put(root.getNamespace(), destinationContainer);
        ModelCopy mc = new ModelCopy();
        mc._copyModel(sourceModel, targetModel, elementsToCopy, remap);
        IModelElement ret = mc.src2tg.get(root);
        return ret;
    }

    public static IModelElement copyModels(Set<IModelElement> elementsToCopy, IModelSpace sourceModel, IModelSpace targetModel, IModelElement root, IModelElement destinationContainer, boolean doOutEdges) throws VPMCoreException, ModelCopyException {
        TreeSet<IModelElement> _elementsToCopy = new TreeSet<IModelElement>();
        TreeMap<IModelElement, IModelElement> remap = new TreeMap<IModelElement, IModelElement>();
        for (IModelElement e : elementsToCopy) {
            ModelCopy.addModelElementAndChildren(e, e, _elementsToCopy, doOutEdges);
            remap.put(e.getNamespace(), destinationContainer);
        }
        remap.put(root.getNamespace(), destinationContainer);
        ModelCopy mc = new ModelCopy();
        mc._copyModel(sourceModel, targetModel, _elementsToCopy, remap);
        IModelElement ret = mc.src2tg.get(root);
        return ret;
    }

    private static void addModelElementAndChildren(IModelElement root, IModelElement me, TreeSet<IModelElement> elementsToCopy, boolean copyOutEdges) {
        elementsToCopy.add(me);
        for (IModelElement iModelElement : me.getElementsInNamespace()) {
            IRelation rel;
            IModelElement to;
            if (!copyOutEdges && iModelElement instanceof IRelation && !(to = (rel = (IRelation)iModelElement).getTo()).equals(root) && !to.isBelowNamespace(root)) continue;
            ModelCopy.addModelElementAndChildren(root, iModelElement, elementsToCopy, copyOutEdges);
        }
        if (copyOutEdges) {
            for (IModelElement iModelElement : me.getRelationsTo()) {
                elementsToCopy.add(iModelElement);
            }
        }
    }

    private void _copyModel(IModelSpace sourceModel, IModelSpace targetModel, Set<IModelElement> toCopy, Map<IModelElement, IModelElement> remap) throws VPMCoreException, ModelCopyException {
        this.remap = remap;
        this.toCopy = toCopy;
        this.targetModel = targetModel;
        this.sourceModel = sourceModel;
        this.tModelManager = targetModel.getModelManager();
        Set<IModelElement> roots = this.findRoots(toCopy);
        for (IModelElement root : roots) {
            this.createBranch(root);
        }
        this.setTargets();
        this.setTypes();
    }

    private void setTargets() throws VPMCoreException, ModelCopyException {
        for (IModelElement me : this.toCopy) {
            if (!(me instanceof IRelation)) continue;
            IRelation rel = (IRelation)me;
            IModelElement tg = this.targetOf(me);
            if (tg == null) continue;
            if (!(tg instanceof IRelation)) {
                this.addError("copy model internal error: target of a relation is not relaiton", me);
                continue;
            }
            IRelation tgRel = (IRelation)tg;
            IModelElement to = rel.getTo();
            IModelElement tgTo = this.targetOf(to);
            if (tgTo == null) {
                this.addError("target of relation has no map in target model", rel, to);
                continue;
            }
            this.tModelManager.setRelationTo(tgRel, tgTo);
            IRelation inverse = rel.getInverse();
            if (inverse == null) continue;
            IModelElement tgInverse = this.targetOf(inverse);
            if (tgInverse != null && tgInverse instanceof IRelation) {
                IRelation rTgInverse = (IRelation)tgInverse;
                this.tModelManager.setRelationInverse(tgRel, rTgInverse);
                continue;
            }
            this.addError("Inverse of relation is not mapped to a relation", rel, inverse);
        }
    }

    private void setTypes() throws VPMCoreException, ModelCopyException {
        for (IModelElement me : this.toCopy) {
            IModelElement tgType;
            IModelElement tg = this.targetOf(me);
            if (tg == null) continue;
            Collection<IModelElement> types = me.getTypes();
            for (IModelElement type : types) {
                tgType = this.targetOf(type);
                if (tgType != null) {
                    this.tModelManager.newInstanceOf(tgType, tg);
                    continue;
                }
                this.addError("Element in target model does not exist, when creating type", tg, type);
            }
            types = me.getSupertypes();
            for (IModelElement type : types) {
                tgType = this.targetOf(type);
                if (tgType != null) {
                    this.tModelManager.newSupertypeOf(tgType, tg);
                    continue;
                }
                this.addError("Element in target model does not exist, when creating supertype", tg, type);
            }
        }
    }

    private void createBranch(IModelElement me) throws VPMCoreException, ModelCopyException {
        IModelElement newPar;
        IModelElement par;
        if (!this.toCopy.contains(me)) {
            return;
        }
        IModelElement newMe = null;
        if (me instanceof IEntity) {
            IEntity ent = (IEntity)me;
            par = ent.getParent();
            newPar = this.targetOf(par);
            if (newPar != null && newPar instanceof IEntity) {
                IEntity eNewPar = (IEntity)newPar;
                newMe = this.tModelManager.newEntity(ent.getName(), ent.getValue(), eNewPar);
            } else {
                this.addError("Parent of copy root entity is not found in target model", ent);
            }
        } else {
            IRelation rel = (IRelation)me;
            par = rel.getFrom();
            newPar = this.targetOf(par);
            if (newPar != null) {
                newMe = this.tModelManager.newRelation(rel.getName(), newPar, newPar, rel.getMultiplicity(), rel.getIsAggregation(), null);
            } else {
                this.addError("Source of copy root relation is not found in target model", rel);
            }
        }
        if (newMe == null) {
            return;
        }
        this.addMapping(me, newMe);
        this.tModelManager.setViewInfo(newMe, me.getViewInfo());
        this.tModelManager.setIsFinalType(newMe, me.getIsFinalType());
        Collection<IModelElement> children = me.getElementsInNamespace();
        for (IModelElement child : children) {
            this.createBranch(child);
        }
    }

    private void addError(String msg, IModelElement cause, IModelElement cause2) throws ModelCopyException {
        System.out.println(String.valueOf(msg) + " " + cause.toString() + " " + cause2.toString());
    }

    private void addError(String msg, IModelElement cause) throws ModelCopyException {
        System.out.println(String.valueOf(msg) + " " + cause.toString());
    }

    private void addMapping(IModelElement source, IModelElement target) {
        this.src2tg.put(source, target);
    }

    private IModelElement targetOf(IModelElement source) {
        if (this.remap.containsKey(source)) {
            return this.remap.get(source);
        }
        IModelElement tg = this.src2tg.get(source);
        if (tg != null) {
            return tg;
        }
        if (this.targetModel.equals(this.sourceModel)) {
            return source;
        }
        tg = this.targetModel.getModelManager().getElementByName(source.getFullyQualifiedName());
        if (tg != null) {
            return tg;
        }
        return null;
    }

    private Set<IModelElement> findRoots(Set<IModelElement> toCopy) {
        TreeSet<IModelElement> ret = new TreeSet<IModelElement>();
        for (IModelElement me : toCopy) {
            IModelElement namespace = me.getNamespace();
            if (namespace == null) {
                ret.add(me);
                continue;
            }
            if (toCopy.contains(namespace)) continue;
            ret.add(me);
        }
        return ret;
    }
}

