/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.simple.SimpleModelElement;
import org.eclipse.viatra2.core.simple.SimpleModelSpace;
import org.eclipse.viatra2.core.simple.cache.TrickyCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleEntity
extends SimpleModelElement
implements IEntity {
    protected SimpleEntity parent = null;
    protected TreeMap<Long, IModelElement> containment = new TreeMap();
    protected String value = "";

    public SimpleEntity(long ID, SimpleModelSpace ms) {
        super(ID, ms);
    }

    @Override
    public String getValue() {
        try {
            this.modelSpace.lock.readLock().lock();
            String string = this.value;
            return string;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public IModelElement getContentByName(String n) {
        try {
            this.modelSpace.lock.readLock().lock();
            Long id = (Long)this.namespace.get(n);
            if (id != null) {
                IEntity me;
                IEntity iEntity = me = (IEntity)this.containment.get(id);
                return iEntity;
            }
            return null;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public IModelElement getContentByType(IModelElement n) {
        try {
            this.modelSpace.lock.readLock().lock();
            for (SimpleModelElement simpleModelElement : this.containment.values()) {
                if (!simpleModelElement.isInstanceOf(n)) continue;
                SimpleModelElement simpleModelElement2 = simpleModelElement;
                return simpleModelElement2;
            }
            return null;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getContents() {
        try {
            this.modelSpace.lock.readLock().lock();
            Collection<IModelElement> collection = this.containment.values();
            return collection;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getAllComponents() {
        return new TrickyCollection(null, this);
    }

    public Collection<IModelElement> _getAllComponents() {
        try {
            this.modelSpace.lock.readLock().lock();
            ArrayList<IModelElement> ret = new ArrayList<IModelElement>();
            ret.addAll(this.getContents());
            for (IModelElement elem : this.getContents()) {
                if (!(elem instanceof IEntity)) continue;
                SimpleEntity e = (SimpleEntity)elem;
                ret.addAll(e._getAllComponents());
            }
            ArrayList<IModelElement> arrayList = ret;
            return arrayList;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public IEntity getParent() {
        try {
            this.modelSpace.lock.readLock().lock();
            SimpleEntity simpleEntity = this.parent;
            return simpleEntity;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public String getFullyQualifiedName() {
        try {
            this.modelSpace.lock.readLock().lock();
            String name = this.getName();
            IEntity root = this.modelSpace.getModelManager().getRoot();
            if (root == this) {
                return "";
            }
            if (root != this.parent && this.parent != null) {
                name = String.valueOf(this.parent.getFullyQualifiedName()) + "." + name;
            }
            String string = name;
            return string;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public IModelElement getNamespace() {
        try {
            this.modelSpace.lock.readLock().lock();
            SimpleEntity simpleEntity = this.parent;
            return simpleEntity;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    @Override
    public boolean isRelation() {
        return false;
    }
}

