/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.constraint.EConstraint;
import org.eclipse.viatra2.core.simple.KeyedObject;
import org.eclipse.viatra2.core.simple.SimpleEntity;
import org.eclipse.viatra2.core.simple.SimpleModelSpace;
import org.eclipse.viatra2.core.simple.SmallTreeSet;
import org.eclipse.viatra2.core.simple.VPMCoreInternalRuntimeException;
import org.eclipse.viatra2.core.simple.tempdata.TemporaryData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleModelElement
implements KeyedObject,
IModelElement {
    long ID;
    protected TreeMap<Long, IRelation> relationsFrom;
    protected Set<IRelation> relationsTo;
    protected TreeMap<String, Long> namespace;
    String name = "";
    String viewInfo = null;
    boolean isFinalType = false;
    SimpleModelSpace modelSpace;
    protected Set<IModelElement> supertype = null;
    protected Set<IModelElement> type = null;
    protected Set<IModelElement> subtypes;
    protected Set<IModelElement> instances;
    protected TemporaryData<Set<IModelElement>> allInstances;
    protected TemporaryData<Set<IModelElement>> allTypes;
    protected TemporaryData<Set<IModelElement>> allSupertypes;
    protected TemporaryData<Set<IModelElement>> allSubtypes;
    protected List<ICoreNotificationListener> notificationListeners;
    public static final int KEY_ID = 0;
    public static final int KEY_NAME = 1;
    protected boolean isDeleted = false;

    @Override
    public boolean getIsFinalType() {
        return this.isFinalType;
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleModelElement) {
            return this.ID == ((SimpleModelElement)o).ID;
        }
        return false;
    }

    @Override
    public int compareTo(IModelElement o) {
        long diff = this.ID - ((SimpleModelElement)o).ID;
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    }

    @Override
    public Comparable<?> getKey(int nr) {
        switch (nr) {
            case 0: {
                return new Long(this.ID);
            }
            case 1: {
                return this.name;
            }
        }
        return null;
    }

    public SimpleModelElement(long _ID, SimpleModelSpace ms) {
        this.ID = _ID;
        this.modelSpace = ms;
        this.allInstances = this.modelSpace.tempFactory.create();
        this.allTypes = this.modelSpace.tempFactory.create();
        this.allSupertypes = this.modelSpace.tempFactory.create();
        this.allSubtypes = this.modelSpace.tempFactory.create();
        this.relationsFrom = new TreeMap();
        this.relationsTo = new SmallTreeSet<IRelation>();
        this.namespace = new TreeMap();
        this.supertype = new SmallTreeSet<IModelElement>();
        this.type = new SmallTreeSet<IModelElement>();
        this.subtypes = new SmallTreeSet<IModelElement>();
        this.instances = new SmallTreeSet<IModelElement>();
        this.notificationListeners = new ArrayList<ICoreNotificationListener>(0);
    }

    @Override
    public String getID() {
        try {
            this.modelSpace.lock.readLock().lock();
            String string = Long.toString(this.ID);
            return string;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    public Long getLongID() {
        try {
            this.modelSpace.lock.readLock().lock();
            Long l = new Long(this.ID);
            return l;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<IModelElement> getSupertypes() {
        try {
            this.modelSpace.lock.readLock().lock();
            Set<IModelElement> set = this.supertype;
            return set;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getTypes() {
        try {
            this.modelSpace.lock.readLock().lock();
            Set<IModelElement> set = this.type;
            return set;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getSubtypes() {
        try {
            this.modelSpace.lock.readLock().lock();
            Set<IModelElement> set = this.subtypes;
            return set;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getInstances() {
        try {
            this.modelSpace.lock.readLock().lock();
            Set<IModelElement> set = this.instances;
            return set;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public String toString() {
        return this.getFullyQualifiedName();
    }

    @Override
    public Collection<IModelElement> getAllSupertypes() {
        try {
            this.modelSpace.lock.readLock().lock();
            Set<IModelElement> retSet = this.allSupertypes.getObject(this.modelSpace.numberOfChanges);
            if (retSet != null) {
                Set<IModelElement> set = retSet;
                return set;
            }
            retSet = new TreeSet<IModelElement>();
            for (SimpleModelElement simpleModelElement : this.supertype) {
                retSet.add(simpleModelElement);
                retSet.addAll(simpleModelElement.getAllSupertypes());
            }
            this.allSupertypes.setObject(this.modelSpace.numberOfChanges, retSet);
            Set<IModelElement> set = retSet;
            return set;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getAllTypes() {
        try {
            this.modelSpace.lock.readLock().lock();
            Set<IModelElement> retSet = this.allTypes.getObject(this.modelSpace.numberOfChanges);
            if (retSet != null) {
                Set<IModelElement> set = retSet;
                return set;
            }
            retSet = new TreeSet<IModelElement>();
            for (SimpleModelElement simpleModelElement : this.type) {
                retSet.add(simpleModelElement);
                retSet.addAll(simpleModelElement.getAllSupertypes());
            }
            this.allTypes.setObject(this.modelSpace.numberOfChanges, retSet);
            Set<IModelElement> set = retSet;
            return set;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getAllSubtypes() {
        try {
            this.modelSpace.lock.readLock().lock();
            Set<IModelElement> retSet = this.allSubtypes.getObject(this.modelSpace.numberOfChanges);
            if (retSet != null) {
                Set<IModelElement> set = retSet;
                return set;
            }
            retSet = new TreeSet<IModelElement>();
            for (SimpleModelElement simpleModelElement : this.subtypes) {
                retSet.add(simpleModelElement);
                retSet.addAll(simpleModelElement.getAllSubtypes());
            }
            this.allSubtypes.setObject(this.modelSpace.numberOfChanges, retSet);
            Set<IModelElement> set = retSet;
            return set;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getAllInstances() {
        try {
            this.modelSpace.lock.readLock().lock();
            Set<IModelElement> retSet = this.allInstances.getObject(this.modelSpace.numberOfChanges);
            if (retSet == null) {
                retSet = new HashSet<IModelElement>();
                retSet.addAll(this.instances);
                for (SimpleModelElement simpleModelElement : this.getAllSubtypes()) {
                    retSet.addAll(simpleModelElement.getAllInstances());
                }
                this.allInstances.setObject(this.modelSpace.numberOfChanges, retSet);
            }
            Set<IModelElement> set = retSet;
            return set;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    protected void addNotificationListener(ICoreNotificationListener l) {
        try {
            this.modelSpace.lock.writeLock().lock();
            this.notificationListeners.add(l);
        }
        finally {
            this.modelSpace.lock.writeLock().unlock();
        }
    }

    public void removeNotificationListener(ICoreNotificationListener l) {
        try {
            this.modelSpace.lock.writeLock().lock();
            this.notificationListeners.remove(l);
        }
        finally {
            this.modelSpace.lock.writeLock().unlock();
        }
    }

    public Collection<ICoreNotificationListener> getNotificationListeners() {
        return this.notificationListeners;
    }

    @Override
    public boolean isInstanceOf(IModelElement type) {
        try {
            this.modelSpace.lock.readLock().lock();
            if (!this.type.contains(type)) {
                boolean bl = this.getAllTypes().contains(type);
                return bl;
            }
            return true;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isSupertypeOf(IModelElement sub) {
        try {
            this.modelSpace.lock.readLock().lock();
            if (sub == this) {
                return false;
            }
            boolean bl = this.getAllSubtypes().contains(sub);
            return bl;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isSubtypeOf(IModelElement type) {
        try {
            this.modelSpace.lock.readLock().lock();
            if (type == this) {
                return false;
            }
            boolean bl = type.isSupertypeOf(this);
            return bl;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isTypeOf(IModelElement inst) {
        try {
            this.modelSpace.lock.readLock().lock();
            boolean bl = inst.isInstanceOf(this);
            return bl;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isDirectTypeOf(IModelElement inst) {
        try {
            this.modelSpace.lock.readLock().lock();
            boolean bl = this.getInstances().contains(inst);
            return bl;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isDirectSubtypeOf(IModelElement sup) {
        try {
            this.modelSpace.lock.readLock().lock();
            if (sup == this) {
                return true;
            }
            boolean bl = this.getSupertypes().contains(sup);
            return bl;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isDirectSupertypeOf(IModelElement sub) {
        return sub.isDirectSubtypeOf(this);
    }

    @Override
    public boolean isDirectInstanceOf(IModelElement type) {
        return type.isDirectTypeOf(this);
    }

    @Override
    public String getViewInfo() {
        return this.viewInfo;
    }

    @Override
    public IModelSpace getModelSpace() {
        return this.modelSpace;
    }

    @Override
    public Collection<IRelation> getAllRelationFromByType(IRelation n) {
        return this.getAllElemByType(this.getRelationsFrom(), n);
    }

    @Override
    public Collection<IRelation> getAllRelationToByType(IRelation n) {
        return this.getAllElemByType(this.getRelationsTo(), n);
    }

    @Override
    public Collection<IRelation> getRelationsTo() {
        try {
            this.modelSpace.lock.readLock().lock();
            Set<IRelation> set = this.relationsTo;
            return set;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IRelation> getRelationsFrom() {
        try {
            this.modelSpace.lock.readLock().lock();
            Collection<IRelation> collection = this.relationsFrom.values();
            return collection;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public IRelation getRelationToByType(IModelElement type) {
        return (IRelation)this.getElemByType(this.relationsTo, type);
    }

    @Override
    public IRelation getRelationFromByType(IModelElement type) {
        return (IRelation)this.getElemByType(this.relationsFrom.values(), type);
    }

    @Override
    public IRelation getRelationToByName(String name) {
        return (IRelation)this.getElemByName(this.relationsTo, name);
    }

    @Override
    public IRelation getRelationFromByName(String name) {
        return (IRelation)this.getElemByName(this.relationsFrom.values(), name);
    }

    private IModelElement getElemByName(Collection<? extends IModelElement> elems, String name) {
        try {
            this.modelSpace.lock.readLock().lock();
            for (IModelElement iModelElement : elems) {
                if (!iModelElement.getName().equals(name)) continue;
                IModelElement iModelElement2 = iModelElement;
                return iModelElement2;
            }
            return null;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    private IModelElement getElemByType(Collection<? extends IModelElement> elems, IModelElement type) {
        try {
            this.modelSpace.lock.readLock().lock();
            for (IModelElement iModelElement : elems) {
                if (!iModelElement.getAllTypes().contains(type)) continue;
                IModelElement iModelElement2 = iModelElement;
                return iModelElement2;
            }
            return null;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    private Collection<IRelation> getAllElemByType(Collection<? extends IModelElement> elems, IModelElement type) {
        try {
            this.modelSpace.lock.readLock().lock();
            Iterator<? extends IModelElement> it = elems.iterator();
            ArrayList<IRelation> ret = new ArrayList<IRelation>();
            while (it.hasNext()) {
                IRelation rel = (IRelation)it.next();
                if (!rel.getAllTypes().contains(type)) continue;
                ret.add(rel);
            }
            ArrayList<IRelation> arrayList = ret;
            return arrayList;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public IModelElement getRelationSourceByType(IRelation type) {
        try {
            this.modelSpace.lock.readLock().lock();
            IRelation conn = this.getRelationToByType(type);
            if (conn == null) {
                return null;
            }
            IModelElement iModelElement = conn.getFrom();
            return iModelElement;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getAllRelationSourceByType(IRelation type) {
        try {
            this.modelSpace.lock.readLock().lock();
            Collection<IRelation> conns = this.getAllRelationToByType(type);
            ArrayList<IModelElement> ret = new ArrayList<IModelElement>();
            Iterator<IRelation> it = conns.iterator();
            while (it.hasNext()) {
                ret.add(it.next().getFrom());
            }
            ArrayList<IModelElement> arrayList = ret;
            return arrayList;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IRelation> getRelations() {
        try {
            this.modelSpace.lock.readLock().lock();
            TreeSet<IRelation> retSet = new TreeSet<IRelation>();
            retSet.addAll(this.relationsFrom.values());
            retSet.addAll(this.relationsTo);
            TreeSet<IRelation> treeSet = retSet;
            return treeSet;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public IRelation getRelationByName(String n) {
        return (IRelation)this.getElemByName(this.getRelations(), n);
    }

    @Override
    public IRelation getRelationByType(IModelElement n) {
        return (IRelation)this.getElemByType(this.getRelations(), n);
    }

    @Override
    public IModelElement getRelationTargetByType(IRelation type) {
        IRelation conn = this.getRelationFromByType(type);
        if (conn == null) {
            return null;
        }
        return conn.getTo();
    }

    @Override
    public Collection<IModelElement> getAllRelationTargetByType(IRelation type) {
        try {
            this.modelSpace.lock.readLock().lock();
            Collection<IRelation> conns = this.getAllRelationFromByType(type);
            ArrayList<IModelElement> ret = new ArrayList<IModelElement>();
            Iterator<IRelation> it = conns.iterator();
            while (it.hasNext()) {
                ret.add(it.next().getTo());
            }
            ArrayList<IModelElement> arrayList = ret;
            return arrayList;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public abstract String getFullyQualifiedName();

    @Override
    public IModelElement getElementInNamespaceByName(String name) {
        try {
            this.modelSpace.lock.readLock().lock();
            Long id = this.namespace.get(name);
            if (id != null) {
                IModelElement me = this.relationsFrom.get(id);
                if (me == null && this instanceof SimpleEntity) {
                    me = ((SimpleEntity)this).containment.get(id);
                }
                if (me == null) {
                    throw new VPMCoreInternalRuntimeException();
                }
                IModelElement iModelElement = me;
                return iModelElement;
            }
            return null;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getElementsInNamespace() {
        try {
            this.modelSpace.lock.readLock().lock();
            int size = this.relationsFrom.size();
            if (this instanceof IEntity) {
                size += ((SimpleEntity)this).containment.size();
            }
            ArrayList<IModelElement> ret = new ArrayList<IModelElement>(size);
            for (Long id : this.namespace.values()) {
                IModelElement me = this.relationsFrom.get(id);
                if (me == null && this instanceof SimpleEntity) {
                    me = ((SimpleEntity)this).containment.get(id);
                }
                if (me == null) {
                    throw new VPMCoreInternalRuntimeException();
                }
                ret.add(me);
            }
            ArrayList<IModelElement> arrayList = ret;
            return arrayList;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<IModelElement> getAllElementsInNamespace() {
        try {
            this.modelSpace.lock.readLock().lock();
            ArrayList<IModelElement> ret = new ArrayList<IModelElement>();
            ret.addAll(this.getElementsInNamespace());
            for (IModelElement elem : this.getElementsInNamespace()) {
                ret.addAll(elem.getAllElementsInNamespace());
            }
            ArrayList<IModelElement> arrayList = ret;
            return arrayList;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public boolean isBelowNamespace(IModelElement grandpa) {
        IModelElement namespce = this.getNamespace();
        if (namespce == null) {
            return false;
        }
        if (grandpa.equals(namespce)) {
            return true;
        }
        return namespce.isBelowNamespace(grandpa);
    }

    public Collection<IModelElement> getElementsInRelation(EConstraint relationType) {
        return null;
    }
}

