/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.viatra2.copier.ModelCopy;
import org.eclipse.viatra2.copier.ModelCopyException;
import org.eclipse.viatra2.core.EDeleteSemantics;
import org.eclipse.viatra2.core.EModelElementProperty;
import org.eclipse.viatra2.core.EMultiplicityKind;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.simple.CollectionsDisjunktTester;
import org.eclipse.viatra2.core.simple.SimpleEntity;
import org.eclipse.viatra2.core.simple.SimpleModelElement;
import org.eclipse.viatra2.core.simple.SimpleModelSpace;
import org.eclipse.viatra2.core.simple.SimpleNotificationManager;
import org.eclipse.viatra2.core.simple.SimpleRelation;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectAtomicStepReady;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectCreateEntity;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectCreateInstanceOf;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectCreateRelation;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectCreateSupertypeOf;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectDeleteContainment;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectDeleteEntity;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectDeleteInstanceOf;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectDeleteRelation;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectDeleteSupertypeOf;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectMoreAtomicsToOneAtomEnd;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectMoreAtomicsToOneAtomStart;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectMoveTo;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSetIsAny;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSetIsFinalType;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSetName;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSetRelationFrom;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSetRelationInverse;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSetRelationIsAggregation;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSetRelationMultiplicity;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSetRelationTo;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSetValue;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSetViewInfo;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.errors.VPMCoreNullParameterException;
import org.eclipse.viatra2.errors.VPMCoreRuntimeException;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleModelManager
implements IModelManager {
    private SimpleModelSpace modelSpace;
    private SimpleNotificationManager nManager;
    private Logger logger;
    private ReadWriteLock lock = null;
    public static final String EXCEPTION_TYPE_BETWEEN_DIFFERENT_ELEMENTS = "type between different elements cannot be added: ";
    public static final String EXCEPTION_INSTANCE_BETWEEN_DIFFERENT_ELEMENTS = "instance between different elements cannot be added: ";
    public static final String EXCEPTION_ALREADY_SUPERTYPE = "new supertype: already supertype (may be recursive): ";
    public static final String EXCEPTION_ALREADY_INSTANCE = "new instanceof: already instance (may be recursive): ";
    public static final String EXCEPTION_NEW_SUPERTYPE_CAUSES_CIRCLE = "new supertype: relation would cause circle: ";
    public static final String EXCEPTION_DELETE_SUPERTYPE_EDITOR_NO_RELATION = "deleteSupetypeOf(editor semantics): no direct supertypeOf relation is found: ";
    public static final String EXCEPTION_DELETE_INSTANCEOF_NO_RELATION = "deleteInstanceOf(editor semantics): no direct instanceOf relation is found: ";
    public static final String EXCEPTION_NEW_SUPERTYPE_MAKES_EXISTING_RELATION_IMPLICIT = "new supertype(editor semantics): relation would cause existing relation implicit: ";
    public static final String EXCEPTION_NEW_INSTANCE_MAKES_EXISTING_RELATION_IMPLICIT = "new instance(editor semantics): relation would cause existing relation implicit: ";
    private static final String parameterNullNotAllowed = "Parameter null not allowed";
    private static final String WARNING_DELETE_NOT_SUPERTYPE = "deleteSupertypeOf(machine semantics): no supertypeof between elements: ";
    private boolean stupidMethod = false;
    private static final String WARNING_NAME_CLASH_AT_NAME_CHANGE = "name clash at name change. New name, element, container: ";

    private void checkElemName(String name) throws VPMCoreException {
        if (name.indexOf(46) >= 0) {
            throw new VPMCoreException("Name of element must not contain character dot('.')");
        }
    }

    public void init(Logger l, IModelSpace m) throws VPMRuntimeException {
        this.modelSpace = (SimpleModelSpace)m;
        this.lock = this.modelSpace.lock;
        this.nManager = (SimpleNotificationManager)this.modelSpace.getNotificationManager();
        this.logger = l;
    }

    @Override
    public IEntity getRoot() {
        return this.modelSpace.rootEntity;
    }

    private void deleteBranch(IModelElement root) throws VPMCoreException {
        while (root.getElementsInNamespace().size() > 0) {
            IModelElement me = root.getElementsInNamespace().iterator().next();
            this.deleteBranch(me);
            if (!root.isDeleted()) continue;
            return;
        }
        this.deleteElement(root, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
    }

    @Override
    public void deleteEntity(IEntity e, EDeleteSemantics semantics) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (e == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            if (e == this.modelSpace.ancestorEntity || e == this.modelSpace.ancestorContainer) {
                throw new VPMCoreException("ancestor entity can not be deleted.");
            }
            if (!this.modelSpace.entitiesSet.contains(e)) {
                throw new VPMCoreException("Entity to be deleted not in modelSpace.");
            }
            if (EDeleteSemantics.DELETE_SEMANTICS_BRANCH_FORCE == semantics) {
                this.deleteBranch(e);
                return;
            }
            if (semantics == EDeleteSemantics.DELETE_SEMANTICS_FORCE) {
                if (e.equals(this.getRoot())) {
                    throw new VPMCoreException("Root entity cannot be deleted.");
                }
                this.sendNotification(new NotificationObjectMoreAtomicsToOneAtomStart());
                this.deleteConnections(e, semantics);
                this.deleteFromTypeHierarchy(e);
                IEntity parent = e.getParent();
                this.deleteFromContainer(e);
                this.deleteFromContainerHierarchy(e);
                NotificationObjectDeleteEntity note = new NotificationObjectDeleteEntity((SimpleEntity)e, (SimpleEntity)parent);
                this.modelSpace.entities.remove(((SimpleModelElement)((Object)e)).getLongID());
                this.modelSpace.entitiesSet.remove(e);
                ((SimpleEntity)e).isDeleted = true;
                this.sendNotification(note);
                this.sendNotification(new NotificationObjectMoreAtomicsToOneAtomEnd());
                this.sendNotification(new NotificationObjectAtomicStepReady());
                return;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deleteRelation(IRelation r, EDeleteSemantics semantics) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (r == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            if (r == this.modelSpace.ancestorRelation) {
                throw new VPMCoreException("ancestor relation can not be deleted");
            }
            this._deleteRelation(r, semantics);
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void _deleteRelation(IRelation r, EDeleteSemantics semantics) throws VPMCoreException {
        if (EDeleteSemantics.DELETE_SEMANTICS_BRANCH_FORCE == semantics) {
            this.deleteBranch(r);
            return;
        }
        if (semantics == EDeleteSemantics.DELETE_SEMANTICS_FORCE) {
            SimpleRelation rel = (SimpleRelation)r;
            this.sendNotification(new NotificationObjectMoreAtomicsToOneAtomStart());
            this.deleteFromTypeHierarchy(rel);
            NotificationObjectDeleteRelation note = new NotificationObjectDeleteRelation(rel, (SimpleModelElement)rel.getFrom(), (SimpleModelElement)rel.getTo());
            this.setRelFrom(rel, null);
            this.setRelTo(rel, null);
            this.deleteConnections(rel, semantics);
            this.modelSpace.relations.remove(rel.getLongID());
            this.modelSpace.relationsSet.remove(rel);
            rel.isDeleted = true;
            this.sendNotification(note);
            this.sendNotification(new NotificationObjectMoreAtomicsToOneAtomEnd());
            this.sendNotification(new NotificationObjectAtomicStepReady());
            return;
        }
        throw new VPMCoreRuntimeException("No semantics defined for delete");
    }

    private void deleteFromTypeHierarchy(IModelElement _me) throws VPMCoreException {
        SimpleModelElement me = (SimpleModelElement)_me;
        ArrayList<IModelElement> l = new ArrayList<IModelElement>(me.supertype);
        int i = 0;
        while (i < l.size()) {
            this.deleteSupertypeOfDirect((SimpleModelElement)l.get(i), me);
            ++i;
        }
        l = new ArrayList<IModelElement>(me.subtypes);
        i = 0;
        while (i < l.size()) {
            this.deleteSupertypeOfDirect(me, (SimpleModelElement)l.get(i));
            ++i;
        }
        l = new ArrayList<IModelElement>(me.type);
        i = 0;
        while (i < l.size()) {
            this.deleteInstanceOfDirect((SimpleModelElement)l.get(i), me);
            ++i;
        }
        l = new ArrayList<IModelElement>(me.instances);
        i = 0;
        while (i < l.size()) {
            this.deleteInstanceOfDirect(me, (SimpleModelElement)l.get(i));
            ++i;
        }
    }

    private void deleteFromContainer(IEntity _me) throws VPMCoreNullParameterException, VPMCoreException {
        SimpleEntity me = (SimpleEntity)_me;
        SimpleEntity par = me.parent;
        par.containment.remove(me.getLongID());
        this.removeFromNamespace(par, _me);
        me.parent = null;
        NotificationObjectDeleteContainment note = new NotificationObjectDeleteContainment(par, me);
        this.sendNotification(note);
    }

    private void deleteFromContainerHierarchy(IEntity _me) throws VPMCoreNullParameterException, VPMCoreException {
        SimpleEntity ent = (SimpleEntity)_me;
        ArrayList<IModelElement> children = new ArrayList<IModelElement>(ent.containment.values());
        int i = 0;
        while (i < children.size()) {
            SimpleEntity child = (SimpleEntity)children.get(i);
            this.moveEntityTo(child, this.getRoot());
            ++i;
        }
    }

    private void deleteConnections(IModelElement _ent, EDeleteSemantics semantics) {
        SimpleModelElement ent = (SimpleModelElement)_ent;
        for (SimpleRelation simpleRelation : ent.getRelations()) {
            try {
                this.deleteRelation(simpleRelation, semantics);
            }
            catch (VPMCoreException vPMCoreException) {}
        }
    }

    @Override
    public IModelElement getElementByName(String n) {
        try {
            this.lock.readLock().lock();
            IModelElement weAreHere = this.getRoot();
            while (n != null && !n.equals("") && weAreHere != null) {
                int l = n.indexOf(46);
                int k = l + 1;
                if (l == -1) {
                    k = l = n.length();
                }
                String name = n.substring(0, l);
                weAreHere = weAreHere.getElementInNamespaceByName(name);
                n = n.substring(k);
            }
            IEntity iEntity = weAreHere;
            return iEntity;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public IEntity getEntityByName(String n) {
        IModelElement me = this.getElementByName(n);
        if (me instanceof IEntity) {
            return (IEntity)me;
        }
        return null;
    }

    @Override
    public IRelation getRelationByName(String n) {
        IModelElement me = this.getElementByName(n);
        if (me instanceof IRelation) {
            return (IRelation)me;
        }
        return null;
    }

    @Override
    public IModelElement getElementByID(String n) {
        if (n == null) {
            return null;
        }
        try {
            this.lock.readLock().lock();
            long reqID = 0L;
            try {
                reqID = Long.parseLong(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.lock.readLock().unlock();
                return null;
            }
            if (!n.equals(Long.toString(reqID))) {
                return null;
            }
            IModelElement ret = this.modelSpace.entities.get(reqID);
            if (ret == null) {
                ret = this.modelSpace.relations.get(reqID);
            }
            IModelElement iModelElement = ret;
            return iModelElement;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public IEntity getEntityByID(String n) {
        IModelElement ret = this.getElementByID(n);
        if (ret instanceof IEntity) {
            return (IEntity)ret;
        }
        return null;
    }

    @Override
    public IRelation getRelationByID(String n) {
        IModelElement ret = this.getElementByID(n);
        if (ret instanceof IRelation) {
            return (IRelation)ret;
        }
        return null;
    }

    @Override
    public Set<? extends IEntity> getEntities() {
        try {
            this.lock.readLock().lock();
            Set<SimpleEntity> set = this.modelSpace.entitiesSet;
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<? extends IRelation> getRelations() {
        try {
            this.lock.readLock().lock();
            Set<SimpleRelation> set = this.modelSpace.relationsSet;
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void setElemName(SimpleModelElement ent, String name) {
        ent.name = name;
    }

    private void setRelFrom(SimpleRelation rel, SimpleModelElement from) throws VPMCoreException {
        SimpleModelElement oldRelFrom = (SimpleModelElement)rel.getFrom();
        if (oldRelFrom != null) {
            oldRelFrom.relationsFrom.remove(rel.getLongID());
            this.removeFromNamespace(rel.from, rel);
        }
        rel.from = from;
        if (from != null) {
            from.relationsFrom.put(rel.getLongID(), rel);
            this.addToNamespace(from, rel);
        }
    }

    private void setRelTo(SimpleRelation rel, SimpleModelElement to) {
        SimpleModelElement oldRelTo = (SimpleModelElement)rel.getTo();
        if (oldRelTo != null) {
            oldRelTo.relationsTo.remove(rel);
        }
        rel.to = to;
        if (to != null) {
            to.relationsTo.add(rel);
        }
    }

    private SimpleRelation createRelation(IModelElement from, IModelElement to, String name) throws VPMCoreException {
        this.checkElemName(name);
        this.sendNotification(new NotificationObjectMoreAtomicsToOneAtomStart());
        SimpleRelation newRel = new SimpleRelation(this.modelSpace.newId(), this.modelSpace);
        this.modelSpace.relations.put(newRel.getLongID(), newRel);
        this.modelSpace.relationsSet.add(newRel);
        this.setElemName(newRel, name);
        this.setRelFrom(newRel, (SimpleModelElement)from);
        this.setRelTo(newRel, (SimpleModelElement)to);
        NotificationObjectCreateRelation note = new NotificationObjectCreateRelation(newRel, (SimpleModelElement)from, (SimpleModelElement)to);
        this.sendNotification(note);
        this.sendNotification(new NotificationObjectMoreAtomicsToOneAtomEnd());
        return newRel;
    }

    protected SimpleRelation undoCreateRelation(SimpleRelation rel, SimpleModelElement from, SimpleModelElement to) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            this.modelSpace.relations.put(rel.getLongID(), rel);
            this.modelSpace.relationsSet.add(rel);
            this.setRelFrom(rel, from);
            this.setRelTo(rel, to);
            rel.isDeleted = false;
            NotificationObjectCreateRelation note = new NotificationObjectCreateRelation(rel, from, to);
            this.sendNotification(note);
            SimpleRelation simpleRelation = rel;
            return simpleRelation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private SimpleEntity createEntity(SimpleEntity container, String name, String value) throws VPMCoreException {
        this.checkElemName(name);
        this.sendNotification(new NotificationObjectMoreAtomicsToOneAtomStart());
        SimpleEntity newEnt = new SimpleEntity(this.modelSpace.newId(), this.modelSpace);
        this.modelSpace.entities.put(newEnt.getLongID(), newEnt);
        this.modelSpace.entitiesSet.add(newEnt);
        this.setElemName(newEnt, name);
        newEnt.value = value;
        this.firstContainment(container, newEnt);
        NotificationObjectCreateEntity notification = new NotificationObjectCreateEntity(newEnt, container);
        this.sendNotification(notification);
        this.sendNotification(new NotificationObjectMoreAtomicsToOneAtomEnd());
        return newEnt;
    }

    protected void undoCreateContainment(SimpleEntity container, SimpleEntity me) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            container.containment.put(me.getLongID(), me);
            me.parent = container;
            this.addToNamespace(container, me);
            NotificationObjectMoveTo note = new NotificationObjectMoveTo(me, container, (SimpleEntity)me.getParent());
            this.sendNotification(note);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected SimpleEntity undoCreateEntity(SimpleEntity entity, SimpleEntity parent) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            entity.notificationListeners = new ArrayList();
            this.modelSpace.entities.put(entity.getLongID(), entity);
            this.modelSpace.entitiesSet.add(entity);
            entity.isDeleted = false;
            NotificationObjectCreateEntity notification = new NotificationObjectCreateEntity(entity, parent);
            this.sendNotification(notification);
            SimpleEntity simpleEntity = entity;
            return simpleEntity;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public IEntity newEntity() {
        try {
            return this.newEntity(this.modelSpace.uniqueName(), "", this.getRoot());
        }
        catch (VPMCoreException vPMCoreException) {
            return null;
        }
    }

    @Override
    public IEntity newEntity(IEntity container) throws VPMCoreException {
        return this.newEntity(this.modelSpace.uniqueName(), "", container);
    }

    @Override
    public IEntity newEntity(String name) throws VPMCoreException {
        return this.newEntity(name, "", this.getRoot());
    }

    @Override
    public IEntity newEntity(String name, IEntity container) throws VPMCoreException {
        return this.newEntity(name, "", container);
    }

    @Override
    public IEntity newEntity(String name, String value) throws VPMCoreException {
        return this.newEntity(name, value, this.getRoot());
    }

    @Override
    public IEntity newEntity(String name, String value, IEntity container) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (name == null || container == null || value == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleEntity newEnt = this.createEntity((SimpleEntity)container, name, value);
            this.sendNotification(new NotificationObjectAtomicStepReady());
            SimpleEntity simpleEntity = newEnt;
            return simpleEntity;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public IEntity newEntity(String name, String value, IEntity container, IEntity type) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (name == null) {
                name = this.modelSpace.uniqueName();
            }
            if (value == null) {
                value = "";
            }
            if (container == null) {
                container = this.getRoot();
            }
            IEntity newEnt = this.newEntity(name, value, container);
            if (type != null) {
                this.newInstanceOf(type, newEnt);
            }
            IEntity iEntity = newEnt;
            return iEntity;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public IRelation newRelation(IModelElement from, IModelElement to) throws VPMCoreException {
        return this.newRelation(this.modelSpace.uniqueName(), from, to);
    }

    @Override
    public IRelation newRelation(IModelElement from, IModelElement to, EMultiplicityKind multiplicity, boolean isaggregation, IRelation inverse) throws VPMCoreException {
        return this.newRelation(this.modelSpace.uniqueName(), from, to, multiplicity, isaggregation, inverse);
    }

    @Override
    public IRelation newRelation(String name, IModelElement from, IModelElement to, EMultiplicityKind multiplicity, boolean isaggregation, IRelation inverse) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (from == null || to == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleRelation newRel = this.createRelation(from, to, name);
            newRel.multiplicity = multiplicity;
            newRel.inverse = inverse;
            newRel.isAggregation = isaggregation;
            this.sendNotification(new NotificationObjectAtomicStepReady());
            SimpleRelation simpleRelation = newRel;
            return simpleRelation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public IRelation newRelation(String name, IModelElement from, IModelElement to) throws VPMCoreException {
        return this.newRelation(name, from, to, EMultiplicityKind.MANY_TO_MANY, false, null);
    }

    @Override
    public IRelation newRelation(String name, IModelElement from, IModelElement to, IRelation type) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (name == null) {
                name = this.modelSpace.uniqueName();
            }
            IRelation newRel = this.newRelation(name, from, to);
            if (type != null) {
                this.newInstanceOf(type, newRel);
            }
            IRelation iRelation = newRel;
            return iRelation;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    int getElementType(IModelElement e) {
        if (e instanceof IEntity) {
            return 0;
        }
        if (e instanceof IRelation) {
            return 2;
        }
        return -1;
    }

    @Override
    public void newInstanceOf(IModelElement type, IModelElement inst) throws VPMCoreException {
        this.newInstanceOfMachine(type, inst);
    }

    @Override
    public void newSupertypeOf(IModelElement sup, IModelElement sub) throws VPMCoreException {
        this.newSupertypeOfMachine(sup, sub);
    }

    @Override
    public void newSupertypeOfEditor(IModelElement sup, IModelElement sub) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (sup == null || sub == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleModelElement _sup = (SimpleModelElement)sup;
            SimpleModelElement _sub = (SimpleModelElement)sub;
            if (this.getElementType(sup) != this.getElementType(sub)) {
                throw new VPMCoreException(EXCEPTION_TYPE_BETWEEN_DIFFERENT_ELEMENTS + sup.getFullyQualifiedName() + "," + sub.getFullyQualifiedName());
            }
            if (_sub.getAllSupertypes().contains(_sup)) {
                throw new VPMCoreException(EXCEPTION_ALREADY_SUPERTYPE + sup.getFullyQualifiedName() + "," + sub.getFullyQualifiedName());
            }
            if (_sup.getAllSupertypes().contains(_sub)) {
                throw new VPMCoreException(EXCEPTION_NEW_SUPERTYPE_CAUSES_CIRCLE + sup.getFullyQualifiedName() + "," + sub.getFullyQualifiedName());
            }
            if (!CollectionsDisjunktTester.isDisjunct(_sup.getAllSupertypes(), _sub.supertype) || !CollectionsDisjunktTester.isDisjunct(_sub.getAllSubtypes(), _sup.subtypes)) {
                throw new VPMCoreException(EXCEPTION_NEW_SUPERTYPE_MAKES_EXISTING_RELATION_IMPLICIT + sup.getFullyQualifiedName() + "," + sub.getFullyQualifiedName());
            }
            this.newSupertypeOfDirect(_sup, _sub);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void newInstanceOfEditor(IModelElement type, IModelElement inst) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (type == null || inst == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleModelElement _type = (SimpleModelElement)type;
            SimpleModelElement _inst = (SimpleModelElement)inst;
            if (this.getElementType(type) != this.getElementType(inst)) {
                throw new VPMCoreException(EXCEPTION_INSTANCE_BETWEEN_DIFFERENT_ELEMENTS + type.getFullyQualifiedName() + "," + inst.getFullyQualifiedName());
            }
            if (_inst.getAllTypes().contains(_type)) {
                throw new VPMCoreException(EXCEPTION_ALREADY_INSTANCE + type.getFullyQualifiedName() + "," + inst.getFullyQualifiedName());
            }
            if (!CollectionsDisjunktTester.isDisjunct(_type.getAllSupertypes(), _inst.type)) {
                throw new VPMCoreException(EXCEPTION_NEW_INSTANCE_MAKES_EXISTING_RELATION_IMPLICIT + type.getFullyQualifiedName() + "," + inst.getFullyQualifiedName());
            }
            this.newInstanceOfDirect(_type, _inst);
            if (inst instanceof IRelation) {
                this.checkIsAggregationSemantics((SimpleRelation)inst);
            }
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void newInstanceOfMachine(IModelElement type, IModelElement inst) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (type == null || inst == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleModelElement _type = (SimpleModelElement)type;
            SimpleModelElement _inst = (SimpleModelElement)inst;
            if (this.getElementType(type) != this.getElementType(inst)) {
                throw new VPMCoreException(EXCEPTION_INSTANCE_BETWEEN_DIFFERENT_ELEMENTS + type.getFullyQualifiedName() + "," + inst.getFullyQualifiedName());
            }
            if (_inst.getAllTypes().contains(_type)) {
                return;
            }
            this.newInstanceOfDirect(_type, _inst);
            Collection<Object> col = CollectionsDisjunktTester.sharedElements(_type.getAllSupertypes(), _inst.type);
            for (SimpleModelElement simpleModelElement : col) {
                this.deleteInstanceOfDirect(simpleModelElement, _inst);
            }
            if (inst instanceof IRelation) {
                this.checkIsAggregationSemantics((SimpleRelation)inst);
            }
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void newSupertypeOfMachine(IModelElement _sup, IModelElement _sub) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (_sup == null || _sub == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleModelElement sup = (SimpleModelElement)_sup;
            SimpleModelElement sub = (SimpleModelElement)_sub;
            if (this.getElementType(sup) != this.getElementType(sub)) {
                throw new VPMCoreException(EXCEPTION_TYPE_BETWEEN_DIFFERENT_ELEMENTS + sup.getFullyQualifiedName() + "," + sub.getFullyQualifiedName());
            }
            if (sup == sub || _sub.getAllSupertypes().contains(_sup)) {
                return;
            }
            if (_sup.getAllSupertypes().contains(_sub)) {
                throw new VPMCoreException(EXCEPTION_NEW_SUPERTYPE_CAUSES_CIRCLE + sup.getFullyQualifiedName() + "," + sub.getFullyQualifiedName());
            }
            this.newSupertypeOfDirect(sup, sub);
            Collection<Object> madeImplicit = CollectionsDisjunktTester.sharedElements(sub.supertype, sup.getAllSupertypes());
            for (SimpleModelElement simpleModelElement : madeImplicit) {
                this.deleteSupertypeOfDirect(simpleModelElement, sub);
            }
            madeImplicit = CollectionsDisjunktTester.sharedElements(sup.subtypes, sub.getAllSubtypes());
            for (SimpleModelElement simpleModelElement : madeImplicit) {
                this.deleteSupertypeOfDirect(sup, simpleModelElement);
            }
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void newSupertypeOfDirect(SimpleModelElement sup, SimpleModelElement sub) {
        sup.subtypes.add(sub);
        sub.supertype.add(sup);
        NotificationObjectCreateSupertypeOf note = new NotificationObjectCreateSupertypeOf(sup, sub);
        this.sendNotification(note);
    }

    private void newInstanceOfDirect(SimpleModelElement type, SimpleModelElement inst) {
        type.instances.add(inst);
        inst.type.add(type);
        NotificationObjectCreateInstanceOf note = new NotificationObjectCreateInstanceOf(type, inst);
        this.sendNotification(note);
    }

    private void firstContainment(IEntity cont, IEntity elem) throws VPMCoreException {
        this.sendNotification(new NotificationObjectMoreAtomicsToOneAtomStart());
        this._newContainment(cont, elem);
        this.sendNotification(new NotificationObjectMoreAtomicsToOneAtomEnd());
    }

    private void addToNamespace(IModelElement cont, IModelElement elem) {
        SimpleModelElement e = (SimpleModelElement)elem;
        SimpleModelElement c = (SimpleModelElement)cont;
        String nameKey = e.getName();
        Long id = c.namespace.get(nameKey);
        if (id == null) {
            c.namespace.put(e.getName(), e.getLongID());
        } else {
            String newName = this.modelSpace.uniqueName(e.getName());
            this.log_warn_nameclash(e, c, newName);
            e.name = newName;
            NotificationObjectSetName note = new NotificationObjectSetName(e, newName, nameKey);
            this.sendNotification(note);
            this.addToNamespace(cont, elem);
        }
    }

    private void removeFromNamespace(IModelElement cont, IModelElement elem) {
        ((SimpleModelElement)cont).namespace.remove(elem.getName());
    }

    private void _newContainment(IEntity cont, IEntity elem) throws VPMCoreException {
        SimpleEntity e = (SimpleEntity)elem;
        SimpleEntity c = (SimpleEntity)cont;
        if (e.parent != null) {
            throw new VPMCoreException("core internal error");
        }
        c.containment.put(e.getLongID(), e);
        e.parent = c;
        this.addToNamespace(cont, elem);
    }

    @Override
    public void deleteInstanceOf(IModelElement type, IModelElement inst) throws VPMCoreException {
        this.deleteInstanceOfMachine(type, inst);
    }

    @Override
    public void deleteSupertypeOf(IModelElement sup, IModelElement sub) throws VPMCoreException {
        this.deleteSupertypeOfMachine(sup, sub);
    }

    @Override
    public void deleteSupertypeOfEditor(IModelElement sup, IModelElement sub) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (sup == null || sub == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleModelElement _sup = (SimpleModelElement)sup;
            SimpleModelElement _sub = (SimpleModelElement)sub;
            if (!_sub.supertype.contains(_sup)) {
                throw new VPMCoreException(EXCEPTION_DELETE_SUPERTYPE_EDITOR_NO_RELATION + sup.getFullyQualifiedName() + "," + sub.getFullyQualifiedName());
            }
            this.deleteSupertypeOfDirect(_sup, _sub);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deleteInstanceOfEditor(IModelElement type, IModelElement inst) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (inst == null || type == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleModelElement _type = (SimpleModelElement)type;
            SimpleModelElement _inst = (SimpleModelElement)inst;
            if (!_inst.type.contains(_type)) {
                throw new VPMCoreException(EXCEPTION_DELETE_INSTANCEOF_NO_RELATION + type.getFullyQualifiedName() + "," + inst.getFullyQualifiedName());
            }
            this.deleteInstanceOfDirect(_type, _inst);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deleteInstanceOfMachine(IModelElement type, IModelElement inst) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (inst == null || type == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleModelElement _type = (SimpleModelElement)type;
            SimpleModelElement _inst = (SimpleModelElement)inst;
            boolean isDeleted = false;
            if (_inst.type.contains(_type)) {
                this.deleteInstanceOfDirect(_type, _inst);
                isDeleted = true;
            } else {
                for (SimpleModelElement simpleModelElement : _inst.type) {
                    if (!simpleModelElement.getAllSupertypes().contains(_type)) continue;
                    this.deleteInstanceOfDirect(simpleModelElement, _inst);
                    isDeleted = true;
                }
            }
            if (this.stupidMethod && isDeleted) {
                for (SimpleModelElement simpleModelElement : _type.supertype) {
                    if (_inst.getAllTypes().contains(simpleModelElement)) continue;
                    this.newInstanceOfDirect(simpleModelElement, _inst);
                }
            }
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deleteSupertypeOfMachine(IModelElement sup, IModelElement sub) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (sup == null || sub == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleModelElement _sup = (SimpleModelElement)sup;
            SimpleModelElement _sub = (SimpleModelElement)sub;
            ArrayList<SimpleModelElement> deletedList = new ArrayList<SimpleModelElement>();
            if (_sub.supertype.contains(_sup)) {
                this.deleteSupertypeOfDirect(_sup, _sub);
                deletedList.add(_sup);
            } else {
                for (SimpleModelElement simpleModelElement : _sub.supertype) {
                    if (!simpleModelElement.getAllSupertypes().contains(_sup)) continue;
                    this.deleteSupertypeOfDirect(simpleModelElement, _sub);
                    deletedList.add(simpleModelElement);
                }
            }
            if (this.stupidMethod) {
                if (!deletedList.isEmpty()) {
                    for (SimpleModelElement simpleModelElement : _sup.supertype) {
                        if (_sub.getAllSupertypes().contains(simpleModelElement)) continue;
                        this.newSupertypeOfDirect(simpleModelElement, _sub);
                    }
                }
                int i = 0;
                while (i < deletedList.size()) {
                    SimpleModelElement simpleModelElement = (SimpleModelElement)deletedList.get(i);
                    for (SimpleModelElement simpleModelElement2 : _sub.subtypes) {
                        this.newSupertypeOfDirect(simpleModelElement, simpleModelElement2);
                    }
                    ++i;
                }
            }
            if (deletedList.size() == 0) {
                this.log_warn(WARNING_DELETE_NOT_SUPERTYPE, _sup, _sub);
            } else {
                this.sendNotification(new NotificationObjectAtomicStepReady());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void deleteSupertypeOfDirect(SimpleModelElement sup, SimpleModelElement sub) throws VPMCoreNullParameterException, VPMCoreException {
        sup.subtypes.remove(sub);
        sub.supertype.remove(sup);
        NotificationObjectDeleteSupertypeOf note = new NotificationObjectDeleteSupertypeOf(sup, sub);
        this.sendNotification(note);
    }

    private void deleteInstanceOfDirect(SimpleModelElement type, SimpleModelElement inst) throws VPMCoreNullParameterException, VPMCoreException {
        type.instances.remove(inst);
        inst.type.remove(type);
        NotificationObjectDeleteInstanceOf note = new NotificationObjectDeleteInstanceOf(type, inst);
        this.sendNotification(note);
    }

    @Override
    public void setName(IModelElement e, String n) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (e == null || n == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            this.checkElemName(n);
            this._setName((SimpleModelElement)e, n);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void _setName(SimpleModelElement e, String n) {
        SimpleModelElement elem = e;
        String oldName = elem.getName();
        if (n.equals(oldName)) {
            return;
        }
        SimpleModelElement par = (SimpleModelElement)elem.getNamespace();
        if (par != null) {
            if (par.namespace.get(n) != null) {
                this.log_warn(WARNING_NAME_CLASH_AT_NAME_CHANGE + n, e, par);
                n = this.modelSpace.uniqueName(n);
            }
            this.removeFromNamespace(elem.getNamespace(), elem);
            elem.name = n;
            this.addToNamespace(elem.getNamespace(), elem);
        } else {
            elem.name = n;
        }
        NotificationObjectSetName note = new NotificationObjectSetName(elem, n, oldName);
        this.sendNotification(note);
    }

    @Override
    public void setValue(IEntity e, String v) throws VPMCoreNullParameterException {
        try {
            this.lock.writeLock().lock();
            if (e == null || v == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleEntity ent = (SimpleEntity)e;
            String oldValue = ent.value;
            ent.value = v;
            NotificationObjectSetValue note = new NotificationObjectSetValue(ent, v, oldValue);
            this.sendNotification(note);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void moveEntityTo(IEntity e, IEntity cont) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (e == null || cont == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleEntity ent = (SimpleEntity)e;
            SimpleEntity par = ent.parent;
            if (ent.equals(cont)) {
                throw new VPMCoreException("error in parameters of moveEntityTo: parent and children are equal");
            }
            if (par == cont) {
                return;
            }
            par.containment.remove(ent.getLongID());
            ent.parent = null;
            this.removeFromNamespace(par, ent);
            this._newContainment(cont, e);
            NotificationObjectMoveTo note = new NotificationObjectMoveTo(ent, (SimpleEntity)cont, par);
            this.sendNotification(note);
            this.sendNotification(new NotificationObjectAtomicStepReady());
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void sendNotification(ICoreNotificationObject notification) {
        ++this.modelSpace.numberOfChanges;
        if (this.nManager != null) {
            this.nManager.sendNotification(notification);
        }
    }

    private void log_warn(String s, SimpleModelElement sme, SimpleModelElement sme2) {
        String s1 = sme.getFullyQualifiedName();
        String s2 = sme2.getFullyQualifiedName();
        this.logger.warning(String.valueOf(s) + ":" + s1 + "," + s2);
    }

    private void log_warn_nameclash(SimpleModelElement element_with_old_name, SimpleModelElement container, String new_name) {
        String warn = "The creation / copy / renaming of element '" + element_with_old_name.getFullyQualifiedName() + "' caused name clash in container '" + container.getFullyQualifiedName() + "' and thus it was automatically renamed to '" + new_name + "'";
        this.logger.warning(warn);
    }

    private void checkParameter(IModelElement me) throws VPMCoreException {
        if (me == null) {
            throw new VPMCoreNullParameterException("");
        }
        if (me.isDeleted()) {
            throw new VPMCoreException("parameter already deleted");
        }
    }

    @Override
    public void setRelationFrom(IRelation rel, IModelElement from) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            this.checkParameter(rel);
            this.checkParameter(from);
            if (rel == from) {
                throw new VPMCoreException("edge end must not be itself");
            }
            if (this.checkEdgeCircle(rel, from)) {
                throw new VPMCoreException("edge set from element error: would make infinite fully qualified name");
            }
            SimpleRelation srel = (SimpleRelation)rel;
            SimpleModelElement sfrom = (SimpleModelElement)from;
            NotificationObjectSetRelationFrom no = new NotificationObjectSetRelationFrom((SimpleRelation)rel, (SimpleModelElement)rel.getFrom(), (SimpleModelElement)from);
            this.setRelFrom(srel, sfrom);
            this.sendNotification(no);
            this.checkIsAggregationSemantics(srel);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void checkIsAggregationSemantics(SimpleRelation rel) throws VPMCoreException {
        for (IModelElement me : rel.getTypes()) {
            SimpleRelation tRel;
            if (!(me instanceof SimpleRelation) || !(tRel = (SimpleRelation)me).getIsAggregation()) continue;
            IModelElement to = rel.getTo();
            IModelElement from = rel.getFrom();
            if (!to.getNamespace().equals(from) && to instanceof IEntity && from instanceof IEntity) {
                if (!to.equals(from)) {
                    this.moveEntityTo((IEntity)to, (IEntity)from);
                    this.log_warn("isAggregation=true set for " + rel.getFullyQualifiedName() + "'s type (" + tRel.getFullyQualifiedName() + "), containment should hold for ", (SimpleModelElement)to, (SimpleModelElement)from);
                } else {
                    this.log_warn("isAggregation=true set for " + rel.getFullyQualifiedName() + "'s type (" + tRel.getFullyQualifiedName() + "), containment should hold (but source and target are the same) for ", (SimpleModelElement)to, (SimpleModelElement)from);
                }
            }
            return;
        }
    }

    @Override
    public void setRelationTo(IRelation rel, IModelElement to) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (rel == to) {
                throw new VPMCoreException("edge end must not be itself");
            }
            SimpleRelation srel = (SimpleRelation)rel;
            SimpleModelElement sto = (SimpleModelElement)to;
            NotificationObjectSetRelationTo no = new NotificationObjectSetRelationTo((SimpleRelation)rel, (SimpleModelElement)rel.getTo(), (SimpleModelElement)to);
            this.setRelTo(srel, sto);
            this.sendNotification(no);
            this.checkIsAggregationSemantics(srel);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setViewInfo(IModelElement me, String viewInfo) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            SimpleModelElement _me = (SimpleModelElement)me;
            this.sendNotification(new NotificationObjectSetViewInfo(me, me.getViewInfo(), viewInfo));
            _me.viewInfo = viewInfo;
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deleteElement(IModelElement me, EDeleteSemantics semantics) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (me instanceof IEntity) {
                this.deleteEntity((IEntity)me, semantics);
            } else {
                this.deleteRelation((IRelation)me, semantics);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkEdgeCircle(IRelation rel, IModelElement from) {
        try {
            while (true) {
                if (from instanceof IEntity) {
                    return false;
                }
                if (from == rel) {
                    return true;
                }
                if (from == null) {
                    this.logger.fatal("Gaz van: " + rel.getFullyQualifiedName());
                    return false;
                }
                from = ((IRelation)from).getFrom();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void setRelationMultiplicity(IRelation rel, EMultiplicityKind multiplicity) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            SimpleRelation _rel = (SimpleRelation)rel;
            _rel.multiplicity = multiplicity;
            NotificationObjectSetRelationMultiplicity note = new NotificationObjectSetRelationMultiplicity(_rel, multiplicity);
            this.sendNotification(note);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setRelationIsAggregation(IRelation rel, boolean isaggregation) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            SimpleRelation _rel = (SimpleRelation)rel;
            _rel.isAggregation = isaggregation;
            NotificationObjectSetRelationIsAggregation note = new NotificationObjectSetRelationIsAggregation(rel, isaggregation);
            this.sendNotification(note);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setRelationInverse(IRelation rel, IRelation inverse) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            SimpleRelation _rel = (SimpleRelation)rel;
            _rel.inverse = inverse;
            NotificationObjectSetRelationInverse note = new NotificationObjectSetRelationInverse(rel, inverse);
            this.sendNotification(note);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setIsFinalType(IModelElement me, boolean isfinaltype) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (me == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleModelElement sme = (SimpleModelElement)me;
            NotificationObjectSetIsFinalType note = new NotificationObjectSetIsFinalType(me, isfinaltype, sme.isFinalType);
            sme.isFinalType = isfinaltype;
            this.sendNotification(note);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setIsAnyFrom(IRelation me, boolean isAnyFrom) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (me == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleRelation srel = (SimpleRelation)me;
            NotificationObjectSetIsAny note = new NotificationObjectSetIsAny(me, isAnyFrom, true, srel.isAnyFrom);
            srel.isAnyFrom = isAnyFrom;
            this.sendNotification(note);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void setIsAnyTo(IRelation me, boolean isAnyTo) throws VPMCoreException {
        try {
            this.lock.writeLock().lock();
            if (me == null) {
                throw new VPMCoreNullParameterException(parameterNullNotAllowed);
            }
            SimpleRelation srel = (SimpleRelation)me;
            NotificationObjectSetIsAny note = new NotificationObjectSetIsAny(me, isAnyTo, false, srel.isAnyTo);
            srel.isAnyTo = isAnyTo;
            this.sendNotification(note);
            this.sendNotification(new NotificationObjectAtomicStepReady());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<? extends IModelElement> getElements() {
        try {
            this.lock.readLock().lock();
            TreeSet<SimpleModelElement> ret = new TreeSet<SimpleModelElement>();
            ret.addAll(this.modelSpace.entitiesSet);
            ret.addAll(this.modelSpace.relationsSet);
            TreeSet<SimpleModelElement> treeSet = ret;
            return treeSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void setProperty(IModelElement me, EModelElementProperty property, Object value) throws VPMCoreException {
        switch (property) {
            case Name: {
                this.setName(me, (String)value);
                break;
            }
            case Value: {
                this.setValue((IEntity)me, (String)value);
                break;
            }
            default: {
                this.logger.warning("Set property not implemented:" + me + "(" + (Object)((Object)property) + ")=" + value);
            }
        }
    }

    @Override
    public IModelElement copyModelElement(IModelElement source, IModelElement destinationContainer, boolean copyOutEdges) throws VPMCoreException {
        try {
            return ModelCopy.copyModel(this.modelSpace, this.modelSpace, source, destinationContainer, copyOutEdges);
        }
        catch (ModelCopyException e) {
            throw new VPMCoreException("error performing copy: " + e.getMessage());
        }
    }

    @Override
    public IModelElement copyModelElements(Set<IModelElement> sourceElements, IModelElement sourceRoot, IModelElement destinationContainer, boolean copyOutEdges) throws VPMCoreException {
        try {
            return ModelCopy.copyModels(sourceElements, this.modelSpace, this.modelSpace, sourceRoot, destinationContainer, copyOutEdges);
        }
        catch (ModelCopyException e) {
            throw new VPMCoreException("error performing copy: " + e.getMessage());
        }
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

