/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.simple;

import org.eclipse.viatra2.core.EMultiplicityKind;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.simple.SimpleModelElement;
import org.eclipse.viatra2.core.simple.SimpleModelSpace;

public class SimpleRelation
extends SimpleModelElement
implements IRelation {
    protected SimpleModelElement from = null;
    protected SimpleModelElement to = null;
    protected EMultiplicityKind multiplicity = EMultiplicityKind.MANY_TO_MANY;
    protected IRelation inverse = null;
    protected boolean isAggregation = false;
    protected boolean isAnyFrom = false;
    protected boolean isAnyTo = false;

    public SimpleRelation(long ID, SimpleModelSpace ms) {
        super(ID, ms);
    }

    public IModelElement getFrom() {
        try {
            this.modelSpace.lock.readLock().lock();
            SimpleModelElement simpleModelElement = this.from;
            return simpleModelElement;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    public IModelElement getTo() {
        try {
            this.modelSpace.lock.readLock().lock();
            SimpleModelElement simpleModelElement = this.to;
            return simpleModelElement;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    public String getFullyQualifiedName() {
        try {
            this.modelSpace.lock.readLock().lock();
            if (this.from == null) {
                return null;
            }
            String name = this.getName();
            String string = name = String.valueOf(this.from.getFullyQualifiedName()) + "." + name;
            return string;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    public IModelElement getNamespace() {
        try {
            this.modelSpace.lock.readLock().lock();
            SimpleModelElement simpleModelElement = this.from;
            return simpleModelElement;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    public EMultiplicityKind getMultiplicity() {
        try {
            this.modelSpace.lock.readLock().lock();
            EMultiplicityKind eMultiplicityKind = this.multiplicity;
            return eMultiplicityKind;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    public IRelation getInverse() {
        try {
            this.modelSpace.lock.readLock().lock();
            IRelation iRelation = this.inverse;
            return iRelation;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    public boolean getIsAggregation() {
        try {
            this.modelSpace.lock.readLock().lock();
            boolean bl = this.isAggregation;
            return bl;
        }
        finally {
            this.modelSpace.lock.readLock().unlock();
        }
    }

    public boolean getIsAnyFrom() {
        return this.isAnyFrom;
    }

    public boolean getIsAnyTo() {
        return this.isAnyTo;
    }

    public boolean isEntity() {
        return false;
    }

    public boolean isRelation() {
        return true;
    }
}

