/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.simple;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IPause;
import org.eclipse.viatra2.core.ITransactionManager;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.simple.Pause;
import org.eclipse.viatra2.core.simple.SimpleModelSpace;
import org.eclipse.viatra2.core.simple.SimpleUndoManager;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSubTransactionAbort;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSubTransactionBegin;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectSubTransactionEnd;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectTransactionAbort;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectTransactionBegin;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectTransactionEnd;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUndoBegin;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUndoEnd;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUndoableTransactionBegin;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.logger.Logger;

public class SimpleTransactionManager
implements ITransactionManager,
ICoreNotificationListener {
    private int transactionCounter = 0;
    private ReentrantLock tLock = new ReentrantLock();
    protected SimpleUndoManager uManager;
    SimpleModelSpace modelSpace;
    protected TransactionState iState = TransactionState.DEFAULT;

    public SimpleUndoManager getUndoManager() {
        return this.uManager;
    }

    public void init(Logger l, SimpleModelSpace m) throws VPMRuntimeException {
        this.uManager = new SimpleUndoManager();
        this.modelSpace = m;
        this.uManager.init(l, m);
    }

    public String beginTransaction() {
        this.tLock.lock();
        this.iState = TransactionState.IN_TRANSACTION;
        if (this.tLock.getHoldCount() == 1) {
            this.modelSpace.nManager.sendNotification(new NotificationObjectTransactionBegin());
        } else {
            this.modelSpace.nManager.sendNotification(new NotificationObjectSubTransactionBegin());
        }
        return "TRANS_" + this.transactionCounter++;
    }

    public String beginTransaction(Object info) {
        this.tLock.lock();
        this.iState = TransactionState.IN_TRANSACTION;
        if (this.tLock.getHoldCount() == 1) {
            this.modelSpace.nManager.sendNotification(new NotificationObjectTransactionBegin(info));
        } else {
            this.modelSpace.nManager.sendNotification(new NotificationObjectSubTransactionBegin(info));
        }
        return "TRANS_" + this.transactionCounter++;
    }

    public String beginUndoableTransaction() {
        this.tLock.lock();
        this.iState = TransactionState.IN_UNDOABLE_TRANSACTION;
        if (this.tLock.getHoldCount() == 1) {
            this.modelSpace.nManager.sendNotification(new NotificationObjectUndoableTransactionBegin());
        } else {
            this.modelSpace.nManager.sendNotification(new NotificationObjectSubTransactionBegin());
        }
        String id = "TRANS_" + this.transactionCounter++;
        this.uManager.nextUndoBlock(id);
        return id;
    }

    public String beginUndoableTransaction(Object info) {
        this.tLock.lock();
        this.iState = TransactionState.IN_UNDOABLE_TRANSACTION;
        if (this.tLock.getHoldCount() == 1) {
            this.modelSpace.nManager.sendNotification(new NotificationObjectUndoableTransactionBegin(info));
        } else {
            this.modelSpace.nManager.sendNotification(new NotificationObjectSubTransactionBegin(info));
        }
        String id = "TRANS_" + this.transactionCounter++;
        this.uManager.nextUndoBlock(id);
        return id;
    }

    public void commitTransaction() {
        if (this.tLock.getHoldCount() == 1) {
            this.iState = TransactionState.DEFAULT;
            this.tLock.unlock();
            this.modelSpace.nManager.sendNotification(new NotificationObjectTransactionEnd());
        } else {
            this.tLock.unlock();
            this.modelSpace.nManager.sendNotification(new NotificationObjectSubTransactionEnd());
        }
    }

    public void commitCompositeTransaction() {
        if (this.tLock.getHoldCount() == 0) {
            return;
        }
        if (this.tLock.getHoldCount() == 1) {
            this.commitTransaction();
        } else {
            int i = this.tLock.getHoldCount();
            while (i > 0) {
                this.commitTransaction();
                --i;
            }
        }
    }

    public void abortTransaction() {
        if (this.tLock.getHoldCount() == 1) {
            this.iState = TransactionState.DEFAULT;
            this.tLock.unlock();
            this.modelSpace.nManager.sendNotification(new NotificationObjectTransactionAbort());
        } else {
            this.tLock.unlock();
            this.modelSpace.nManager.sendNotification(new NotificationObjectSubTransactionAbort());
        }
    }

    public boolean tryBeginTransaction() {
        return this.tLock.tryLock();
    }

    public IPause pauseTransaction() throws IllegalMonitorStateException {
        if (this.tLock.isHeldByCurrentThread()) {
            int c = this.tLock.getHoldCount();
            Pause ret = new Pause(c);
            int i = 0;
            while (i < c) {
                this.commitTransaction();
                ++i;
            }
            return ret;
        }
        throw new IllegalMonitorStateException("owner of lock is not this thread");
    }

    public void unPauseTransaction(IPause n) {
        Pause ret = (Pause)n;
        int i = 0;
        while (i < ret.n) {
            this.beginTransaction();
            ++i;
        }
    }

    public void undoTransaction(String aTransactionID) {
        this.modelSpace.nManager.sendNotification(new NotificationObjectUndoBegin());
        this.uManager.undo(aTransactionID);
        this.modelSpace.nManager.sendNotification(new NotificationObjectUndoEnd());
    }

    public void actionPerformed(ICoreNotificationObject notification) {
        if (this.iState == TransactionState.IN_UNDOABLE_TRANSACTION) {
            this.uManager.actionPerformed(notification);
        }
    }

    public int getListenerCategory() {
        return this.uManager.getListenerCategory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransactionState {
        DEFAULT,
        IN_UNDOABLE_TRANSACTION,
        IN_TRANSACTION,
        PAUSED;

    }
}

